## ----setup, include = FALSE---------------------------------------------------
LOCAL <- identical(Sys.getenv("LOCAL"), "TRUE")
knitr::opts_chunk$set(purl = LOCAL, collapse = TRUE, comment = "#>")
suppressPackageStartupMessages(library(SelectBoost.beta))
set.seed(2024)

## ----cache=TRUE, eval=LOCAL---------------------------------------------------
sim <- simulation_DATA.beta(n = 120, p = 6, s = 3, rho = 0.35,
  beta_size = c(1.1, -0.9, 0.7))
str(sim$X)
summary(sim$Y)

## ----cache=TRUE, eval=LOCAL---------------------------------------------------
sb <- sb_beta(sim$X, sim$Y, B = 40, step.num = 0.4, seed = 99)
sb

## ----cache=TRUE, eval=LOCAL---------------------------------------------------
attr(sb, "c0.seq")
attr(sb, "B")
attr(sb, "interval")

## ----cache=TRUE, eval=LOCAL---------------------------------------------------
summary(sb)
if (requireNamespace("ggplot2", quietly = TRUE)) {
  autoplot.sb_beta(sb)
}

## ----cache=TRUE, eval=LOCAL---------------------------------------------------
single <- compare_selectors_single(sim$X, sim$Y, include_enet = FALSE)
head(single$table)

## ----cache=TRUE, eval=LOCAL---------------------------------------------------
freq <- suppressWarnings(compare_selectors_bootstrap(sim$X, sim$Y, B = 100, 
                                                     include_enet = FALSE, seed = 99))
head(freq)

## ----cache=TRUE, eval=LOCAL---------------------------------------------------
compare_table(single$table, freq)

## ----cache=TRUE, eval=LOCAL---------------------------------------------------
y_low <- pmax(sim$Y - 0.05, 0)
y_high <- pmin(sim$Y + 0.05, 1)
interval_fit <- sb_beta_interval(sim$X, y_low, y_high, B = 30,
  sample = "uniform", seed = 321)
attr(interval_fit, "interval")

