/*
 * Decompiled with CFR 0.152.
 */
package jdplus.x13.base.core.x11;

import java.util.Arrays;
import java.util.function.IntToDoubleFunction;
import jdplus.sa.base.api.DecompositionMode;
import jdplus.toolkit.base.api.data.DoubleSeq;
import jdplus.toolkit.base.api.data.Doubles;
import jdplus.toolkit.base.api.timeseries.TsData;
import jdplus.toolkit.base.core.data.DataBlock;
import jdplus.toolkit.base.core.data.analysis.DiscreteKernel;
import jdplus.toolkit.base.core.math.linearfilters.AsymmetricFiltersFactory;
import jdplus.toolkit.base.core.math.linearfilters.IFiniteFilter;
import jdplus.toolkit.base.core.math.linearfilters.LocalPolynomialFilters;
import jdplus.toolkit.base.core.math.linearfilters.SymmetricFilter;
import jdplus.x13.base.api.x11.BiasCorrection;
import jdplus.x13.base.api.x11.CalendarSigmaOption;
import jdplus.x13.base.api.x11.SeasonalFilterOption;
import jdplus.x13.base.api.x11.SigmaVecOption;
import jdplus.x13.base.api.x11.X11Exception;
import jdplus.x13.base.api.x11.X11Spec;
import jdplus.x13.base.core.x11.extremevaluecorrector.Cochran;
import jdplus.x13.base.core.x11.extremevaluecorrector.DefaultExtremeValuesCorrector;
import jdplus.x13.base.core.x11.extremevaluecorrector.GroupSpecificExtremeValuesCorrector;
import jdplus.x13.base.core.x11.extremevaluecorrector.IExtremeValuesCorrector;
import jdplus.x13.base.core.x11.extremevaluecorrector.PeriodSpecificExtremeValuesCorrector;
import lombok.Generated;
import lombok.NonNull;
import org.jspecify.annotations.Nullable;

public final class X11Context {
    @NonNull
    private final DecompositionMode mode;
    private final int period;
    private final int trendFilterLength;
    private final int localPolynomialDegree;
    private final boolean seasonal;
    private final SeasonalFilterOption[] initialSeasonalFilter;
    private final SeasonalFilterOption[] finalSeasonalFilter;
    private final double lowerSigma;
    private final double upperSigma;
    private final CalendarSigmaOption calendarSigma;
    private final SigmaVecOption[] sigmavecOptions;
    private final int forecastHorizon;
    private final int backcastHorizon;
    private final int firstPeriod;
    private final boolean excludefcast;
    private final BiasCorrection bias;
    private IExtremeValuesCorrector extremeValuesCorrector;
    private static final double SQRPI = Math.sqrt(Math.PI);

    public static Builder builder() {
        Builder builder = new Builder();
        builder.mode = DecompositionMode.Multiplicative;
        builder.seasonal = true;
        builder.trendFilterLength = 13;
        builder.localPolynomialDegree = 3;
        builder.period = 1;
        builder.initialSeasonalFilter = new SeasonalFilterOption[]{SeasonalFilterOption.S3X3};
        builder.finalSeasonalFilter = new SeasonalFilterOption[]{SeasonalFilterOption.S3X5};
        builder.calendarSigma = CalendarSigmaOption.None;
        builder.lowerSigma = 1.5;
        builder.upperSigma = 2.5;
        builder.firstPeriod = 0;
        builder.bias = BiasCorrection.Legacy;
        return builder;
    }

    public static X11Context of(@NonNull X11Spec spec, @NonNull TsData data) {
        SeasonalFilterOption[] filters;
        if (spec == null) {
            throw new NullPointerException("spec is marked non-null but is null");
        }
        if (data == null) {
            throw new NullPointerException("data is marked non-null but is null");
        }
        if (!spec.isSeasonal()) {
            filters = null;
        } else if (spec.getFilters().length == 1) {
            filters = new SeasonalFilterOption[data.getAnnualFrequency()];
            SeasonalFilterOption filter = spec.getFilters()[0];
            for (int i = 0; i < data.getAnnualFrequency(); ++i) {
                filters[i] = filter;
            }
        } else {
            filters = spec.getFilters();
        }
        int p = data.getAnnualFrequency();
        int nb = spec.getBackcastHorizon();
        int nf = spec.getForecastHorizon();
        if (nb < 0) {
            nb = -nb * p;
        }
        if (nf < 0) {
            nf = -nf * p;
        }
        return X11Context.builder().mode(spec.getMode()).seasonal(spec.isSeasonal()).trendFilterLength(spec.getHendersonFilterLength()).period(p).firstPeriod(data.getStart().annualPosition()).lowerSigma(spec.getLowerSigma()).upperSigma(spec.getUpperSigma()).calendarSigma(spec.getCalendarSigma()).sigmavecOptions(spec.getSigmaVec()).excludefcast(spec.isExcludeForecast()).forecastHorizon(nf).backcastHorizon(nb).initialSeasonalFilter(filters).finalSeasonalFilter(filters).bias(spec.getBias()).build();
    }

    public boolean isAutomaticHenderson() {
        return this.trendFilterLength == 0;
    }

    public boolean isMultiplicative() {
        return this.mode == DecompositionMode.Multiplicative || this.mode == DecompositionMode.PseudoAdditive;
    }

    public boolean isLogAdd() {
        return this.mode == DecompositionMode.LogAdditive;
    }

    public boolean isPseudoAdd() {
        return this.mode == DecompositionMode.PseudoAdditive;
    }

    public int getPosition(int idx) {
        return idx == 0 ? this.firstPeriod : (this.firstPeriod + idx) % this.period;
    }

    public DoubleSeq remove(DoubleSeq l, DoubleSeq r) {
        if (this.isMultiplicative()) {
            return DoubleSeq.onMapping((int)l.length(), i -> l.get(i) / r.get(i));
        }
        return DoubleSeq.onMapping((int)l.length(), i -> l.get(i) - r.get(i));
    }

    public DoubleSeq add(DoubleSeq l, DoubleSeq r) {
        if (this.isMultiplicative()) {
            return DoubleSeq.onMapping((int)l.length(), i -> l.get(i) * r.get(i));
        }
        return DoubleSeq.onMapping((int)l.length(), i -> l.get(i) + r.get(i));
    }

    public void remove(DoubleSeq l, DoubleSeq r, DataBlock q) {
        if (this.isMultiplicative()) {
            q.set(l, r, (x, y) -> x / y);
        } else {
            q.set(l, r, (x, y) -> x - y);
        }
    }

    public void add(DoubleSeq l, DoubleSeq r, DataBlock q) {
        if (this.isMultiplicative()) {
            q.set(l, r, (x, y) -> x * y);
        } else {
            q.set(l, r, (x, y) -> x + y);
        }
    }

    public SymmetricFilter trendFilter() {
        return this.trendFilter(this.trendFilterLength);
    }

    public SymmetricFilter trendFilter(int filterLength) {
        int horizon = filterLength / 2;
        IntToDoubleFunction weights = DiscreteKernel.henderson((int)horizon);
        return LocalPolynomialFilters.of((int)horizon, (int)this.localPolynomialDegree, (IntToDoubleFunction)weights);
    }

    public IFiniteFilter[] asymmetricTrendFilters(SymmetricFilter sfilter, double ic) {
        double d = 2.0 / (SQRPI * ic);
        int horizon = sfilter.getUpperBound();
        int u = 0;
        double[] c = new double[]{d};
        IFiniteFilter[] afilters = new IFiniteFilter[horizon];
        for (int i = 0; i < afilters.length; ++i) {
            afilters[horizon - i - 1] = AsymmetricFiltersFactory.mmsreFilter2((SymmetricFilter)sfilter, (int)i, (int)u, (double[])c, null);
        }
        return afilters;
    }

    public IExtremeValuesCorrector selectExtremeValuesCorrector(DoubleSeq dsToTest) {
        if (this.calendarSigma == CalendarSigmaOption.Signif) {
            Cochran cochranTest = new Cochran(dsToTest, this);
            boolean testResult = cochranTest.getTestResult();
            this.extremeValuesCorrector = !testResult ? new PeriodSpecificExtremeValuesCorrector() : new DefaultExtremeValuesCorrector();
        }
        return this.getExtremeValuesCorrector();
    }

    public IExtremeValuesCorrector getExtremeValuesCorrector() {
        if (this.extremeValuesCorrector == null) {
            switch (this.calendarSigma) {
                case All: {
                    this.extremeValuesCorrector = new PeriodSpecificExtremeValuesCorrector();
                    break;
                }
                case Signif: {
                    break;
                }
                case Select: {
                    this.extremeValuesCorrector = new GroupSpecificExtremeValuesCorrector(this.sigmavecOptions);
                    break;
                }
                default: {
                    this.extremeValuesCorrector = new DefaultExtremeValuesCorrector();
                }
            }
        }
        return this.extremeValuesCorrector;
    }

    public boolean isMSR() {
        for (SeasonalFilterOption option : this.finalSeasonalFilter) {
            if (SeasonalFilterOption.Msr.equals((Object)option)) continue;
            return false;
        }
        return true;
    }

    public SeasonalFilterOption[] getInitialSeasonalFilter() {
        SeasonalFilterOption[] result = new SeasonalFilterOption[this.period];
        for (int i = 0; i < this.period; ++i) {
            result[i] = this.initialSeasonalFilter[i];
            if (!SeasonalFilterOption.Msr.equals((Object)this.initialSeasonalFilter[i]) && !SeasonalFilterOption.X11Default.equals((Object)this.initialSeasonalFilter[i])) continue;
            result[i] = SeasonalFilterOption.S3X3;
        }
        return result;
    }

    public SeasonalFilterOption[] getFinalSeasonalFilter() {
        if (this.finalSeasonalFilter == null) {
            return null;
        }
        SeasonalFilterOption[] result = new SeasonalFilterOption[this.period];
        for (int i = 0; i < this.period; ++i) {
            result[i] = this.finalSeasonalFilter[i];
            if (!SeasonalFilterOption.Msr.equals((Object)this.finalSeasonalFilter[i]) && !SeasonalFilterOption.X11Default.equals((Object)this.finalSeasonalFilter[i])) continue;
            result[i] = SeasonalFilterOption.S3X5;
        }
        return result;
    }

    public static DoubleSeq makePositivity(DoubleSeq in) {
        double[] stc = in.toArray();
        int n = in.length();
        for (int i = 0; i < n; ++i) {
            int after;
            int before;
            if (!(stc[i] <= 0.0)) continue;
            for (before = i - 1; before >= 0 && stc[before] <= 0.0; --before) {
            }
            for (after = i + 1; after < n && stc[after] <= 0.0; ++after) {
            }
            if (before < 0 && after >= n) {
                throw new X11Exception("Negative series");
            }
            double m = before >= 0 && after < n ? (stc[before] + stc[after]) / 2.0 : (after >= n ? stc[before] : stc[after]);
            stc[i] = m;
        }
        return Doubles.of((double[])stc);
    }

    @Generated
    X11Context(@NonNull DecompositionMode mode, int period, int trendFilterLength, int localPolynomialDegree, boolean seasonal, SeasonalFilterOption[] initialSeasonalFilter, SeasonalFilterOption[] finalSeasonalFilter, double lowerSigma, double upperSigma, CalendarSigmaOption calendarSigma, SigmaVecOption[] sigmavecOptions, int forecastHorizon, int backcastHorizon, int firstPeriod, boolean excludefcast, BiasCorrection bias, IExtremeValuesCorrector extremeValuesCorrector) {
        if (mode == null) {
            throw new NullPointerException("mode is marked non-null but is null");
        }
        this.mode = mode;
        this.period = period;
        this.trendFilterLength = trendFilterLength;
        this.localPolynomialDegree = localPolynomialDegree;
        this.seasonal = seasonal;
        this.initialSeasonalFilter = initialSeasonalFilter;
        this.finalSeasonalFilter = finalSeasonalFilter;
        this.lowerSigma = lowerSigma;
        this.upperSigma = upperSigma;
        this.calendarSigma = calendarSigma;
        this.sigmavecOptions = sigmavecOptions;
        this.forecastHorizon = forecastHorizon;
        this.backcastHorizon = backcastHorizon;
        this.firstPeriod = firstPeriod;
        this.excludefcast = excludefcast;
        this.bias = bias;
        this.extremeValuesCorrector = extremeValuesCorrector;
    }

    @NonNull
    @Generated
    public DecompositionMode getMode() {
        return this.mode;
    }

    @Generated
    public int getPeriod() {
        return this.period;
    }

    @Generated
    public int getTrendFilterLength() {
        return this.trendFilterLength;
    }

    @Generated
    public int getLocalPolynomialDegree() {
        return this.localPolynomialDegree;
    }

    @Generated
    public boolean isSeasonal() {
        return this.seasonal;
    }

    @Generated
    public double getLowerSigma() {
        return this.lowerSigma;
    }

    @Generated
    public double getUpperSigma() {
        return this.upperSigma;
    }

    @Generated
    public CalendarSigmaOption getCalendarSigma() {
        return this.calendarSigma;
    }

    @Generated
    public SigmaVecOption[] getSigmavecOptions() {
        return this.sigmavecOptions;
    }

    @Generated
    public int getForecastHorizon() {
        return this.forecastHorizon;
    }

    @Generated
    public int getBackcastHorizon() {
        return this.backcastHorizon;
    }

    @Generated
    public boolean isExcludefcast() {
        return this.excludefcast;
    }

    @Generated
    public BiasCorrection getBias() {
        return this.bias;
    }

    @Generated
    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof X11Context)) {
            return false;
        }
        X11Context other = (X11Context)o;
        if (this.getPeriod() != other.getPeriod()) {
            return false;
        }
        if (this.getTrendFilterLength() != other.getTrendFilterLength()) {
            return false;
        }
        if (this.getLocalPolynomialDegree() != other.getLocalPolynomialDegree()) {
            return false;
        }
        if (this.isSeasonal() != other.isSeasonal()) {
            return false;
        }
        if (Double.compare(this.getLowerSigma(), other.getLowerSigma()) != 0) {
            return false;
        }
        if (Double.compare(this.getUpperSigma(), other.getUpperSigma()) != 0) {
            return false;
        }
        if (this.getForecastHorizon() != other.getForecastHorizon()) {
            return false;
        }
        if (this.getBackcastHorizon() != other.getBackcastHorizon()) {
            return false;
        }
        if (this.getFirstPeriod() != other.getFirstPeriod()) {
            return false;
        }
        if (this.isExcludefcast() != other.isExcludefcast()) {
            return false;
        }
        DecompositionMode this$mode = this.getMode();
        DecompositionMode other$mode = other.getMode();
        if (this$mode == null ? other$mode != null : !this$mode.equals(other$mode)) {
            return false;
        }
        if (!Arrays.deepEquals(this.getInitialSeasonalFilter(), other.getInitialSeasonalFilter())) {
            return false;
        }
        if (!Arrays.deepEquals(this.getFinalSeasonalFilter(), other.getFinalSeasonalFilter())) {
            return false;
        }
        CalendarSigmaOption this$calendarSigma = this.getCalendarSigma();
        CalendarSigmaOption other$calendarSigma = other.getCalendarSigma();
        if (this$calendarSigma == null ? other$calendarSigma != null : !this$calendarSigma.equals(other$calendarSigma)) {
            return false;
        }
        if (!Arrays.deepEquals(this.getSigmavecOptions(), other.getSigmavecOptions())) {
            return false;
        }
        BiasCorrection this$bias = this.getBias();
        BiasCorrection other$bias = other.getBias();
        if (this$bias == null ? other$bias != null : !this$bias.equals(other$bias)) {
            return false;
        }
        IExtremeValuesCorrector this$extremeValuesCorrector = this.getExtremeValuesCorrector();
        IExtremeValuesCorrector other$extremeValuesCorrector = other.getExtremeValuesCorrector();
        return !(this$extremeValuesCorrector == null ? other$extremeValuesCorrector != null : !this$extremeValuesCorrector.equals(other$extremeValuesCorrector));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getPeriod();
        result = result * 59 + this.getTrendFilterLength();
        result = result * 59 + this.getLocalPolynomialDegree();
        result = result * 59 + (this.isSeasonal() ? 79 : 97);
        long $lowerSigma = Double.doubleToLongBits(this.getLowerSigma());
        result = result * 59 + (int)($lowerSigma >>> 32 ^ $lowerSigma);
        long $upperSigma = Double.doubleToLongBits(this.getUpperSigma());
        result = result * 59 + (int)($upperSigma >>> 32 ^ $upperSigma);
        result = result * 59 + this.getForecastHorizon();
        result = result * 59 + this.getBackcastHorizon();
        result = result * 59 + this.getFirstPeriod();
        result = result * 59 + (this.isExcludefcast() ? 79 : 97);
        DecompositionMode $mode = this.getMode();
        result = result * 59 + ($mode == null ? 43 : $mode.hashCode());
        result = result * 59 + Arrays.deepHashCode(this.getInitialSeasonalFilter());
        result = result * 59 + Arrays.deepHashCode(this.getFinalSeasonalFilter());
        CalendarSigmaOption $calendarSigma = this.getCalendarSigma();
        result = result * 59 + ($calendarSigma == null ? 43 : $calendarSigma.hashCode());
        result = result * 59 + Arrays.deepHashCode(this.getSigmavecOptions());
        BiasCorrection $bias = this.getBias();
        result = result * 59 + ($bias == null ? 43 : $bias.hashCode());
        IExtremeValuesCorrector $extremeValuesCorrector = this.getExtremeValuesCorrector();
        result = result * 59 + ($extremeValuesCorrector == null ? 43 : $extremeValuesCorrector.hashCode());
        return result;
    }

    @Generated
    public @org.jspecify.annotations.NonNull String toString() {
        return "X11Context(mode=" + String.valueOf(this.getMode()) + ", period=" + this.getPeriod() + ", trendFilterLength=" + this.getTrendFilterLength() + ", localPolynomialDegree=" + this.getLocalPolynomialDegree() + ", seasonal=" + this.isSeasonal() + ", initialSeasonalFilter=" + Arrays.deepToString(this.getInitialSeasonalFilter()) + ", finalSeasonalFilter=" + Arrays.deepToString(this.getFinalSeasonalFilter()) + ", lowerSigma=" + this.getLowerSigma() + ", upperSigma=" + this.getUpperSigma() + ", calendarSigma=" + String.valueOf(this.getCalendarSigma()) + ", sigmavecOptions=" + Arrays.deepToString(this.getSigmavecOptions()) + ", forecastHorizon=" + this.getForecastHorizon() + ", backcastHorizon=" + this.getBackcastHorizon() + ", firstPeriod=" + this.getFirstPeriod() + ", excludefcast=" + this.isExcludefcast() + ", bias=" + String.valueOf(this.getBias()) + ", extremeValuesCorrector=" + String.valueOf(this.getExtremeValuesCorrector()) + ")";
    }

    @Generated
    private int getFirstPeriod() {
        return this.firstPeriod;
    }

    @Generated
    public static class Builder {
        @Generated
        private DecompositionMode mode;
        @Generated
        private int period;
        @Generated
        private int trendFilterLength;
        @Generated
        private int localPolynomialDegree;
        @Generated
        private boolean seasonal;
        @Generated
        private SeasonalFilterOption[] initialSeasonalFilter;
        @Generated
        private SeasonalFilterOption[] finalSeasonalFilter;
        @Generated
        private double lowerSigma;
        @Generated
        private double upperSigma;
        @Generated
        private CalendarSigmaOption calendarSigma;
        @Generated
        private SigmaVecOption[] sigmavecOptions;
        @Generated
        private int forecastHorizon;
        @Generated
        private int backcastHorizon;
        @Generated
        private int firstPeriod;
        @Generated
        private boolean excludefcast;
        @Generated
        private BiasCorrection bias;
        @Generated
        private IExtremeValuesCorrector extremeValuesCorrector;

        @Generated
        Builder() {
        }

        @Generated
        public @org.jspecify.annotations.NonNull Builder mode(@NonNull DecompositionMode mode) {
            if (mode == null) {
                throw new NullPointerException("mode is marked non-null but is null");
            }
            this.mode = mode;
            return this;
        }

        @Generated
        public @org.jspecify.annotations.NonNull Builder period(int period) {
            this.period = period;
            return this;
        }

        @Generated
        public @org.jspecify.annotations.NonNull Builder trendFilterLength(int trendFilterLength) {
            this.trendFilterLength = trendFilterLength;
            return this;
        }

        @Generated
        public @org.jspecify.annotations.NonNull Builder localPolynomialDegree(int localPolynomialDegree) {
            this.localPolynomialDegree = localPolynomialDegree;
            return this;
        }

        @Generated
        public @org.jspecify.annotations.NonNull Builder seasonal(boolean seasonal) {
            this.seasonal = seasonal;
            return this;
        }

        @Generated
        public @org.jspecify.annotations.NonNull Builder initialSeasonalFilter(SeasonalFilterOption[] initialSeasonalFilter) {
            this.initialSeasonalFilter = initialSeasonalFilter;
            return this;
        }

        @Generated
        public @org.jspecify.annotations.NonNull Builder finalSeasonalFilter(SeasonalFilterOption[] finalSeasonalFilter) {
            this.finalSeasonalFilter = finalSeasonalFilter;
            return this;
        }

        @Generated
        public @org.jspecify.annotations.NonNull Builder lowerSigma(double lowerSigma) {
            this.lowerSigma = lowerSigma;
            return this;
        }

        @Generated
        public @org.jspecify.annotations.NonNull Builder upperSigma(double upperSigma) {
            this.upperSigma = upperSigma;
            return this;
        }

        @Generated
        public @org.jspecify.annotations.NonNull Builder calendarSigma(CalendarSigmaOption calendarSigma) {
            this.calendarSigma = calendarSigma;
            return this;
        }

        @Generated
        public @org.jspecify.annotations.NonNull Builder sigmavecOptions(SigmaVecOption[] sigmavecOptions) {
            this.sigmavecOptions = sigmavecOptions;
            return this;
        }

        @Generated
        public @org.jspecify.annotations.NonNull Builder forecastHorizon(int forecastHorizon) {
            this.forecastHorizon = forecastHorizon;
            return this;
        }

        @Generated
        public @org.jspecify.annotations.NonNull Builder backcastHorizon(int backcastHorizon) {
            this.backcastHorizon = backcastHorizon;
            return this;
        }

        @Generated
        public @org.jspecify.annotations.NonNull Builder firstPeriod(int firstPeriod) {
            this.firstPeriod = firstPeriod;
            return this;
        }

        @Generated
        public @org.jspecify.annotations.NonNull Builder excludefcast(boolean excludefcast) {
            this.excludefcast = excludefcast;
            return this;
        }

        @Generated
        public @org.jspecify.annotations.NonNull Builder bias(BiasCorrection bias) {
            this.bias = bias;
            return this;
        }

        @Generated
        public @org.jspecify.annotations.NonNull Builder extremeValuesCorrector(IExtremeValuesCorrector extremeValuesCorrector) {
            this.extremeValuesCorrector = extremeValuesCorrector;
            return this;
        }

        @Generated
        public @org.jspecify.annotations.NonNull X11Context build() {
            return new X11Context(this.mode, this.period, this.trendFilterLength, this.localPolynomialDegree, this.seasonal, this.initialSeasonalFilter, this.finalSeasonalFilter, this.lowerSigma, this.upperSigma, this.calendarSigma, this.sigmavecOptions, this.forecastHorizon, this.backcastHorizon, this.firstPeriod, this.excludefcast, this.bias, this.extremeValuesCorrector);
        }

        @Generated
        public @org.jspecify.annotations.NonNull String toString() {
            return "X11Context.Builder(mode=" + String.valueOf(this.mode) + ", period=" + this.period + ", trendFilterLength=" + this.trendFilterLength + ", localPolynomialDegree=" + this.localPolynomialDegree + ", seasonal=" + this.seasonal + ", initialSeasonalFilter=" + Arrays.deepToString(this.initialSeasonalFilter) + ", finalSeasonalFilter=" + Arrays.deepToString(this.finalSeasonalFilter) + ", lowerSigma=" + this.lowerSigma + ", upperSigma=" + this.upperSigma + ", calendarSigma=" + String.valueOf(this.calendarSigma) + ", sigmavecOptions=" + Arrays.deepToString(this.sigmavecOptions) + ", forecastHorizon=" + this.forecastHorizon + ", backcastHorizon=" + this.backcastHorizon + ", firstPeriod=" + this.firstPeriod + ", excludefcast=" + this.excludefcast + ", bias=" + String.valueOf(this.bias) + ", extremeValuesCorrector=" + String.valueOf(this.extremeValuesCorrector) + ")";
        }
    }
}

