/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.core.math.polynomials;

import jdplus.toolkit.base.api.math.Complex;
import jdplus.toolkit.base.api.math.ComplexType;
import jdplus.toolkit.base.api.util.Ref;
import jdplus.toolkit.base.core.math.ComplexMath;
import jdplus.toolkit.base.core.math.polynomials.LeastSquaresDivision;
import jdplus.toolkit.base.core.math.polynomials.NewtonOptimizer;
import jdplus.toolkit.base.core.math.polynomials.Polynomial;
import jdplus.toolkit.base.core.math.polynomials.PolynomialComputer;
import jdplus.toolkit.base.core.math.polynomials.RootsSolver;

public class RobustMullerNewtonSolver
implements RootsSolver {
    private double[] polynomial;
    private double[] reducedPolynomial;
    private Complex[] roots;
    private Polynomial remainder;
    private int startIdx;
    private int degree;
    private double maxError;
    private static final int MITERMAX = 150;
    private static final int MCONVERGENCE = 100;
    private static final double MMAXDIST = 1000.0;
    private static final double MFACTOR = 100000.0;
    private static final double MKITERMAX = 1000.0;
    private static final double MFVALUE = 1.0E36;
    private static final double MBOUND1 = 1.01;
    private static final double MBOUND2 = 0.99;
    private static final double MBOUND3 = 0.01;
    private final double MBOUND4 = Math.sqrt(Double.MAX_VALUE) / 10000.0;
    private final double MBOUND6 = Math.log10(this.MBOUND4) - 4.0;
    private static final double MBOUND7 = 1.0E-5;
    private final double MNOISESTART;
    private static final double MNOISEMAX = 5.0;
    private static final double ISQRT2 = 1.0 / Math.sqrt(2.0);
    private static final int NNOISEMAX = 5;
    private static final double DBL_EPSILON = 2.220446049250313E-16;
    Complex x0 = Complex.ZERO;
    Complex x1 = Complex.ZERO;
    Complex x2 = Complex.ZERO;
    Complex h1 = Complex.ZERO;
    Complex h2 = Complex.ZERO;
    Complex q2 = Complex.ZERO;
    Complex f0 = Complex.ZERO;
    Complex f1 = Complex.ZERO;
    Complex f2 = Complex.ZERO;
    int iter;
    private boolean lqdiv = false;
    private static final Complex[] COMPLEX_FOR_ITER = RobustMullerNewtonSolver.initComplexForIter(150);

    public RobustMullerNewtonSolver() {
        this.MNOISESTART = 2.220446049250313E-14;
    }

    private void check_x_value(Ref<Complex> xb, Ref.DoubleRef f2absqb, Ref.BooleanRef rootd, double f1absq, double f2absq, double epsilon, Ref.IntRef noise) {
        if (f2absq <= 1.01 * f1absq && f2absq >= 0.99 * f1absq) {
            if (this.h2.abs() < 0.01) {
                this.q2 = this.q2.times(2.0);
                this.h2 = this.h2.times(2.0);
            } else {
                this.q2 = RobustMullerNewtonSolver.getComplexForIterationCounter(this.iter);
                this.h2 = this.h2.times(this.q2);
            }
        } else if (f2absq < f2absqb.val) {
            f2absqb.val = f2absq;
            xb.val = this.x2;
            noise.val = 0;
            if (Math.sqrt(f2absq) < epsilon && this.x2.minus(this.x1).div(this.x2).abs() < epsilon) {
                rootd.val = true;
            }
        }
    }

    public void clear() {
        this.roots = null;
        this.remainder = null;
    }

    private void compute_function(double f1absq, Ref.DoubleRef f2absq, double epsilon) {
        Ref.IntRef overflow = new Ref.IntRef(0);
        do {
            overflow.val = 0;
            this.suppress_overflow();
            PolynomialComputer fn = new PolynomialComputer(Polynomial.of(this.reducedPolynomial, this.startIdx, this.reducedPolynomial.length));
            this.f2 = fn.compute(this.x2).f();
            this.too_big_functionvalues(f2absq);
            ++this.iter;
            this.convergence_check(overflow, f1absq, f2absq.val, epsilon);
        } while (overflow.val != 0);
    }

    private void convergence_check(Ref.IntRef overflow, double f1absq, double f2absq, double epsilon) {
        if (f2absq > 100.0 * f1absq && this.q2.abs() > epsilon && this.iter < 150) {
            this.q2 = this.q2.times(0.5);
            this.h2 = this.h2.times(0.5);
            this.x2 = this.x2.minus(this.h2);
            overflow.val = 1;
        }
    }

    @Override
    public boolean factorize(Polynomial p) {
        this.startIdx = 0;
        this.degree = p.degree();
        while (this.degree > 0 && p.get(this.degree) == 0.0) {
            --this.degree;
        }
        if (this.degree == 0) {
            return false;
        }
        this.roots = new Complex[this.degree];
        this.polynomial = p.toArray();
        this.reducedPolynomial = (double[])this.polynomial.clone();
        if (!this.newtonnull()) {
            return false;
        }
        for (int j = 1; j < this.degree; ++j) {
            Complex tmp = this.roots[j];
            for (int i = j - 1; i >= 0 && !(this.roots[i].getRe() <= tmp.getRe()); --i) {
                this.roots[i + 1] = this.roots[i];
            }
            this.roots[i + 1] = tmp;
        }
        this.remainder = Polynomial.valueOf(p.get(p.degree()), new double[0]);
        return true;
    }

    private void initialize(Ref<Complex> xb, Ref.DoubleRef epsilon) {
        this.x0 = Complex.ZERO;
        this.x1 = Complex.cart((double)(-ISQRT2), (double)(-ISQRT2));
        this.x2 = Complex.cart((double)ISQRT2, (double)ISQRT2);
        this.h1 = this.x1.minus(this.x0);
        this.h2 = this.x2.minus(this.x1);
        this.q2 = this.h2.div(this.h1);
        xb.val = this.x2;
        epsilon.val = 2.220446049250313E-11;
        this.iter = 0;
    }

    private void iteration_equation(Ref.DoubleRef h2abs) {
        this.h2 = this.h2.times(this.q2);
        double h2absnew = this.h2.abs();
        if (h2absnew > h2abs.val * 1000.0) {
            double help = 1000.0 / h2absnew;
            this.h2 = this.h2.times(help);
            this.q2 = this.q2.times(help);
        }
        h2abs.val = h2absnew;
        this.x2 = this.x2.plus(this.h2);
    }

    private boolean lin_or_quad() {
        int nred = this.reducedPolynomial.length - this.startIdx - 1;
        if (nred == 1) {
            this.roots[this.startIdx] = Complex.cart((double)(-this.reducedPolynomial[this.startIdx] / this.reducedPolynomial[this.startIdx + 1]));
            return true;
        }
        if (nred == 2) {
            this.quadratic();
            return true;
        }
        return false;
    }

    private void monic() {
        int n = this.polynomial.length - 1;
        double factor = Math.abs(1.0 / this.polynomial[n]);
        if (factor != 1.0) {
            int i = 0;
            while (i <= n) {
                int n2 = i++;
                this.polynomial[n2] = this.polynomial[n2] * factor;
            }
        }
    }

    private Complex muller() {
        Ref.DoubleRef f2absq = new Ref.DoubleRef(1.0E36);
        Ref.DoubleRef f2absqb = new Ref.DoubleRef(1.0E36);
        Ref.DoubleRef h2abs = new Ref.DoubleRef(0.0);
        Ref.DoubleRef epsilon = new Ref.DoubleRef(0.0);
        Ref.IntRef seconditer = new Ref.IntRef(0);
        Ref.IntRef noise = new Ref.IntRef(0);
        Ref.BooleanRef rootd = new Ref.BooleanRef(false);
        Ref xb = new Ref((Object)Complex.ZERO);
        this.initialize((Ref<Complex>)xb, epsilon);
        PolynomialComputer fn = new PolynomialComputer(Polynomial.of(this.reducedPolynomial, this.startIdx, this.reducedPolynomial.length));
        this.f0 = fn.compute(this.x0).f();
        this.f1 = fn.compute(this.x1).f();
        this.f2 = fn.compute(this.x2).f();
        while (true) {
            this.root_of_parabola();
            this.x0 = this.x1;
            this.x1 = this.x2;
            h2abs.val = this.h2.abs();
            this.iteration_equation(h2abs);
            this.f0 = this.f1;
            this.f1 = this.f2;
            double f1absq = f2absq.val;
            this.compute_function(f1absq, f2absq, epsilon.val);
            this.check_x_value((Ref<Complex>)xb, f2absqb, rootd, f1absq, f2absq.val, epsilon.val, noise);
            double xb_abs = ((Complex)xb.val).abs();
            if (Math.abs(xb_abs - this.x2.abs()) / xb_abs < this.MNOISESTART) {
                ++noise.val;
            }
            if (this.iter < 150 && !rootd.val && (double)noise.val <= 5.0) continue;
            ++seconditer.val;
            this.root_check(f2absqb.val, seconditer, rootd, noise, (Complex)xb.val);
            if (seconditer.val != 2) break;
        }
        return (Complex)xb.val;
    }

    private boolean newtonnull() {
        this.maxError = 0.0;
        this.roots_at_zero();
        if (this.startIdx == this.polynomial.length - 1) {
            return true;
        }
        if (this.lin_or_quad()) {
            this.maxError = 2.220446049250313E-16;
            return true;
        }
        this.monic();
        do {
            Complex ns = this.muller();
            NewtonOptimizer optimizer = new NewtonOptimizer(Polynomial.of(this.polynomial, 0, this.polynomial.length), true);
            Complex nroot = optimizer.root(ns);
            if (optimizer.getError() > this.maxError) {
                this.maxError = optimizer.getError();
            }
            if (nroot.getIm() == 0.0) {
                this.update(nroot.getRe(), optimizer.getMultiplicity());
                continue;
            }
            this.update(nroot, optimizer.getMultiplicity());
        } while (this.polynomial.length - this.startIdx > 3);
        this.lin_or_quad();
        return true;
    }

    private void quadratic() {
        double a = this.reducedPolynomial[this.startIdx + 2];
        double b = this.reducedPolynomial[this.startIdx + 1];
        double c = this.reducedPolynomial[this.startIdx];
        double aa = 2.0 * a;
        double rdiscr = b * b - 4.0 * a * c;
        if (rdiscr < 0.0) {
            Complex r;
            double z = Math.sqrt(-rdiscr);
            this.roots[this.startIdx] = r = Complex.cart((double)(-b / aa), (double)(z / aa));
            this.roots[this.startIdx + 1] = r.conj();
        } else {
            double z = Math.sqrt(rdiscr);
            this.roots[this.startIdx] = Complex.cart((double)((-b + z) / aa));
            this.roots[this.startIdx + 1] = Complex.cart((double)((-b - z) / aa));
        }
    }

    @Override
    public Polynomial remainder() {
        return this.remainder;
    }

    private void root_check(double f2absqb, Ref.IntRef seconditer, Ref.BooleanRef rootd, Ref.IntRef noise, Complex xb) {
        if (seconditer.val == 1 && f2absqb > 0.0) {
            PolynomialComputer fn = new PolynomialComputer(Polynomial.of(this.reducedPolynomial, this.startIdx, this.reducedPolynomial.length));
            fn.computeAll(xb);
            this.f2 = fn.f();
            Complex df = fn.df();
            if (this.f2.abs() / (df.abs() * xb.abs()) > 1.0E-5) {
                this.x0 = Complex.ONE;
                this.x1 = Complex.NEG_ONE;
                this.x2 = Complex.ZERO;
                this.f0 = fn.compute(this.x0).f();
                this.f1 = fn.compute(this.x1).f();
                this.f2 = fn.compute(this.x2).f();
                this.iter = 0;
                ++seconditer.val;
                rootd.val = false;
                noise.val = 0;
            }
        }
    }

    private void root_of_parabola() {
        double N2_abs;
        Complex A2 = RobustMullerNewtonSolver.computeA2(this.q2, this.f2, this.f0, this.f1);
        Complex B2 = RobustMullerNewtonSolver.computeB2(this.f2, this.f1, this.q2, this.f0);
        Complex C2 = RobustMullerNewtonSolver.computeC2(this.q2, this.f2);
        Complex rdiscr = ComplexMath.sqrt((ComplexType)RobustMullerNewtonSolver.computeDiscr(B2, A2, C2));
        Complex N1 = B2.minus(rdiscr);
        Complex N2 = B2.plus(rdiscr);
        double N1_abs = N1.abs();
        this.q2 = N1_abs > (N2_abs = N2.abs()) && N1_abs > 2.220446049250313E-16 ? C2.times(-2.0).div(N1) : (N2_abs > 2.220446049250313E-16 ? C2.times(-2.0).div(N2) : RobustMullerNewtonSolver.getComplexForIterationCounter(this.iter));
    }

    static Complex computeA2(Complex q2, Complex f2, Complex f0, Complex f1) {
        double re0 = q2.getRe();
        double im0 = q2.getIm();
        double re1 = f2.getRe();
        double im1 = f2.getIm();
        double re2 = q2.getRe() * f0.getRe() - q2.getIm() * f0.getIm();
        double im2 = q2.getRe() * f0.getIm() + q2.getIm() * f0.getRe();
        re1 += re2;
        im1 += im2;
        re2 = 1.0 + q2.getRe();
        im2 = q2.getIm();
        double tmp = re2 * f1.getRe() - im2 * f1.getIm();
        im2 = re2 * f1.getIm() + im2 * f1.getRe();
        re2 = tmp;
        tmp = re0 * (re1 -= re2) - im0 * (im1 -= im2);
        im0 = re0 * im1 + im0 * re1;
        re0 = tmp;
        return Complex.cart((double)re0, (double)im0);
    }

    static Complex computeB2(Complex f2, Complex f1, Complex q2, Complex f0) {
        double re0 = f2.getRe() - f1.getRe();
        double im0 = f2.getIm() - f1.getIm();
        double re1 = q2.getRe();
        double im1 = q2.getIm();
        double re2 = q2.getRe();
        double im2 = q2.getIm();
        double re3 = f0.getRe() - f1.getRe();
        double im3 = f0.getIm() - f1.getIm();
        double tmp = re2 * re3 - im2 * im3;
        im2 = re2 * im3 + im2 * re3;
        re2 = tmp;
        re3 = f2.getRe() - f1.getRe();
        im3 = f2.getIm() - f1.getIm();
        tmp = re1 * (re2 += (re3 *= 2.0)) - im1 * (im2 += (im3 *= 2.0));
        im1 = re1 * im2 + im1 * re2;
        re1 = tmp;
        return Complex.cart((double)(re0 += re1), (double)(im0 += im1));
    }

    static Complex computeC2(Complex q2, Complex f2) {
        double re0 = 1.0 + q2.getRe();
        double im0 = q2.getIm();
        double tmp = re0 * f2.getRe() - im0 * f2.getIm();
        im0 = re0 * f2.getIm() + im0 * f2.getRe();
        re0 = tmp;
        return Complex.cart((double)re0, (double)im0);
    }

    static Complex computeDiscr(Complex B2, Complex A2, Complex C2) {
        double re0 = B2.getRe() * B2.getRe() - B2.getIm() * B2.getIm();
        double im0 = B2.getRe() * B2.getIm() + B2.getIm() * B2.getRe();
        double re1 = A2.getRe() * C2.getRe() - A2.getIm() * C2.getIm();
        double im1 = A2.getRe() * C2.getIm() + A2.getIm() * C2.getRe();
        return Complex.cart((double)(re0 -= (re1 *= 4.0)), (double)(im0 -= (im1 *= 4.0)));
    }

    @Override
    public Complex[] roots() {
        return this.roots;
    }

    private void roots_at_zero() {
        this.startIdx = 0;
        while (this.startIdx < this.polynomial.length && this.polynomial[this.startIdx] == 0.0) {
            this.roots[this.startIdx++] = Complex.ZERO;
        }
    }

    private void suppress_overflow() {
        boolean loop;
        int nred = this.reducedPolynomial.length - 1 - this.startIdx;
        int kiter = 0;
        do {
            loop = false;
            double help = this.x2.abs();
            if (!(help > 1.0) || !(Math.abs((double)nred * Math.log10(help)) > this.MBOUND6)) continue;
            if ((double)(++kiter) < 1000.0) {
                this.h2 = this.h2.times(0.5);
                this.q2 = this.q2.times(0.5);
                this.x2 = this.x2.minus(this.h2);
                loop = true;
                continue;
            }
            kiter = 0;
        } while (loop);
    }

    private void too_big_functionvalues(Ref.DoubleRef f2absq) {
        f2absq.val = Math.abs(this.f2.getRe()) + Math.abs(this.f2.getIm()) > this.MBOUND4 ? Math.abs(this.f2.getRe()) + Math.abs(this.f2.getIm()) : this.f2.absSquare();
    }

    public boolean isLeastSquaresDivision() {
        return this.lqdiv;
    }

    public void setLeastSquaresDivision(boolean lq) {
        this.lqdiv = lq;
    }

    private void update(Complex r0, int mul) {
        double a = -2.0 * r0.getRe();
        double b = r0.absSquare();
        for (int k = 0; k < mul; ++k) {
            this.roots[this.startIdx++] = r0;
            this.roots[this.startIdx++] = r0.conj();
            if (this.lqdiv) continue;
            int n = this.degree - 1;
            this.reducedPolynomial[n] = this.reducedPolynomial[n] - this.reducedPolynomial[this.degree] * a;
            for (int i = this.degree; i > this.startIdx; --i) {
                int n2 = i - 2;
                this.reducedPolynomial[n2] = this.reducedPolynomial[n2] - (a * this.reducedPolynomial[i - 1] + b * this.reducedPolynomial[i]);
            }
        }
        if (this.lqdiv) {
            Polynomial c;
            Polynomial num = Polynomial.of(this.reducedPolynomial, this.startIdx - 2 * mul, this.degree + 1);
            Polynomial div = c = Polynomial.ofInternal(new double[]{b, a, 1.0});
            for (int i = 1; i < mul; ++i) {
                div = div.times(c);
            }
            LeastSquaresDivision lq = new LeastSquaresDivision();
            lq.divide(num, div);
            lq.getQuotient().copyTo(this.reducedPolynomial, this.startIdx);
        }
    }

    private void update(double r0, int mul) {
        for (int k = 0; k < mul; ++k) {
            this.roots[this.startIdx++] = Complex.cart((double)r0);
            if (this.lqdiv) continue;
            for (int i = this.degree; i > this.startIdx; --i) {
                int n = i - 1;
                this.reducedPolynomial[n] = this.reducedPolynomial[n] + this.reducedPolynomial[i] * r0;
            }
        }
        if (this.lqdiv) {
            Polynomial c;
            Polynomial num = Polynomial.of(this.reducedPolynomial, this.startIdx - mul, this.degree + 1);
            Polynomial div = c = Polynomial.ofInternal(new double[]{-r0, 1.0});
            for (int k = 1; k < mul; ++k) {
                div = div.times(c);
            }
            LeastSquaresDivision lq = new LeastSquaresDivision();
            lq.divide(num, div);
            lq.getQuotient().copyTo(this.reducedPolynomial, this.startIdx);
        }
    }

    private static Complex getComplexForIterationCounter(int iter) {
        return COMPLEX_FOR_ITER[iter];
    }

    private static Complex newComplexForIterationCounter(int iter) {
        return Complex.cart((double)Math.cos(iter), (double)Math.sin(iter));
    }

    private static Complex[] initComplexForIter(int maxIter) {
        Complex[] result = new Complex[maxIter + 1];
        for (int i = 0; i < result.length; ++i) {
            result[i] = RobustMullerNewtonSolver.newComplexForIterationCounter(i);
        }
        return result;
    }
}

