/*
 * Decompiled with CFR 0.152.
 */
package internal.toolkit.base.core.arima;

import internal.toolkit.base.core.arima.MaLjungBoxFilter;
import jdplus.toolkit.base.api.data.DoubleSeq;
import jdplus.toolkit.base.core.arima.IArimaModel;
import jdplus.toolkit.base.core.arima.estimation.ArmaFilter;
import jdplus.toolkit.base.core.data.DataBlock;
import jdplus.toolkit.base.core.data.DataWindow;
import jdplus.toolkit.base.core.data.LogSign;
import jdplus.toolkit.base.core.math.matrices.FastMatrix;
import jdplus.toolkit.base.core.math.matrices.LowerTriangularMatrix;
import jdplus.toolkit.base.core.math.matrices.SymmetricMatrix;
import jdplus.toolkit.base.core.math.polynomials.Polynomial;

public class ModifiedLjungBoxFilter
implements ArmaFilter {
    private int m_n;
    private int m_p;
    private int m_q;
    private Polynomial m_ar;
    private Polynomial m_ma;
    private double m_s;
    private MaLjungBoxFilter m_malb;
    private FastMatrix m_L;
    private FastMatrix m_C;

    @Override
    public void apply(DoubleSeq rw, DataBlock wl) {
        DataBlock w;
        DataBlock z = w = DataBlock.of(rw);
        if (this.m_p > 0) {
            z = DataBlock.make(w.length() - this.m_p);
            DataWindow x = w.drop(this.m_p, 0).window();
            z.copy(x.get());
            for (int i = 1; i <= this.m_p; ++i) {
                z.addAY(this.m_ar.get(i), x.move(-1));
            }
        }
        if (this.m_malb != null) {
            this.m_malb.filter((DoubleSeq)z, wl.drop(this.m_p, 0));
        } else {
            wl.drop(this.m_p, 0).copy(z);
        }
        if (this.m_C != null) {
            for (int i = 0; i < this.m_p; ++i) {
                wl.set(i, w.get(i) - this.m_C.column(i).dot(wl.drop(this.m_p, 0)));
            }
        } else {
            wl.range(0, this.m_p).copy(w.range(0, this.m_p));
        }
        if (this.m_L != null) {
            LowerTriangularMatrix.solveLx(this.m_L, wl.range(0, this.m_p));
        }
    }

    @Override
    public double getLogDeterminant() {
        double s = this.m_s;
        if (this.m_malb != null) {
            s += this.m_malb.getLogDeterminant();
        }
        return s;
    }

    @Override
    public int prepare(IArimaModel arima, int n) {
        this.clear();
        this.m_ar = arima.getAr().asPolynomial();
        this.m_ma = arima.getMa().asPolynomial();
        this.m_n = n;
        this.m_p = this.m_ar.degree();
        this.m_q = this.m_ma.degree();
        if (this.m_q > 0) {
            this.m_malb = new MaLjungBoxFilter();
            this.m_malb.prepare(arima, n - this.m_p);
        }
        if (this.m_p > 0) {
            this.m_L = FastMatrix.square(this.m_p);
            double[] cov = arima.getAutoCovarianceFunction().values(this.m_p);
            this.m_L.diagonal().set(cov[0]);
            for (int i = 1; i < this.m_p; ++i) {
                this.m_L.subDiagonal(i).set(cov[i]);
            }
            if (this.m_q > 0) {
                double[] psi = arima.getPsiWeights().getRationalFunction().coefficients(this.m_q);
                FastMatrix C = FastMatrix.make(this.m_n - this.m_p, this.m_p);
                this.m_C = FastMatrix.make(this.m_n + this.m_q - this.m_p, this.m_p);
                for (int c = 0; c < this.m_p; ++c) {
                    int imin;
                    DataBlock col = C.column(c);
                    for (int r = 0; r < this.m_q && (imin = this.m_p + r - c) <= this.m_q; ++r) {
                        double s = 0.0;
                        for (int i = imin; i <= this.m_q; ++i) {
                            s += this.m_ma.get(i) * psi[i - imin];
                        }
                        col.set(r, s);
                    }
                    this.m_malb.filter((DoubleSeq)col, this.m_C.column(c));
                }
                for (int i = 0; i < this.m_p; ++i) {
                    for (int j = 0; j <= i; ++j) {
                        double z = this.m_C.column(i).dot(this.m_C.column(j));
                        this.m_L.add(j, i, -z);
                    }
                }
            }
            SymmetricMatrix.fromUpper(this.m_L);
            SymmetricMatrix.lcholesky(this.m_L);
            this.m_s = 2.0 * LogSign.of((DoubleSeq)this.m_L.diagonal()).getValue();
        }
        return n + this.m_q;
    }

    private void clear() {
        this.m_malb = null;
        this.m_s = 0.0;
        this.m_L = null;
        this.m_C = null;
    }
}

