/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.tsp.legacy;

import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Base64;
import java.util.Iterator;
import jdplus.toolkit.base.api.design.DemetraPlusLegacy;

@DemetraPlusLegacy
final class LegacyId
implements Comparable<LegacyId>,
Iterable<String> {
    private final Handler stringHandler;
    private final String[] data;

    static LegacyId parse(Handler handler, String str) {
        if (str == null || str.isEmpty()) {
            return null;
        }
        try {
            return new LegacyId(handler, handler.split(str));
        }
        catch (Exception err) {
            return null;
        }
    }

    static LegacyId of(Handler handler, String first, String ... others) {
        return new LegacyId(handler, LegacyId.join(first, others));
    }

    private LegacyId(Handler stringHandler, String[] data) {
        this.stringHandler = stringHandler;
        this.data = data;
    }

    public String get(int index) {
        return this.data[index];
    }

    public boolean is(int index) {
        return this.data.length == index + 1;
    }

    public LegacyId extend(String arg0, String ... args) {
        return new LegacyId(this.stringHandler, LegacyId.join(this.data, arg0, args));
    }

    public LegacyId parent() {
        return this.data.length > 1 ? new LegacyId(this.stringHandler, LegacyId.sub(this.data, 0, this.data.length - 1)) : null;
    }

    public String tail() {
        return this.data[this.data.length - 1];
    }

    public LegacyId[] path() {
        LegacyId[] result = new LegacyId[this.data.length];
        result[0] = LegacyId.of(this.stringHandler, this.data[0], new String[0]);
        for (int i = 1; i < this.data.length; ++i) {
            result[i] = result[i - 1].extend(this.data[i], new String[0]);
        }
        return result;
    }

    public int getCount() {
        return this.data.length;
    }

    public String toString() {
        return this.stringHandler.join(this.data);
    }

    public boolean equals(Object obj) {
        return this == obj || obj instanceof LegacyId && this.equals((LegacyId)obj);
    }

    private boolean equals(LegacyId other) {
        return this.toString().equals(other.toString());
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    @Override
    public int compareTo(LegacyId other) {
        return this.toString().compareTo(other.toString());
    }

    @Override
    public Iterator<String> iterator() {
        return Arrays.asList(this.data).iterator();
    }

    private static String[] join(String arg0, String[] args) {
        String[] result = new String[1 + args.length];
        result[0] = arg0;
        System.arraycopy(args, 0, result, 1, args.length);
        return result;
    }

    private static String[] join(String[] left, String arg0, String ... args) {
        String[] result = new String[left.length + 1 + args.length];
        System.arraycopy(left, 0, result, 0, left.length);
        result[left.length] = arg0;
        System.arraycopy(args, 0, result, left.length + 1, args.length);
        return result;
    }

    private static String[] sub(String[] data, int pos, int length) {
        String[] result = new String[length];
        System.arraycopy(data, pos, result, 0, length);
        return result;
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    static enum Handler {
        PLAIN{
            static final String SEP = "<<>>";

            @Override
            public String join(String[] o) {
                if (0 == o.length) {
                    return "";
                }
                StringBuilder sb = new StringBuilder(o[0]);
                for (int i = 1; i < o.length; ++i) {
                    sb.append(SEP);
                    sb.append(o[i]);
                }
                return sb.toString();
            }

            @Override
            public String[] split(String o) {
                return o.split(SEP);
            }
        }
        ,
        BASE64{
            static final String SEP = "/";

            @Override
            public String join(String[] o) {
                if (0 == o.length) {
                    return "";
                }
                StringBuilder sb = new StringBuilder(o[0]);
                for (int i = 1; i < o.length; ++i) {
                    sb.append(SEP);
                    sb.append(Base64.getEncoder().encodeToString(o[i].getBytes(StandardCharsets.UTF_8)));
                }
                return sb.toString();
            }

            @Override
            public String[] split(String o) {
                String[] splitResult = o.split(SEP);
                for (int i = 0; i < splitResult.length; ++i) {
                    try {
                        splitResult[i] = new String(Base64.getDecoder().decode(splitResult[i]), StandardCharsets.UTF_8);
                        continue;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                return splitResult;
            }
        };


        public abstract String join(String[] var1);

        public abstract String[] split(String var1);
    }
}

