/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.tsp.cube;

import java.io.Closeable;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import jdplus.toolkit.base.api.timeseries.TsInformationType;
import jdplus.toolkit.base.tsp.DataSet;
import jdplus.toolkit.base.tsp.DataSource;
import jdplus.toolkit.base.tsp.HasDataDisplayName;
import jdplus.toolkit.base.tsp.HasDataHierarchy;
import jdplus.toolkit.base.tsp.cube.CubeConnection;
import jdplus.toolkit.base.tsp.cube.CubeId;
import jdplus.toolkit.base.tsp.cube.CubeSeries;
import jdplus.toolkit.base.tsp.cube.CubeSeriesWithData;
import jdplus.toolkit.base.tsp.fixme.Strings;
import jdplus.toolkit.base.tsp.stream.DataSetTs;
import jdplus.toolkit.base.tsp.stream.HasTsStream;
import jdplus.toolkit.base.tsp.util.DataSetConversion;
import jdplus.toolkit.base.tsp.util.DataSourcePreconditions;
import jdplus.toolkit.base.tsp.util.ResourceFactory;
import jdplus.toolkit.base.tsp.util.ResourcePool;
import lombok.Generated;
import lombok.NonNull;
import nbbrd.io.Resource;
import nbbrd.io.function.IOFunction;
import nbbrd.io.function.IORunnable;

public final class CubeSupport
implements HasDataHierarchy,
HasTsStream,
HasDataDisplayName {
    @NonNull
    private final String providerName;
    @NonNull
    private final ResourceFactory<CubeConnection> cube;
    @NonNull
    private final DataSetConversion<CubeConnection, CubeId> cubeId;

    @Override
    @NonNull
    public List<DataSet> children(@NonNull DataSource dataSource) throws IOException {
        if (dataSource == null) {
            throw new NullPointerException("dataSource is marked non-null but is null");
        }
        DataSourcePreconditions.checkProvider(this.providerName, dataSource);
        try (CubeConnection connection = this.cube.open(dataSource);){
            List<DataSet> list;
            block18: {
                CubeId root = connection.getRoot();
                if (root.isVoid()) {
                    Optional<IOException> ex = connection.testConnection();
                    if (ex.isPresent()) {
                        throw ex.orElseThrow();
                    }
                    DataSet fake = DataSet.of(dataSource, DataSet.Kind.SERIES);
                    List<DataSet> list2 = Collections.singletonList(fake);
                    return list2;
                }
                Stream<CubeId> children = connection.getChildren(root);
                try {
                    DataSet.Builder builder = DataSet.builder(dataSource, CubeSupport.getDataSetKind(root));
                    list = children.map(CubeSupport.toDataSetFunc(builder, this.cubeId.getConverter(connection))).collect(Collectors.toList());
                    if (children == null) break block18;
                }
                catch (Throwable throwable) {
                    try {
                        if (children != null) {
                            try {
                                children.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (UncheckedIOException ex) {
                        throw ex.getCause();
                    }
                }
                children.close();
            }
            return list;
        }
    }

    @Override
    @NonNull
    public List<DataSet> children(@NonNull DataSet parent) throws IOException {
        if (parent == null) {
            throw new NullPointerException("parent is marked non-null but is null");
        }
        DataSourcePreconditions.checkProvider(this.providerName, parent);
        if (!DataSet.Kind.COLLECTION.equals((Object)parent.getKind())) {
            throw new IllegalArgumentException("Not a collection");
        }
        try (CubeConnection connection = this.cube.open(parent.getDataSource());){
            List<DataSet> list;
            block17: {
                DataSet.Converter<CubeId> cubeIdConverter = this.cubeId.getConverter(connection);
                CubeId parentId = cubeIdConverter.get(parent);
                Stream<CubeId> children = connection.getChildren(parentId);
                try {
                    DataSet.Builder builder = parent.toBuilder(CubeSupport.getDataSetKind(parentId));
                    list = children.map(CubeSupport.toDataSetFunc(builder, cubeIdConverter)).collect(Collectors.toList());
                    if (children == null) break block17;
                }
                catch (Throwable throwable) {
                    try {
                        if (children != null) {
                            try {
                                children.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (UncheckedIOException ex) {
                        throw ex.getCause();
                    }
                }
                children.close();
            }
            return list;
        }
    }

    private static DataSet.Kind getDataSetKind(CubeId cubeId) {
        return cubeId.getDepth() > 1 ? DataSet.Kind.COLLECTION : DataSet.Kind.SERIES;
    }

    @Override
    @NonNull
    public Stream<DataSetTs> getData(@NonNull DataSource dataSource, @NonNull TsInformationType type) throws IOException {
        if (dataSource == null) {
            throw new NullPointerException("dataSource is marked non-null but is null");
        }
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
        DataSourcePreconditions.checkProvider(this.providerName, dataSource);
        CubeConnection connection = this.cube.open(dataSource);
        try {
            CubeId root = connection.getRoot();
            Function<CubeId, DataSet> toDataSet = CubeSupport.toDataSetFunc(DataSet.builder(dataSource, DataSet.Kind.SERIES), this.cubeId.getConverter(connection));
            return (Stream)(type.encompass(TsInformationType.Data) ? connection.getAllSeriesWithData(root).map(CubeSupport.getSeriesWithDataFunc(toDataSet, (IOFunction<CubeId, String>)((IOFunction)connection::getDisplayName))) : connection.getAllSeries(root).map(CubeSupport.getSeriesFunc(toDataSet, (IOFunction<CubeId, String>)((IOFunction)connection::getDisplayName)))).onClose(IORunnable.unchecked(connection::close));
        }
        catch (IOException ex) {
            Resource.ensureClosed((Throwable)ex, (Closeable)connection);
            throw ex;
        }
    }

    @Override
    @NonNull
    public Stream<DataSetTs> getData(@NonNull DataSet dataSet, @NonNull TsInformationType type) throws IOException {
        if (dataSet == null) {
            throw new NullPointerException("dataSet is marked non-null but is null");
        }
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
        DataSourcePreconditions.checkProvider(this.providerName, dataSet);
        CubeConnection connection = this.cube.open(dataSet.getDataSource());
        try {
            DataSet.Converter<CubeId> cubeIdConverter = this.cubeId.getConverter(connection);
            CubeId id = cubeIdConverter.get(dataSet);
            Function<CubeId, DataSet> toDataSet = CubeSupport.toDataSetFunc(dataSet.toBuilder(DataSet.Kind.SERIES), cubeIdConverter);
            boolean collection = DataSet.Kind.COLLECTION.equals((Object)dataSet.getKind());
            return (Stream)(type.encompass(TsInformationType.Data) ? (collection ? connection.getAllSeriesWithData(id) : CubeSupport.stream(connection.getSeriesWithData(id))).map(CubeSupport.getSeriesWithDataFunc(toDataSet, (IOFunction<CubeId, String>)((IOFunction)connection::getDisplayName))) : (collection ? connection.getAllSeries(id) : CubeSupport.stream(connection.getSeries(id))).map(CubeSupport.getSeriesFunc(toDataSet, (IOFunction<CubeId, String>)((IOFunction)connection::getDisplayName)))).onClose(IORunnable.unchecked(connection::close));
        }
        catch (IOException ex) {
            Resource.ensureClosed((Throwable)ex, (Closeable)connection);
            throw ex;
        }
    }

    @Override
    @NonNull
    public String getDisplayName(@NonNull DataSource dataSource) throws IllegalArgumentException {
        String string;
        block9: {
            if (dataSource == null) {
                throw new NullPointerException("dataSource is marked non-null but is null");
            }
            DataSourcePreconditions.checkProvider(this.providerName, dataSource);
            CubeConnection connection = this.cube.open(dataSource);
            try {
                string = connection.getDisplayName();
                if (connection == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (connection != null) {
                        try {
                            connection.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException ex) {
                    return ex.getMessage();
                }
            }
            connection.close();
        }
        return string;
    }

    @Override
    @NonNull
    public String getDisplayName(@NonNull DataSet dataSet) throws IllegalArgumentException {
        String string;
        block9: {
            if (dataSet == null) {
                throw new NullPointerException("dataSet is marked non-null but is null");
            }
            DataSourcePreconditions.checkProvider(this.providerName, dataSet);
            CubeConnection connection = this.cube.open(dataSet.getDataSource());
            try {
                CubeId id = this.cubeId.getConverter(connection).get(dataSet);
                string = connection.getDisplayName(id);
                if (connection == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (connection != null) {
                        try {
                            connection.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException ex) {
                    return ex.getMessage();
                }
            }
            connection.close();
        }
        return string;
    }

    @Override
    @NonNull
    public String getDisplayNodeName(@NonNull DataSet dataSet) throws IllegalArgumentException {
        String string;
        block9: {
            if (dataSet == null) {
                throw new NullPointerException("dataSet is marked non-null but is null");
            }
            DataSourcePreconditions.checkProvider(this.providerName, dataSet);
            CubeConnection connection = this.cube.open(dataSet.getDataSource());
            try {
                CubeId id = this.cubeId.getConverter(connection).get(dataSet);
                string = connection.getDisplayNodeName(id);
                if (connection == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (connection != null) {
                        try {
                            connection.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException ex) {
                    return ex.getMessage();
                }
            }
            connection.close();
        }
        return string;
    }

    public static @NonNull DataSet.Converter<CubeId> idByName(@NonNull CubeId root) {
        if (root == null) {
            throw new NullPointerException("root is marked non-null but is null");
        }
        return new ByNameParam(Objects.requireNonNull(root));
    }

    public static @NonNull DataSet.Converter<CubeId> idBySeparator(@NonNull CubeId root, @NonNull String separator, @NonNull String name) {
        if (root == null) {
            throw new NullPointerException("root is marked non-null but is null");
        }
        if (separator == null) {
            throw new NullPointerException("separator is marked non-null but is null");
        }
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        return new BySeparatorParam(Objects.requireNonNull(separator), Objects.requireNonNull(root), Objects.requireNonNull(name));
    }

    private static Function<CubeId, DataSet> toDataSetFunc(DataSet.Builder builder, DataSet.Converter<CubeId> converter) {
        return o -> {
            converter.set(builder, (CubeId)o);
            return builder.build();
        };
    }

    private static String getNonNullLabel(String label, CubeId id, IOFunction<CubeId, String> toLabel) {
        if (label != null) {
            return label;
        }
        try {
            return (String)toLabel.applyWithIO((Object)id);
        }
        catch (IOException ex) {
            throw new UncheckedIOException(ex);
        }
    }

    private static Function<CubeSeriesWithData, DataSetTs> getSeriesWithDataFunc(Function<CubeId, DataSet> toDataSet, IOFunction<CubeId, String> toLabel) {
        return ts -> new DataSetTs((DataSet)toDataSet.apply(ts.getId()), CubeSupport.getNonNullLabel(ts.getLabel(), ts.getId(), toLabel), ts.getMeta(), ts.getData());
    }

    private static Function<CubeSeries, DataSetTs> getSeriesFunc(Function<CubeId, DataSet> toDataSet, IOFunction<CubeId, String> toLabel) {
        return ts -> new DataSetTs((DataSet)toDataSet.apply(ts.getId()), CubeSupport.getNonNullLabel(ts.getLabel(), ts.getId(), toLabel), ts.getMeta(), DataSetTs.DATA_NOT_REQUESTED);
    }

    private static <T> Stream<T> stream(Optional<T> optional) {
        return optional.map(Stream::of).orElseGet(Stream::empty);
    }

    @NonNull
    public static ResourcePool<CubeConnection> newConnectionPool() {
        return ResourcePool.of(PooledCubeConnection::new);
    }

    @Generated
    private CubeSupport(@NonNull String providerName, @NonNull ResourceFactory<CubeConnection> cube, @NonNull DataSetConversion<CubeConnection, CubeId> cubeId) {
        if (providerName == null) {
            throw new NullPointerException("providerName is marked non-null but is null");
        }
        if (cube == null) {
            throw new NullPointerException("cube is marked non-null but is null");
        }
        if (cubeId == null) {
            throw new NullPointerException("cubeId is marked non-null but is null");
        }
        this.providerName = providerName;
        this.cube = cube;
        this.cubeId = cubeId;
    }

    @Generated
    public static @org.jspecify.annotations.NonNull CubeSupport of(@NonNull String providerName, @NonNull ResourceFactory<CubeConnection> cube, @NonNull DataSetConversion<CubeConnection, CubeId> cubeId) {
        if (providerName == null) {
            throw new NullPointerException("providerName is marked non-null but is null");
        }
        if (cube == null) {
            throw new NullPointerException("cube is marked non-null but is null");
        }
        if (cubeId == null) {
            throw new NullPointerException("cubeId is marked non-null but is null");
        }
        return new CubeSupport(providerName, cube, cubeId);
    }

    private static final class ByNameParam
    implements DataSet.Converter<CubeId> {
        private final CubeId root;

        @Override
        @NonNull
        public CubeId getDefaultValue() {
            return this.root;
        }

        @Override
        @NonNull
        public CubeId get(@NonNull DataSet config) {
            String id;
            int i;
            if (config == null) {
                throw new NullPointerException("config is marked non-null but is null");
            }
            String[] dimValues = new String[this.root.getMaxLevel()];
            for (i = 0; i < dimValues.length && (dimValues[i] = config.getParameter(id = this.root.getDimensionId(i))) != null; ++i) {
            }
            return this.root.child(dimValues, i);
        }

        @Override
        public void set(@NonNull DataSet.Builder builder, CubeId value) {
            if (builder == null) {
                throw new NullPointerException("builder is marked non-null but is null");
            }
            for (int i = 0; i < value.getLevel(); ++i) {
                builder.parameter(value.getDimensionId(i), value.getDimensionValue(i));
            }
        }

        @Generated
        public ByNameParam(CubeId root) {
            this.root = root;
        }
    }

    private static final class BySeparatorParam
    implements DataSet.Converter<CubeId> {
        private final String separator;
        private final CubeId root;
        private final String name;

        @Override
        @NonNull
        public CubeId getDefaultValue() {
            return this.root;
        }

        @Override
        @NonNull
        public CubeId get(@NonNull DataSet config) {
            int i;
            if (config == null) {
                throw new NullPointerException("config is marked non-null but is null");
            }
            String value = config.getParameter(this.name);
            if (value == null || value.isEmpty()) {
                return this.getDefaultValue();
            }
            String[] dimValues = new String[this.root.getMaxLevel()];
            Iterator<String> iterator = Strings.splitToIterator(this.separator, (CharSequence)value);
            for (i = 0; i < dimValues.length && iterator.hasNext(); ++i) {
                dimValues[i] = iterator.next();
            }
            return this.root.child(dimValues, i);
        }

        @Override
        public void set(@NonNull DataSet.Builder builder, CubeId value) {
            if (builder == null) {
                throw new NullPointerException("builder is marked non-null but is null");
            }
            if (value.getLevel() > 0) {
                StringBuilder sb = new StringBuilder();
                sb.append(value.getDimensionValue(0));
                for (int i = 1; i < value.getLevel(); ++i) {
                    sb.append(this.separator).append(value.getDimensionValue(i));
                }
                builder.parameter(this.name, sb.toString());
            }
        }

        @Generated
        public BySeparatorParam(String separator, CubeId root, String name) {
            this.separator = separator;
            this.root = root;
            this.name = name;
        }
    }

    private static final class PooledCubeConnection
    implements CubeConnection {
        @NonNull
        private final CubeConnection delegate;
        @NonNull
        private final Closeable onClose;

        @Generated
        public PooledCubeConnection(@NonNull CubeConnection delegate, @NonNull Closeable onClose) {
            if (delegate == null) {
                throw new NullPointerException("delegate is marked non-null but is null");
            }
            if (onClose == null) {
                throw new NullPointerException("onClose is marked non-null but is null");
            }
            this.delegate = delegate;
            this.onClose = onClose;
        }

        @Override
        @Generated
        public Optional<IOException> testConnection() {
            return this.delegate.testConnection();
        }

        @Override
        @Generated
        public CubeId getRoot() throws IOException {
            return this.delegate.getRoot();
        }

        @Override
        @Generated
        public Stream<CubeSeries> getAllSeries(CubeId id) throws IOException {
            return this.delegate.getAllSeries(id);
        }

        @Override
        @Generated
        public Stream<CubeSeriesWithData> getAllSeriesWithData(CubeId id) throws IOException {
            return this.delegate.getAllSeriesWithData(id);
        }

        @Override
        @Generated
        public Optional<CubeSeries> getSeries(CubeId id) throws IOException {
            return this.delegate.getSeries(id);
        }

        @Override
        @Generated
        public Optional<CubeSeriesWithData> getSeriesWithData(CubeId id) throws IOException {
            return this.delegate.getSeriesWithData(id);
        }

        @Override
        @Generated
        public Stream<CubeId> getChildren(CubeId id) throws IOException {
            return this.delegate.getChildren(id);
        }

        @Override
        @Generated
        public String getDisplayName() throws IOException {
            return this.delegate.getDisplayName();
        }

        @Override
        @Generated
        public String getDisplayName(CubeId id) throws IOException {
            return this.delegate.getDisplayName(id);
        }

        @Override
        @Generated
        public String getDisplayNodeName(CubeId id) throws IOException {
            return this.delegate.getDisplayNodeName(id);
        }

        @Override
        @Generated
        public void close() throws IOException {
            this.onClose.close();
        }
    }
}

