/*
 * Decompiled with CFR 0.152.
 */
package internal.toolkit.base.tsp.util;

import internal.toolkit.base.tsp.util.FileMapCache;
import internal.toolkit.base.tsp.util.TtlMapCache;
import java.io.File;
import java.time.Duration;
import java.util.HashMap;
import java.util.function.LongSupplier;
import jdplus.toolkit.base.tsp.util.ShortLivedCache;
import jdplus.toolkit.base.tsp.util.ShortLivedCaching;
import lombok.NonNull;

public final class MapCaching
implements ShortLivedCaching {
    private final LongSupplier ticker;

    public MapCaching() {
        this(System::nanoTime);
    }

    MapCaching(@NonNull LongSupplier ticker) {
        if (ticker == null) {
            throw new NullPointerException("ticker is marked non-null but is null");
        }
        this.ticker = ticker;
    }

    @Override
    @NonNull
    public String getId() {
        return "hashmap";
    }

    @Override
    @NonNull
    public <K, V> ShortLivedCache<K, V> ofTtl(@NonNull Duration ttl) {
        if (ttl == null) {
            throw new NullPointerException("ttl is marked non-null but is null");
        }
        return new TtlMapCache(new HashMap(), this.ticker, ttl);
    }

    @Override
    @NonNull
    public <K, V> ShortLivedCache<K, V> ofFile(@NonNull File file) {
        if (file == null) {
            throw new NullPointerException("file is marked non-null but is null");
        }
        return new FileMapCache(new HashMap(), file);
    }
}

