/*
 * Decompiled with CFR 0.152.
 */
package technology.tabula;

import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import technology.tabula.Utils;

public final class CohenSutherlandClipping {
    private double xMin;
    private double yMin;
    private double xMax;
    private double yMax;
    private static final int INSIDE = 0;
    private static final int LEFT = 1;
    private static final int RIGHT = 2;
    private static final int BOTTOM = 4;
    private static final int TOP = 8;

    public CohenSutherlandClipping() {
    }

    public CohenSutherlandClipping(Rectangle2D clip) {
        this.setClip(clip);
    }

    public void setClip(Rectangle2D clip) {
        this.xMin = clip.getX();
        this.xMax = this.xMin + clip.getWidth();
        this.yMin = clip.getY();
        this.yMax = this.yMin + clip.getHeight();
    }

    private final int regionCode(double x, double y) {
        int code;
        int n = x < this.xMin ? 1 : (code = x > this.xMax ? 2 : 0);
        if (y < this.yMin) {
            code |= 4;
        } else if (y > this.yMax) {
            code |= 8;
        }
        return code;
    }

    public boolean clip(Line2D.Float line) {
        double p1x = line.getX1();
        double p1y = line.getY1();
        double p2x = line.getX2();
        double p2y = line.getY2();
        double qx = 0.0;
        double qy = 0.0;
        boolean vertical = p1x == p2x;
        double slope = vertical ? 0.0 : (p2y - p1y) / (p2x - p1x);
        int c1 = this.regionCode(p1x, p1y);
        int c2 = this.regionCode(p2x, p2y);
        while (c1 != 0 || c2 != 0) {
            int c;
            if ((c1 & c2) != 0) {
                return false;
            }
            int n = c = c1 == 0 ? c2 : c1;
            if ((c & 1) != 0) {
                qx = this.xMin;
                qy = (Utils.feq(qx, p1x) ? 0.0 : qx - p1x) * slope + p1y;
            } else if ((c & 2) != 0) {
                qx = this.xMax;
                qy = (Utils.feq(qx, p1x) ? 0.0 : qx - p1x) * slope + p1y;
            } else if ((c & 4) != 0) {
                qy = this.yMin;
                qx = vertical ? p1x : (Utils.feq(qy, p1y) ? 0.0 : qy - p1y) / slope + p1x;
            } else if ((c & 8) != 0) {
                qy = this.yMax;
                double d = vertical ? p1x : (qx = (Utils.feq(qy, p1y) ? 0.0 : qy - p1y) / slope + p1x);
            }
            if (c == c1) {
                p1x = qx;
                p1y = qy;
                c1 = this.regionCode(p1x, p1y);
                continue;
            }
            p2x = qx;
            p2y = qy;
            c2 = this.regionCode(p2x, p2y);
        }
        line.setLine(p1x, p1y, p2x, p2y);
        return true;
    }
}

