/*
 * Decompiled with CFR 0.152.
 */
package com.levigo.jbig2.segments;

import com.levigo.jbig2.SegmentData;
import com.levigo.jbig2.SegmentHeader;
import com.levigo.jbig2.err.IntegerMaxValueException;
import com.levigo.jbig2.err.InvalidHeaderValueException;
import com.levigo.jbig2.io.SubInputStream;
import com.levigo.jbig2.util.CombinationOperator;
import java.io.IOException;

public class RegionSegmentInformation
implements SegmentData {
    private SubInputStream subInputStream;
    private int bitmapWidth;
    private int bitmapHeight;
    private int xLocation;
    private int yLocation;
    private CombinationOperator combinationOperator;

    public RegionSegmentInformation(SubInputStream subInputStream) {
        this.subInputStream = subInputStream;
    }

    public RegionSegmentInformation() {
    }

    public void parseHeader() throws IOException {
        this.bitmapWidth = (int)(this.subInputStream.readBits(32) & 0xFFFFFFFFFFFFFFFFL);
        this.bitmapHeight = (int)(this.subInputStream.readBits(32) & 0xFFFFFFFFFFFFFFFFL);
        this.xLocation = (int)(this.subInputStream.readBits(32) & 0xFFFFFFFFFFFFFFFFL);
        this.yLocation = (int)(this.subInputStream.readBits(32) & 0xFFFFFFFFFFFFFFFFL);
        this.subInputStream.readBits(5);
        this.readCombinationOperator();
    }

    private void readCombinationOperator() throws IOException {
        this.combinationOperator = CombinationOperator.translateOperatorCodeToEnum((short)(this.subInputStream.readBits(3) & 0xFL));
    }

    @Override
    public void init(SegmentHeader segmentHeader, SubInputStream subInputStream) throws InvalidHeaderValueException, IntegerMaxValueException, IOException {
    }

    public void setBitmapWidth(int n) {
        this.bitmapWidth = n;
    }

    public int getBitmapWidth() {
        return this.bitmapWidth;
    }

    public void setBitmapHeight(int n) {
        this.bitmapHeight = n;
    }

    public int getBitmapHeight() {
        return this.bitmapHeight;
    }

    public int getXLocation() {
        return this.xLocation;
    }

    public int getYLocation() {
        return this.yLocation;
    }

    public CombinationOperator getCombinationOperator() {
        return this.combinationOperator;
    }
}

