/*
 * Decompiled with CFR 0.152.
 */
package main;

import blbutil.Const;
import blbutil.FileUtil;
import blbutil.Utilities;
import dag.Dag;
import dag.DagUtil;
import java.io.File;
import java.io.PrintWriter;
import java.text.DecimalFormat;
import main.Main;
import main.NuclearFamilies;
import main.Par;
import vcf.Data;
import vcf.Marker;
import vcf.Markers;

public class RunStats {
    private static final DecimalFormat df2 = new DecimalFormat("0.00");
    private final Par par;
    private final PrintWriter log;
    private final long startNanos = System.nanoTime();
    private long buildNanos = 0L;
    private long lastBuildNanos = 0L;
    private long sampleNanos = 0L;
    private long totalSampleNanos = 0L;
    private long imputeNanos = 0L;
    private long totalImputeNanos = 0L;
    private long totalIbdNanos = 0L;
    private String dagStats = null;

    RunStats(Par par) {
        this.par = par;
        this.log = RunStats.log(par.out());
    }

    private static PrintWriter log(String string) {
        File file = new File(string + ".log");
        boolean bl = false;
        return FileUtil.nonBufferedPrintWriter(file, bl);
    }

    public void printStartInfo() {
        String string;
        Utilities.duoPrint(this.log, Main.shortHelp + Const.nl);
        Utilities.duoPrintln(this.log, "Start time: " + Utilities.timeStamp());
        Utilities.duoPrint(this.log, RunStats.commandLine("beagle.jar", this.par.args()));
        if (this.par.ped() != null) {
            string = Const.nl + "WARNING: This version will not model" + " duos or trios in the pedigree file";
            Utilities.duoPrintln(this.log, string);
        }
        if (this.par.map() == null) {
            string = Const.nl + "No genetic map is specified: using 1 cM = 1 Mb";
            Utilities.duoPrintln(this.log, string);
        }
        if (this.par.gt() == null && this.par.ref() != null && this.par.impute()) {
            assert (this.par.gl() != null || this.par.gtgl() != null);
            string = Const.nl + "WARNING: Imputation of ungenotyped markers will not be performed." + Const.nl + "         Imputation requires the \"gt=\" argument and called genotypes.";
            Utilities.duoPrintln(this.log, string);
        }
        if (this.par.gt() == null && this.par.ibd()) {
            assert (this.par.gl() != null || this.par.gtgl() != null);
            string = Const.nl + "WARNING: IBD segment detection will not be performed." + Const.nl + "         IBD analysis requires the \"gt=\" argument and called genotypes.";
            Utilities.duoPrintln(this.log, string);
        }
    }

    private static String commandLine(String string, String[] stringArray) {
        StringBuilder stringBuilder = new StringBuilder(stringArray.length * 20);
        long l = Runtime.getRuntime().maxMemory();
        stringBuilder.append(Const.nl);
        stringBuilder.append("Command line: java");
        if (l != Long.MAX_VALUE) {
            long l2 = l / 0x100000L;
            stringBuilder.append(" -Xmx");
            stringBuilder.append(l2);
            stringBuilder.append("m");
        }
        stringBuilder.append(" -jar ");
        stringBuilder.append(string);
        stringBuilder.append(Const.nl);
        for (int i = 0; i < stringArray.length; ++i) {
            stringBuilder.append("  ");
            stringBuilder.append(stringArray[i]);
            stringBuilder.append(Const.nl);
        }
        return stringBuilder.toString();
    }

    public void printSummaryAndClose(int n, int n2) {
        long l = System.nanoTime() - this.startNanos;
        if (n == n2) {
            Utilities.duoPrint(this.log, Const.nl);
            Utilities.duoPrint(this.log, "Number of markers:             ");
            Utilities.duoPrintln(this.log, String.format("%7d", n2));
        } else {
            Utilities.duoPrint(this.log, Const.nl);
            Utilities.duoPrint(this.log, "Number of reference markers:   ");
            this.duoPrintln7d(n2);
            Utilities.duoPrint(this.log, "Number of target markers:      ");
            this.duoPrintln7d(n);
        }
        if (this.buildNanos > 0L) {
            this.duoPrintNanos("Total time for building model: ", this.buildNanos);
        }
        if (this.totalSampleNanos > 1000L) {
            this.duoPrintNanos("Total time for sampling:       ", this.totalSampleNanos);
        }
        if (this.par.ibd()) {
            this.duoPrintNanos("Total time for IBD detection:  ", this.totalIbdNanos);
        }
        if (this.totalImputeNanos > 0L) {
            this.duoPrintNanos("Total time for imputation:     ", this.totalImputeNanos);
        }
        this.duoPrintNanos("Total run time:                ", l);
        Utilities.duoPrintln(this.log, Const.nl + "End time: " + Utilities.timeStamp());
        Utilities.duoPrintln(this.log, "beagle.08Jun17.d8b.jar (version 4.1) finished");
        this.log.close();
    }

    public void buildNanos(long l) {
        this.buildNanos += l;
    }

    public void sampleNanos(long l) {
        this.sampleNanos = l;
        this.totalSampleNanos += l;
    }

    public void imputationNanos(long l) {
        this.imputeNanos = l;
        this.totalImputeNanos += l;
    }

    public void ibdNanos(long l) {
        this.totalIbdNanos += l;
    }

    public void setDagStats(Dag dag) {
        this.dagStats = dag == null ? null : DagUtil.dagStats(dag);
    }

    public void printRefinedIbdUpdate(float f, Dag dag, long l) {
        Utilities.duoPrintln(this.log, Const.nl + "Refined IBD");
        Utilities.duoPrintln(this.log, "model scale: " + df2.format(f));
        this.duoPrintNanos("run time:    ", l);
        Utilities.duoPrint(this.log, Const.nl + DagUtil.dagStats(dag));
    }

    public void printImputationUpdate() {
        Utilities.duoPrint(this.log, Const.nl);
        this.duoPrintNanos("Imputation time (this window): ", this.imputeNanos);
    }

    public void printSampleSummary(NuclearFamilies nuclearFamilies, Data data) {
        Utilities.duoPrint(this.log, Const.nl);
        Utilities.duoPrint(this.log, "reference samples: ");
        this.duoPrintln7d(data.nRefSamples());
        Utilities.duoPrint(this.log, "target samples:    ");
        this.duoPrintln7d(data.nTargetSamples());
        if (this.par.ped() != null) {
            Utilities.duoPrint(this.log, "  ");
            Utilities.duoPrint(this.log, String.valueOf(nuclearFamilies.nSingles()));
            Utilities.duoPrintln(this.log, " singles");
            Utilities.duoPrint(this.log, "  ");
            Utilities.duoPrint(this.log, String.valueOf(nuclearFamilies.nDuos()));
            Utilities.duoPrintln(this.log, " duos");
            Utilities.duoPrint(this.log, "  ");
            Utilities.duoPrint(this.log, String.valueOf(nuclearFamilies.nTrios()));
            Utilities.duoPrintln(this.log, " trios");
        }
    }

    public void printWindowUpdate(Data data) {
        Markers markers = data.markers();
        Marker marker = markers.marker(0);
        Marker marker2 = markers.marker(markers.nMarkers() - 1);
        StringBuilder stringBuilder = new StringBuilder(30);
        stringBuilder.append(Const.nl);
        stringBuilder.append("Window ");
        stringBuilder.append(data.window());
        stringBuilder.append(" [ ");
        String string = marker.chrom();
        if (!string.equals(".")) {
            stringBuilder.append(string);
            stringBuilder.append(':');
        }
        stringBuilder.append(marker.pos());
        stringBuilder.append('-');
        if (!string.equals(marker2.chrom())) {
            stringBuilder.append(marker2.chrom());
            stringBuilder.append(':');
        }
        stringBuilder.append(marker2.pos());
        stringBuilder.append(" ]");
        stringBuilder.append(Const.nl);
        if (data.nRefSamples() > 0) {
            stringBuilder.append("reference markers: ");
            stringBuilder.append(String.format("%7d", data.nMarkers()));
            stringBuilder.append(Const.nl);
        }
        stringBuilder.append("target markers:    ");
        stringBuilder.append(String.format("%7d", data.nTargetMarkers()));
        Utilities.duoPrintln(this.log, stringBuilder.toString());
    }

    public void println(String string) {
        Utilities.duoPrintln(this.log, string);
    }

    public void printIterationUpdate(int n, int n2) {
        long l = this.buildNanos - this.lastBuildNanos;
        this.lastBuildNanos = this.buildNanos;
        Utilities.duoPrint(this.log, Const.nl + "Window=" + n + " Iteration=" + n2 + Const.nl);
        this.duoPrintNanos("Time for building model:         ", l);
        if (this.dagStats != null) {
            this.duoPrintNanos("Time for sampling (singles):     ", this.sampleNanos);
            this.sampleNanos = 0L;
        }
        if (this.dagStats != null) {
            Utilities.duoPrint(this.log, "DAG statistics" + Const.nl);
            Utilities.duoPrint(this.log, this.dagStats);
        }
        this.log.flush();
    }

    private static String elapsedNanos(String string, long l) {
        StringBuilder stringBuilder = new StringBuilder(string.length() + 30);
        stringBuilder.append(string);
        stringBuilder.append(Utilities.elapsedNanos(l));
        stringBuilder.append(Const.nl);
        return stringBuilder.toString();
    }

    private void duoPrintNanos(String string, long l) {
        Utilities.duoPrint(this.log, RunStats.elapsedNanos(string, l));
    }

    private void duoPrintln7d(int n) {
        Utilities.duoPrintln(this.log, String.format("%7d", n));
    }
}

