/*
 * Decompiled with CFR 0.152.
 */
package jdistlib;

import jdistlib.ChiSquare;
import jdistlib.Gamma;
import jdistlib.Poisson;
import jdistlib.generic.GenericDistribution;
import jdistlib.math.MathFunctions;
import jdistlib.rng.RandomEngine;

public class NonCentralChiSquare
extends GenericDistribution {
    static final double _dbl_min_exp = -707.7032713517042;
    protected double df;
    protected double ncp;

    public static final double density(double x, double df, double ncp, boolean give_log) {
        double q;
        double mid;
        double eps = 5.0E-15;
        double dfmid = 0.0;
        if (Double.isNaN(x) || Double.isNaN(df) || Double.isNaN(ncp)) {
            return x + df + ncp;
        }
        if (ncp < 0.0 || df <= 0.0) {
            return Double.NaN;
        }
        if (MathFunctions.isInfinite(df) || MathFunctions.isInfinite(ncp)) {
            return Double.NaN;
        }
        if (x < 0.0) {
            return give_log ? Double.NEGATIVE_INFINITY : 0.0;
        }
        if (x == 0.0 && df < 2.0) {
            return Double.POSITIVE_INFINITY;
        }
        if (ncp == 0.0) {
            return ChiSquare.density(x, df, give_log);
        }
        if (x == Double.POSITIVE_INFINITY) {
            return give_log ? Double.NEGATIVE_INFINITY : 0.0;
        }
        double ncp2 = 0.5 * ncp;
        double imax = Math.ceil((-(2.0 + df) + Math.sqrt((2.0 - df) * (2.0 - df) + 4.0 * ncp * x)) / 4.0);
        if (imax < 0.0) {
            imax = 0.0;
        }
        if (MathFunctions.isFinite(imax)) {
            dfmid = df + 2.0 * imax;
            mid = Poisson.density_raw(imax, ncp2, false) * ChiSquare.density(x, dfmid, false);
        } else {
            mid = 0.0;
        }
        if (mid == 0.0) {
            if (give_log || ncp > 1000.0) {
                double nl = df + ncp;
                double ic = nl / (nl + ncp);
                return ChiSquare.density(x * ic, nl * ic, give_log);
            }
            return give_log ? Double.NEGATIVE_INFINITY : 0.0;
        }
        double sum = mid;
        double term = mid;
        df = dfmid;
        double i = imax;
        double x2 = x * ncp2;
        do {
            q = x2 / (i += 1.0) / df;
            df += 2.0;
        } while (q >= 1.0 || term * q > (1.0 - q) * 5.0E-15 || term > 1.0E-10 * (sum += (term *= q)));
        term = mid;
        df = dfmid;
        i = imax;
        while (i != 0.0) {
            q = i * (df -= 2.0) / x2;
            i -= 1.0;
            sum += (term *= q);
            if (q < 1.0 && term * q <= (1.0 - q) * 5.0E-15) break;
        }
        return give_log ? Math.log(sum) : sum;
    }

    /*
     * Unable to fully structure code
     */
    public static final double cumulative_raw(double x, double f, double theta, double errmax, double reltol, int itrmax, boolean lower_tail, boolean log_p) {
        l_lam = -1.0;
        l_x = -1.0;
        lu = -1.0;
        _dbl_min_exp = -707.7032713517042;
        if (x <= 0.0) {
            if (x == 0.0 && f == 0.0) {
                return lower_tail != false ? Math.exp(-0.5 * theta) : -Math.expm1(-0.5 * theta);
            }
            return lower_tail != false ? 0.0 : 1.0;
        }
        if (MathFunctions.isInfinite(x)) {
            return lower_tail != false ? 1.0 : 0.0;
        }
        if (theta < 80.0) {
            sum = 0.0;
            sum2 = 0.0;
            lambda = 0.5 * theta;
            pr = Math.exp(-lambda);
            if (lower_tail && f > 0.0 && Math.log(x) < 0.6931471805599453 + 2.0 / f * (MathFunctions.lgammafn(f / 2.0 + 1.0) + -707.7032713517042)) {
                sum2 = -Infinity;
                sum = -Infinity;
                pr = -lambda;
                i = 0;
                while (i < 110) {
                    sum2 = MathFunctions.logspace_add(sum2, pr);
                    sum = MathFunctions.logspace_add(sum, pr + ChiSquare.cumulative(x, f + (double)(2 * i), lower_tail, true));
                    if (sum2 >= -1.0E-15) break;
                    pr += Math.log(lambda) - Math.log(++i);
                }
                ans = sum - sum2;
                return log_p != false ? ans : Math.exp(ans);
            }
            sum2 = 0.0;
            sum = 0.0;
            pr = Math.exp(-lambda);
            i = 0;
            while (i < 110) {
                sum += pr * ChiSquare.cumulative(x, f + (double)(2 * i), lower_tail, false);
                if ((sum2 += pr) >= 0.999999999999999) break;
                pr *= lambda / (double)(++i);
            }
            ans = sum / sum2;
            return log_p != false ? Math.log(ans) : ans;
        }
        lam = 0.5 * theta;
        v0 = lamSml = -lam < -707.7032713517042;
        if (lamSml) {
            u = 0.0;
            lu = -lam;
            l_lam = Math.log(lam);
        } else {
            u = Math.exp(-lam);
        }
        v = u;
        x2 = 0.5 * x;
        f2 = 0.5 * f;
        f_x_2n = f - x;
        if (!(f2 * 2.220446049250313E-16 > 0.125)) ** GOTO lbl-1000
        t = x2 - f2;
        if (Math.abs(v1) < Math.sqrt(2.220446049250313E-16) * f2) {
            lt = (1.0 - t) * (2.0 - t / (f2 + 1.0)) - 0.9189385332046728 - 0.5 * Math.log(f2 + 1.0);
        } else lbl-1000:
        // 2 sources

        {
            lt = f2 * Math.log(x2) - x2 - MathFunctions.lgammafn(f2 + 1.0);
        }
        v2 = tSml = lt < -707.7032713517042;
        if (tSml) {
            if (x > f + theta + 5.0 * Math.sqrt(2.0 * (f + 2.0 * theta))) {
                return lower_tail ? (log_p ? 0.0 : 1.0) : (log_p != false ? -Infinity : 0.0);
            }
            l_x = Math.log(x);
            t = 0.0;
            term = 0.0;
            ans = 0.0;
        } else {
            t = Math.exp(lt);
            ans = term = v * t;
        }
        n = 1;
        f_2n = f + 2.0;
        f_x_2n += 2.0;
        while (true) {
            if (f_x_2n > 0.0) {
                bound = t * x / f_x_2n;
                is_it = false;
                is_r = false;
                is_b = bound <= errmax;
                if (is_b && (is_r = term <= reltol * ans) || (is_it = n > itrmax)) break;
            }
            if (lamSml) {
                if ((lu += l_lam - Math.log(n)) >= -707.7032713517042) {
                    v = u = Math.exp(lu);
                    lamSml = false;
                }
            } else {
                v += (u *= lam / (double)n);
            }
            if (tSml) {
                if ((lt += l_x - Math.log(f_2n)) >= -707.7032713517042) {
                    t = Math.exp(lt);
                    tSml = false;
                }
            } else {
                t *= x / f_2n;
            }
            if (!lamSml && !tSml) {
                term = v * t;
                ans += term;
            }
            ++n;
            f_2n += 2.0;
            f_x_2n += 2.0;
        }
        if (is_it) {
            System.err.println("NonCentralChiSquare.density non-convergence error");
        }
        return lower_tail ? (log_p ? Math.log(ans) : ans) : (log_p != false ? Math.log1p(-ans) : 0.5 - ans + 0.5);
    }

    public static final double cumulative(double x, double df, double ncp, boolean lower_tail, boolean log_p) {
        if (Double.isNaN(x) || Double.isNaN(df) || Double.isNaN(ncp)) {
            return x + df + ncp;
        }
        if (MathFunctions.isInfinite(df) || MathFunctions.isInfinite(ncp)) {
            return Double.NaN;
        }
        if (df < 0.0 || ncp < 0.0) {
            return Double.NaN;
        }
        double ans = NonCentralChiSquare.cumulative_raw(x, df, ncp, 1.0E-12, 1.7763568394002505E-15, 1000000, lower_tail, log_p);
        if (ncp >= 80.0) {
            if (lower_tail) {
                ans = Math.min(ans, log_p ? 0.0 : 1.0);
            } else {
                double d = log_p ? -23.02585092994046 : 1.0E-10;
                if (ans < d) {
                    System.err.println("Precision error NonCentralChiSquare.cumulative");
                }
                if (!log_p) {
                    ans = Math.max(ans, 0.0);
                }
            }
        }
        if (!log_p || ans < -1.0E-8) {
            return ans;
        }
        ans = NonCentralChiSquare.cumulative_raw(x, df, ncp, 1.0E-12, 1.7763568394002505E-15, 1000000, !lower_tail, false);
        return Math.log1p(-ans);
    }

    /*
     * Unable to fully structure code
     */
    public static final double quantile(double p, double df, double ncp, boolean lower_tail, boolean log_p) {
        block26: {
            accu = 1.0E-13;
            racc = 8.881784197001252E-16;
            Eps = 1.0E-11;
            rEps = 1.0E-10;
            if (Double.isNaN(p) || Double.isNaN(df) || Double.isNaN(ncp)) {
                return p + df + ncp;
            }
            if (MathFunctions.isInfinite(df)) {
                return NaN;
            }
            if (df < 0.0 || ncp < 0.0) {
                return NaN;
            }
            if (log_p) {
                if (p > 0.0) {
                    return NaN;
                }
                if (p == 0.0) {
                    return lower_tail != false ? Infinity : 0.0;
                }
                if (p == -Infinity) {
                    return lower_tail != false ? 0.0 : Infinity;
                }
            } else {
                if (p < 0.0 || p > 1.0) {
                    return NaN;
                }
                if (p == 0.0) {
                    return lower_tail != false ? 0.0 : Infinity;
                }
                if (p == 1.0) {
                    return lower_tail != false ? Infinity : 0.0;
                }
            }
            v0 = pp = log_p != false ? Math.exp(p) : p;
            if (pp > 0.9999999999999998) {
                return lower_tail != false ? Infinity : 0.0;
            }
            b = ncp * ncp / (df + 3.0 * ncp);
            c = (df + 3.0 * ncp) / (df + 2.0 * ncp);
            ff = (df + 2.0 * ncp) / (c * c);
            ux = b + c * ChiSquare.quantile(p, ff, lower_tail, log_p);
            if (ux < 0.0) {
                ux = 1.0;
            }
            ux0 = ux;
            if (!lower_tail && ncp >= 80.0) {
                if (pp < 1.0E-10) {
                    System.err.println("Precision loss detected in NonCentralChiSquare.quantile");
                }
                p = log_p != false ? -Math.expm1(p) : 0.5 - p + 0.5;
                lower_tail = true;
            } else {
                p = pp;
            }
            pp = Math.min(0.9999999999999998, p * 1.00000000001);
            if (!lower_tail) ** GOTO lbl54
            while (ux < 1.7976931348623157E308 && NonCentralChiSquare.cumulative_raw(ux, df, ncp, 1.0E-11, 1.0E-10, 10000, true, false) < pp) {
                ux *= 2.0;
            }
            pp = p * 0.99999999999;
            lx = Math.min(ux0, 1.7976931348623157E308);
            while (lx > 2.2250738585072014E-308 && NonCentralChiSquare.cumulative_raw(lx, df, ncp, 1.0E-11, 1.0E-10, 10000, true, false) > pp) {
                lx *= 0.5;
            }
            break block26;
lbl-1000:
            // 1 sources

            {
                ux *= 2.0;
lbl54:
                // 2 sources

                ** while (ux < 1.7976931348623157E308 && NonCentralChiSquare.cumulative_raw((double)ux, (double)df, (double)ncp, (double)1.0E-11, (double)1.0E-10, (int)10000, (boolean)false, (boolean)false) > pp)
            }
lbl55:
            // 1 sources

            pp = p * 0.99999999999;
            lx = Math.min(ux0, 1.7976931348623157E308);
            while (lx > 2.2250738585072014E-308 && NonCentralChiSquare.cumulative_raw(lx, df, ncp, 1.0E-11, 1.0E-10, 10000, false, false) < pp) {
                lx *= 0.5;
            }
        }
        if (lower_tail) {
            do {
                if (NonCentralChiSquare.cumulative_raw(nx = 0.5 * (lx + ux), df, ncp, 1.0E-13, 8.881784197001252E-16, 100000, true, false) > p) {
                    ux = nx;
                    continue;
                }
                lx = nx;
            } while ((ux - lx) / nx > 1.0E-13);
        } else {
            do {
                if (NonCentralChiSquare.cumulative_raw(nx = 0.5 * (lx + ux), df, ncp, 1.0E-13, 8.881784197001252E-16, 100000, false, false) < p) {
                    ux = nx;
                    continue;
                }
                lx = nx;
            } while ((ux - lx) / nx > 1.0E-13);
        }
        return 0.5 * (ux + lx);
    }

    public static final double random(double df, double lambda, RandomEngine random) {
        if (MathFunctions.isInfinite(df) || MathFunctions.isInfinite(lambda) || df < 0.0 || lambda < 0.0) {
            return Double.NaN;
        }
        if (lambda == 0.0) {
            if (df == 0.0) {
                return Double.NaN;
            }
            return Gamma.random(df / 2.0, 2.0, random);
        }
        double r = Poisson.random(lambda / 2.0, random);
        if (r > 0.0) {
            r = ChiSquare.random(2.0 * r, random);
        }
        if (df > 0.0) {
            r += Gamma.random(df / 2.0, 2.0, random);
        }
        return r;
    }

    public static final double[] random(int n, double df, double lambda, RandomEngine random) {
        double[] rand = new double[n];
        int i = 0;
        while (i < n) {
            rand[i] = NonCentralChiSquare.random(df, lambda, random);
            ++i;
        }
        return rand;
    }

    public NonCentralChiSquare(double df, double ncp) {
        this.df = df;
        this.ncp = ncp;
    }

    public double density(double x, boolean log) {
        return NonCentralChiSquare.density(x, this.df, this.ncp, log);
    }

    public double cumulative(double p, boolean lower_tail, boolean log_p) {
        return NonCentralChiSquare.cumulative(p, this.df, this.ncp, lower_tail, log_p);
    }

    public double quantile(double q, boolean lower_tail, boolean log_p) {
        return NonCentralChiSquare.quantile(q, this.df, this.ncp, lower_tail, log_p);
    }

    public double random() {
        return NonCentralChiSquare.random(this.df, this.ncp, this.random);
    }
}

