# rgoogleads 0.10.0
* Пакет переведён на работу с Google Ads API v14.

# rgoogleads 0.9.2
* Исправил работу функции `gads_get_geo_targets()`, ранее данная функция сразу считывала справочник регионов из csv файла по ссылке, теперь Google в своей справке выкладывает не csv файл, а zip архив, поэтому функция сначала скачивает и распаковывает архив, а потом уже считывает данные из распакованного csv файла.

# rgoogleads 0.9.1
* Исправленна ссылка в документации функции `gads_get_accessible_customers()`.

# rgoogleads 0.9.0
* Пакет переведён на работу с Google Ads API v13.

# rgoogleads 0.8.1
* Из виньеток удалены битые ссылки на устаревший раздел документации по миграции с Google AdWords API на Google Ads API.

# rgoogleads 0.8.0
* Пакет переведён на работу с [Google Ads API 11.0](https://developers.google.com/google-ads/api/docs/release-notes#v11)
* В связи с тем, что HTML документация в R 4.2.0 переведена на использование HTML5 по требованиям CRAN была заново сгенерирована вся документация пакета.

# rgoogleads 0.7.1
* Исправил ссылки на документацию к Google Ads API, с v8 на v10.

# rgoogleads 0.7.0
* Пакет переведён на работу с Google Ads API v10.
* В блок `gads_utils.R` добавлена функция `gads_make_request()`, теперь это основная функция генерации HTTP запроса, она используется в остальных функциях для отправки запросов.
* Исправил логическую ошибку в функции `gads_get_report()`, ранее функция формировала запрос, и только потом осуществляла проверку, может ли указанный ресурс запрашиваться с сегментами времени.
* Полностью переписана функция `gads_customer()`, ранее она была написана на основе метода get, [который в 10 версии API был упразднён](https://developers.google.com/google-ads/api/docs/release-notes#all_services), теперь функция использует метод `SearchStream `. Это обновление так же затронуло функцию `gads_get_accessible_customers()`, т.к. в неё использовалась `gads_customer()`.

# rgoogleads 0.6.0
* В функцию `gads_get_report()` добавлен аргумент gaql_query, который позволяет передать функции готовый текст запроса, скопированный из [QueryBuilder](https://developers.google.com/google-ads/api/fields/v10/overview_query_builder).
* Новая функция `gads_get_keywords()` для запроса списка ключевых слов.

# rgoogleads 0.5.1
* Исправление некоторых ссылок для публикации в CRAN

# rgoogleads 0.5.0

## Исправление ошибок
* Исправлено переопределение даты по ресурсам, которые нельзя фильтровать по времени, [тикет #9](https://github.com/selesnow/rgoogleads/issues/9).
* Исправлена ошибка работы аргумента `during` в функции `gads_get_report_helper()`.
* Исправлена ошибка в парсинге обработки сообщений об ошибках полученных от Google Ads API.

## Прочее
* Процесс формирования GAQL запроса выделен в отдельную функцию `gads_make_query()`, и теперь является частью блока gads_utils.R.
* Добавил опцию `gads.show_gaql_query`, которая позволяет вывести GAQL запрос.

# rgoogleads 0.4.1

* Дата релиза: 2021-11-24

* Процесс проверки совместимости запрашиваемого ресурса с сегментами даты вынесен на более высокий уровень, из функции gads_get_report_helper() в функцию gads_get_report().
* Кеш функции `gads_get_fields_cached()` теперь сохраняется в памяти, а не на жестком диске. И действует только в ходе текщей R сессии. Связано с тем, что присохранении на диск, после установки из CRAN пакет не мог получить доступ к кешу. Т.е. связано с ошибкой `Attempted to use cache which has been destroyed`.

# rgoogleads 0.4.0

* Дата релиза: 2021-11-16

## Прочее
* Пакет переведён на работу с Google Ads API v9.
* В пакет добавлена поддержка переменной среды GADS_EMAIL, которая устанавливает дефолтный email для работы с Google Ads API при подключении пакета.
* В основную функцию запроса данных `gads_get_report_helper()` добавлена проверка, можно ли запрашивать с указанным ресурсом поля даты, если нет, то функция аннулирует значения аргументов `date_from`, `date_to`  и `during`.
* В зависимости `rgoogleads` добавлены следующие пакеты: `memoise`, `cachem`, `rappdirs`. Эти пакеты обеспечивают кеширование данных, получаемых функцией `gads_get_fields()`, которая используется внутри `gads_get_report_helper()` для проверки совместимости запрашиваемого ресурса с полями даты.

# rgoogleads 0.3.0

* Дата релиза: 2021-09-02

## Документация:
* Добавлена виньетка "Миграция с RAdwords на rgoogleads" по переходу с пакета `RAdwords` на `rgoogleads`.
* Добавлена англоязычная виньетка "Migrate from RAdwords to rgoogleads" по переходу с пакета `RAdwords` на `rgoogleads`.

## Исправление ошибок
* Исправил работу аргумента during в функции `gads_report_helper()`.

## Прочее
* Актуализировал раздел статей сайта.
* Добавил список ссылок на статиь о пакета на главную страницу сайта.
* В функции `gads_report_helper()` добавлена конвертация метрик в числовой тип данных.

# rgoogleads 0.2.0

* Дата релиза: 2021-08-02

## Новые функции:
* Добавлена функция `gads_get_fields()`, которая позволяет получить подробную информацию по любому ресурсу, полю ресурса, сегмету или метрике.
* Добавлена функция `gads_get_geo_targets()`, которая загружает наиболее актуальный справочник гео таргетинга из https://developers.google.com/google-ads/api/reference/data/geotargets?hl=en.
* Добавлена функция `gads_get_metadata()`, которая позволяет получить список всех объектов вместе с их метаданными, т.е. ресурсов, сегментов, метрик и атриутов.
* Добавлена функция `gads_keyword_plan_historical_metrics()`, с помощью которой вы можете запрашивать данные по сохраннным планам ключевых слов.
* Добавлена функция `gads_keyword_plan_forecast_timeseries()`, которая позволяет запросить прогноз в виде временного ряда для плана ключевых слов на следующие 52 недели.
* Добавлена функция `gads_keyword_plan_forecast_metrics()`, которая возвращает запрошенные прогнозы плана ключевых слов.
* Добавлена функция `gads_open_auth_cache_folder()`, с помощью которой можно открыть папаку, в которой хранятся учётные данные.
    
## Документация:
* Доработана основная страница документации пакета
* Расширена документация функции `gads_get_report()`
* Расширена документация функции `gads_auth()`
* В документацию к функциям загрузки объектов добавлены примеры кода: `gads_get_ad_group_criterions()`, `gads_get_ad_groups()`, `gads_get_ads()`, `gads_get_campaigns()`.

## Прочие доработки:
* OAuth клиент вшитый в пакет прошел верификацию Google, теперь любой пользователь пакета может использовать вшитый в `rgoogleads` OAuth клиент для авторизации.
* Вшитый в пакет токен разработчика получил стандартный уровень доступа к API.
* Добавлена опция `gads.column.name.case.fun`, с помощью которой можно передать любую функцию для приведения названий столбцов в полученном от API результате в указанный регистр, по умолчанию передаётся функция `to_snake_case()` из пакета `snakecase`.
* Доработана функция проверки ответа от API на ошибки.
* В функцию `gads_auth_configure()` добавлен аргумент developer_token.
* В DESCRIPTION изменил версии некоторых пакетов.
* Все функций пакета, отправляющие POST и GET запросы к API переведены с глаголов из `httr` на глаголы `gargle`: `request_build()`, `request_retry()`, `response_process()`. В качестве эксперемента пока, что переведена вспомогательная функция `gads_customer_id()`.
* Новый логотип пакета.
* В функцию `gads_get_report()` добавлен аргумент during, который позволяет задавать относительный период отчёта, например 'LAST_BUSINESS_WEEK'.
* Исправил ошибку в функции `gads_get_report()`, когда поле в названии которого содержится date нельзя перевести в дату.
* Создал сайт пакета с помощью `pkgdown`, сайт доступен по [ссылке](https://selesnow.github.io/rgoogleads/docs/).

# rgoogleads 0.1.1

* Дата релиза: 2021-07-02

* Доработал README
* Исправил поле авторства в DESCRIPTION, правильно вписав Netpeak
* Пакет опубликован на CRAN

---
# rgoogleads 0.1.0

* Первый релиз.
* Добавлен `NEWS.md` для отслеживания изменений внесённых в пакет.
