/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.util.objects.setDataStructures.constant;

import gnu.trove.set.hash.TIntHashSet;
import java.util.Arrays;
import org.chocosolver.util.objects.setDataStructures.ISet;
import org.chocosolver.util.objects.setDataStructures.ISetIterator;
import org.chocosolver.util.objects.setDataStructures.SetType;

public class Set_FixedArray
implements ISet {
    protected final int size;
    protected final int[] values;
    protected ISetIterator iter = this.newIterator();

    public Set_FixedArray(int[] vls) {
        this.values = new TIntHashSet(vls).toArray();
        Arrays.sort(this.values);
        this.size = this.values.length;
    }

    @Override
    public boolean add(int element) {
        if (this.contains(element)) {
            return false;
        }
        throw new UnsupportedOperationException("Cannot add element to Set_FixedArray");
    }

    @Override
    public boolean remove(int element) {
        if (!this.contains(element)) {
            return false;
        }
        throw new UnsupportedOperationException("Cannot remove element from Set_FixedArray");
    }

    @Override
    public boolean contains(int element) {
        return Arrays.binarySearch(this.values, element) >= 0;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public void clear() {
        if (this.size > 0) {
            throw new UnsupportedOperationException("Cannot clear Set_FixedArray");
        }
    }

    public String toString() {
        StringBuilder st = new StringBuilder("{");
        ISetIterator iter = this.newIterator();
        while (iter.hasNext()) {
            st.append(iter.nextInt()).append(", ");
        }
        st.append("}");
        return st.toString().replace(", }", "}");
    }

    @Override
    public SetType getSetType() {
        return SetType.FIXED_ARRAY;
    }

    @Override
    public void registerObserver(ISet set, int idx) {
    }

    @Override
    public int min() {
        if (this.isEmpty()) {
            throw new IllegalStateException("cannot find minimum of an empty set");
        }
        return this.values[0];
    }

    @Override
    public int max() {
        if (this.isEmpty()) {
            throw new IllegalStateException("cannot find maximum of an empty set");
        }
        return this.values[this.size - 1];
    }

    @Override
    public ISetIterator iterator() {
        this.iter.reset();
        return this.iter;
    }

    @Override
    public ISetIterator newIterator() {
        return new ISetIterator(){
            private int idx;

            @Override
            public void reset() {
                this.idx = 0;
            }

            @Override
            public boolean hasNext() {
                return this.idx < Set_FixedArray.this.size;
            }

            @Override
            public int nextInt() {
                ++this.idx;
                return Set_FixedArray.this.values[this.idx - 1];
            }
        };
    }
}

