/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.constraints.nary.sum;

import gnu.trove.map.hash.TIntIntHashMap;
import java.util.Arrays;
import org.chocosolver.solver.Model;
import org.chocosolver.solver.constraints.Constraint;
import org.chocosolver.solver.constraints.Operator;
import org.chocosolver.solver.constraints.extension.TuplesFactory;
import org.chocosolver.solver.constraints.nary.sum.PropScalar;
import org.chocosolver.solver.constraints.nary.sum.PropSum;
import org.chocosolver.solver.constraints.nary.sum.PropSumBool;
import org.chocosolver.solver.constraints.nary.sum.PropSumBoolIncr;
import org.chocosolver.solver.constraints.nary.sum.PropSumFullBool;
import org.chocosolver.solver.constraints.nary.sum.PropSumFullBoolIncr;
import org.chocosolver.solver.constraints.nary.sum.SumConstraint;
import org.chocosolver.solver.constraints.ternary.PropXplusYeqZ;
import org.chocosolver.solver.exception.SolverException;
import org.chocosolver.solver.variables.IntVar;
import org.chocosolver.util.tools.VariableUtils;

public class IntLinCombFactory {
    private IntLinCombFactory() {
    }

    public static Constraint reduce(IntVar[] VARS, Operator OPERATOR, IntVar SUM, int minCardForDecomposition) {
        int[] COEFFS = new int[VARS.length];
        Arrays.fill(COEFFS, 1);
        return IntLinCombFactory.reduce(VARS, COEFFS, OPERATOR, SUM, minCardForDecomposition);
    }

    public static Constraint reduce(IntVar[] VARS, int[] COEFFS, Operator OPERATOR, IntVar SCALAR, int minCardForDecomposition) {
        int[] NCOEFFS;
        IntVar[] NVARS;
        Model model = SCALAR.getModel();
        if (VARS.length > minCardForDecomposition) {
            int k = VARS.length;
            int d1 = (int)Math.sqrt(k);
            int d2 = k / d1 + (k % d1 == 0 ? 0 : 1);
            IntVar[] intermVar = new IntVar[d1];
            int i = 0;
            int z = 0;
            while (i < k) {
                int size = Math.min(i + d2, k);
                IntVar[] copyV = Arrays.copyOfRange(VARS, i, size);
                int[] copyC = Arrays.copyOfRange(COEFFS, i, size);
                int[] bounds = VariableUtils.boundsForScalar(copyV, copyC);
                intermVar[z] = model.intVar(bounds[0], bounds[1]);
                model.scalar(copyV, copyC, "=", intermVar[z]).post();
                i += d2;
                ++z;
            }
            return model.sum(intermVar, OPERATOR.toString(), SCALAR);
        }
        long RESULT = 0L;
        if (VariableUtils.isConstant(SCALAR)) {
            RESULT = SCALAR.getValue();
            NVARS = (IntVar[])VARS.clone();
            NCOEFFS = (int[])COEFFS.clone();
        } else {
            NVARS = new IntVar[VARS.length + 1];
            System.arraycopy(VARS, 0, NVARS, 0, VARS.length);
            NVARS[VARS.length] = SCALAR;
            NCOEFFS = new int[COEFFS.length + 1];
            System.arraycopy(COEFFS, 0, NCOEFFS, 0, COEFFS.length);
            NCOEFFS[COEFFS.length] = -1;
        }
        int k = 0;
        int nbools = 0;
        int nones = 0;
        int nmones = 0;
        int ldom = 0;
        int lidx = -1;
        TIntIntHashMap map = new TIntIntHashMap(NVARS.length, 1.5f, -1, -1);
        for (int i = 0; i < NVARS.length; ++i) {
            if (VariableUtils.isConstant(NVARS[i])) {
                RESULT -= (long)NVARS[i].getValue() * (long)NCOEFFS[i];
                NCOEFFS[i] = 0;
                continue;
            }
            if (NCOEFFS[i] == 0) continue;
            int id = NVARS[i].getId();
            int pos = map.get(id);
            if (pos == -1) {
                map.put(id, k);
                NVARS[k] = NVARS[i];
                NCOEFFS[k] = NCOEFFS[i];
                ++k;
                continue;
            }
            int n = pos;
            NCOEFFS[n] = NCOEFFS[n] + NCOEFFS[i];
            NCOEFFS[i] = 0;
        }
        int _k = k;
        k = 0;
        long slb = 0L;
        long sub = 0L;
        for (int i = 0; i < _k; ++i) {
            if (NCOEFFS[i] == 0) continue;
            if (NCOEFFS[i] > 0) {
                slb += (long)NVARS[i].getLB() * (long)NCOEFFS[i];
                sub += (long)NVARS[i].getUB() * (long)NCOEFFS[i];
            } else {
                slb += (long)NVARS[i].getUB() * (long)NCOEFFS[i];
                sub += (long)NVARS[i].getLB() * (long)NCOEFFS[i];
            }
            if (NVARS[i].isBool()) {
                ++nbools;
            }
            if (NCOEFFS[i] == 1) {
                ++nones;
            }
            if (NCOEFFS[i] == -1) {
                ++nmones;
            }
            NVARS[k] = NVARS[i];
            NCOEFFS[k] = NCOEFFS[i];
            if (NVARS[k].getDomainSize() > ldom) {
                lidx = k;
                ldom = NVARS[k].getDomainSize();
            }
            ++k;
        }
        if (k == 0) {
            switch (OPERATOR) {
                case EQ: {
                    return RESULT == 0L ? model.trueConstraint() : model.falseConstraint();
                }
                case NQ: {
                    return RESULT != 0L ? model.trueConstraint() : model.falseConstraint();
                }
                case LE: {
                    return RESULT >= 0L ? model.trueConstraint() : model.falseConstraint();
                }
                case LT: {
                    return RESULT > 0L ? model.trueConstraint() : model.falseConstraint();
                }
                case GE: {
                    return RESULT <= 0L ? model.trueConstraint() : model.falseConstraint();
                }
                case GT: {
                    return RESULT < 0L ? model.trueConstraint() : model.falseConstraint();
                }
            }
            throw new SolverException("Unexpected operator " + (Object)((Object)OPERATOR) + " (should be in {\"=\", \"!=\", \">\",\"<\",\">=\",\"<=\"})");
        }
        if (slb < Integer.MIN_VALUE || slb > Integer.MAX_VALUE) {
            throw new SolverException("Sum of lower bounds under/overflows. Consider reducing variables' domain to prevent this.");
        }
        if (sub < Integer.MIN_VALUE || sub > Integer.MAX_VALUE) {
            throw new SolverException("Sum of upper bounds under/overflows. Consider reducing variables' domain to prevent this.");
        }
        if (RESULT < Integer.MIN_VALUE || RESULT > Integer.MAX_VALUE) {
            throw new SolverException("RHS under/overflows. Consider reducing it to prevent this.");
        }
        if (RESULT - slb < Integer.MIN_VALUE || RESULT - slb > Integer.MAX_VALUE || sub - RESULT < Integer.MIN_VALUE || sub - RESULT > Integer.MAX_VALUE) {
            throw new SolverException("Integer under/overflow detected. Consider reducing variables' domain and/or RHS to prevent this.");
        }
        if (k < NVARS.length) {
            NVARS = (IntVar[])Arrays.copyOf(NVARS, k, IntVar[].class);
            NCOEFFS = Arrays.copyOf(NCOEFFS, k);
        }
        if (ldom > 2 && lidx < k - 1) {
            IntVar t = NVARS[k - 1];
            NVARS[k - 1] = NVARS[lidx];
            NVARS[lidx] = t;
            int i = NCOEFFS[k - 1];
            NCOEFFS[k - 1] = NCOEFFS[lidx];
            NCOEFFS[lidx] = i;
        }
        if (nones + nmones == NVARS.length) {
            return IntLinCombFactory.selectSum(NVARS, NCOEFFS, OPERATOR, (int)RESULT, nbools);
        }
        return IntLinCombFactory.selectScalar(NVARS, NCOEFFS, OPERATOR, (int)RESULT);
    }

    public static Constraint selectSum(IntVar[] VARS, int[] COEFFS, Operator OPERATOR, int RESULT, int nbools) {
        Model s = VARS[0].getModel();
        switch (VARS.length) {
            case 1: {
                if (COEFFS[0] == 1) {
                    return s.arithm(VARS[0], OPERATOR.toString(), RESULT);
                }
                assert (COEFFS[0] == -1);
                return s.arithm(VARS[0], Operator.getFlip(OPERATOR.toString()), -RESULT);
            }
            case 2: {
                if (COEFFS[0] == 1 && COEFFS[1] == 1) {
                    return s.arithm(VARS[0], "+", VARS[1], OPERATOR.toString(), RESULT);
                }
                if (COEFFS[0] == 1 && COEFFS[1] == -1) {
                    return s.arithm(VARS[0], "-", VARS[1], OPERATOR.toString(), RESULT);
                }
                if (COEFFS[0] == -1 && COEFFS[1] == 1) {
                    return s.arithm(VARS[1], "-", VARS[0], OPERATOR.toString(), RESULT);
                }
                assert (COEFFS[0] == -1 && COEFFS[1] == -1);
                return s.arithm(VARS[0], "+", VARS[1], Operator.getFlip(OPERATOR.toString()), -RESULT);
            }
            case 3: {
                if (RESULT != 0 || OPERATOR != Operator.EQ) break;
                if (COEFFS[0] == 1 && COEFFS[1] == 1 && COEFFS[2] == -1 || COEFFS[0] == -1 && COEFFS[1] == -1 && COEFFS[2] == 1) {
                    return new Constraint("SUM", new PropXplusYeqZ(VARS[0], VARS[1], VARS[2]));
                }
                if (COEFFS[0] == 1 && COEFFS[1] == -1 && COEFFS[2] == 1 || COEFFS[0] == -1 && COEFFS[1] == 1 && COEFFS[2] == -1) {
                    return new Constraint("SUM", new PropXplusYeqZ(VARS[0], VARS[2], VARS[1]));
                }
                if ((COEFFS[0] != -1 || COEFFS[1] != 1 || COEFFS[2] != 1) && (COEFFS[0] != 1 || COEFFS[1] != -1 || COEFFS[2] != -1)) break;
                return new Constraint("SUM", new PropXplusYeqZ(VARS[1], VARS[2], VARS[0]));
            }
        }
        int b = 0;
        int e = VARS.length;
        IntVar[] tmpV = new IntVar[e];
        for (int i = VARS.length - 1; i >= 0; --i) {
            IntVar key = VARS[i];
            if (COEFFS[i] > 0) {
                tmpV[b++] = key;
                continue;
            }
            if (COEFFS[i] >= 0) continue;
            tmpV[--e] = key;
        }
        if (OPERATOR == Operator.GT) {
            OPERATOR = Operator.GE;
            ++RESULT;
        } else if (OPERATOR == Operator.LT) {
            OPERATOR = Operator.LE;
            --RESULT;
        }
        Model model = VARS[0].getModel();
        if (nbools == VARS.length) {
            if (model.getSettings().enableIncrementalityOnBoolSum(tmpV.length)) {
                return new SumConstraint(new PropSumFullBoolIncr(model.toBoolVar(tmpV), b, OPERATOR, RESULT));
            }
            return new SumConstraint(new PropSumFullBool(model.toBoolVar(tmpV), b, OPERATOR, RESULT));
        }
        if (nbools == VARS.length - 1 && !tmpV[tmpV.length - 1].isBool() && COEFFS[VARS.length - 1] == -1) {
            if (model.getSettings().enableIncrementalityOnBoolSum(tmpV.length)) {
                return new SumConstraint(new PropSumBoolIncr(model.toBoolVar(Arrays.copyOf(tmpV, tmpV.length - 1)), b, OPERATOR, tmpV[tmpV.length - 1], RESULT));
            }
            return new SumConstraint(new PropSumBool(model.toBoolVar(Arrays.copyOf(tmpV, tmpV.length - 1)), b, OPERATOR, tmpV[tmpV.length - 1], RESULT));
        }
        return new SumConstraint(new PropSum(tmpV, b, OPERATOR, RESULT));
    }

    public static Constraint selectScalar(IntVar[] VARS, int[] COEFFS, Operator OPERATOR, int RESULT) {
        Model s = VARS[0].getModel();
        if (VARS.length == 1 && OPERATOR == Operator.EQ) {
            return s.times(VARS[0], COEFFS[0], s.intVar(RESULT));
        }
        if (VARS.length == 2 && OPERATOR == Operator.EQ && RESULT == 0) {
            if (COEFFS[0] == 1) {
                return s.times(VARS[1], -COEFFS[1], VARS[0]);
            }
            if (COEFFS[0] == -1) {
                return s.times(VARS[1], COEFFS[1], VARS[0]);
            }
            if (COEFFS[1] == 1) {
                return s.times(VARS[0], -COEFFS[0], VARS[1]);
            }
            if (COEFFS[1] == -1) {
                return s.times(VARS[0], COEFFS[0], VARS[1]);
            }
        }
        if (Operator.EQ == OPERATOR && VARS[VARS.length - 1].hasEnumeratedDomain() && TuplesFactory.canBeTupled(Arrays.copyOf(VARS, VARS.length - 1))) {
            return s.table(VARS, TuplesFactory.scalar(Arrays.copyOf(VARS, VARS.length - 1), Arrays.copyOf(COEFFS, COEFFS.length - 1), OPERATOR.toString(), VARS[VARS.length - 1], -COEFFS[COEFFS.length - 1], RESULT));
        }
        int b = 0;
        int e = VARS.length;
        IntVar[] tmpV = new IntVar[e];
        int[] tmpC = new int[e];
        for (int i = 0; i < VARS.length; ++i) {
            IntVar key = VARS[i];
            if (COEFFS[i] > 0) {
                tmpV[b] = key;
                tmpC[b++] = COEFFS[i];
                continue;
            }
            if (COEFFS[i] >= 0) continue;
            tmpV[--e] = key;
            tmpC[e] = COEFFS[i];
        }
        if (OPERATOR == Operator.GT) {
            OPERATOR = Operator.GE;
            ++RESULT;
        } else if (OPERATOR == Operator.LT) {
            OPERATOR = Operator.LE;
            --RESULT;
        }
        return new SumConstraint(new PropScalar(tmpV, tmpC, b, OPERATOR, RESULT));
    }
}

