/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.constraints.nary;

import org.chocosolver.solver.Priority;
import org.chocosolver.solver.constraints.Propagator;
import org.chocosolver.solver.constraints.PropagatorPriority;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.variables.IntVar;
import org.chocosolver.solver.variables.Variable;
import org.chocosolver.solver.variables.events.IntEventType;
import org.chocosolver.util.ESat;
import org.chocosolver.util.sort.ArraySort;
import org.chocosolver.util.tools.ArrayUtils;

public class PropKnapsack
extends Propagator<IntVar> {
    private final int[] weigth;
    private final int[] energy;
    private final int[] order;
    private final double[] ratio;
    private final int n;
    private final IntVar capacity;
    private final IntVar power;

    public PropKnapsack(IntVar[] itemOccurence, IntVar capacity, IntVar power, int[] weight, int[] energy) {
        super((Variable[])ArrayUtils.append(itemOccurence, {capacity, power}), (Priority)PropagatorPriority.LINEAR, false);
        this.weigth = weight;
        this.energy = energy;
        this.n = itemOccurence.length;
        this.capacity = ((IntVar[])this.vars)[this.n];
        this.power = ((IntVar[])this.vars)[this.n + 1];
        this.ratio = new double[this.n];
        for (int i = 0; i < this.n; ++i) {
            this.ratio[i] = weight[i] == 0 ? Double.MAX_VALUE : (double)energy[i] / (double)weight[i];
        }
        this.order = ArrayUtils.array(0, this.n - 1);
        ArraySort sorter = new ArraySort(this.n, false, true);
        sorter.sort(this.order, this.n, (i1, i2) -> Double.compare(this.ratio[i2], this.ratio[i1]));
    }

    @Override
    public int getPropagationConditions(int vIdx) {
        return IntEventType.boundAndInst();
    }

    @Override
    public void propagate(int evtmask) throws ContradictionException {
        int remainingCapacity = this.capacity.getUB();
        int maxPower = 0;
        for (int i = 0; i < this.n; ++i) {
            int lb = ((IntVar[])this.vars)[i].getLB();
            remainingCapacity -= this.weigth[i] * lb;
            maxPower += this.energy[i] * lb;
        }
        this.power.updateLowerBound(maxPower, this);
        if (remainingCapacity < 0) {
            this.power.updateUpperBound(this.power.getLB() - 1, this);
        } else {
            for (int i = 0; i < this.n; ++i) {
                assert (remainingCapacity >= 0);
                int idx = this.order[i];
                int range = ((IntVar[])this.vars)[idx].getUB() - ((IntVar[])this.vars)[idx].getLB();
                if (range <= 0) continue;
                int delta = this.weigth[idx] * range;
                if (delta <= remainingCapacity) {
                    maxPower += this.energy[idx] * range;
                    if (this.weigth[idx] <= 0 || (remainingCapacity -= delta) != 0) continue;
                    this.power.updateUpperBound(maxPower, this);
                    return;
                }
                int deltaPow = (int)Math.ceil((double)remainingCapacity * this.ratio[idx]);
                this.power.updateUpperBound(maxPower + deltaPow, this);
                return;
            }
        }
    }

    @Override
    public ESat isEntailed() {
        double camax = this.capacity.getUB();
        double pomin = 0.0;
        for (int i = 0; i < this.n; ++i) {
            camax -= (double)((long)this.weigth[i] * (long)((IntVar[])this.vars)[i].getLB());
            pomin += (double)((long)this.energy[i] * (long)((IntVar[])this.vars)[i].getLB());
        }
        if (camax < 0.0 || pomin > (double)this.power.getUB()) {
            return ESat.FALSE;
        }
        if (this.isCompletelyInstantiated() && pomin == (double)this.power.getValue()) {
            return ESat.TRUE;
        }
        return ESat.UNDEFINED;
    }
}

