/*
 * Decompiled with CFR 0.152.
 */
package choco;

import choco.kernel.common.logging.ChocoLogging;
import choco.kernel.model.ModelException;
import gnu.trove.TObjectIntHashMap;
import java.util.logging.Logger;

public class Options {
    private static final Logger LOGGER = ChocoLogging.getMainLogger();
    public static final String NO_OPTION = "";
    public static final String V_BOUND = "cp:bound";
    public static final String V_ENUM = "cp:enum";
    public static final String V_BTREE = "cp:btree";
    public static final String V_BLIST = "cp:blist";
    public static final String V_LINK = "cp:link";
    public static final String V_MAKESPAN = "cp:makespan";
    public static final String V_DECISION = "cp:decision";
    public static final String V_NO_DECISION = "cp:no_decision";
    public static final String V_OBJECTIVE = "cp:objective";
    public static final String E_DECOMP = "cp:decomp";
    public static final String E_AC = "cp:ac";
    public static final String E_FC = "cp:fc";
    public static final String C_EXT_AC3 = "cp:ac3";
    public static final String C_EXT_AC32 = "cp:ac32";
    public static final String C_EXT_AC322 = "cp:ac322";
    public static final String C_EXT_AC2001 = "cp:ac2001";
    public static final String C_EXT_AC2008 = "cp:ac2008";
    public static final String C_EXT_FC = "cp:fc";
    public static final String C_ALLDIFFERENT_AC = "cp:ac";
    public static final String C_ALLDIFFERENT_BC = "cp:bc";
    public static final String C_ALLDIFFERENT_CLIQUE = "cp:clique";
    public static final String C_GCC_AC = "cp:ac";
    public static final String C_GCC_BC = "cp:bc";
    public static final String C_INCREASING_NVALUE_ATLEAST = "cp:atleast";
    public static final String C_INCREASING_NVALUE_ATMOST = "cp:atmost";
    public static final String C_INCREASING_NVALUE_BOTH = "cp:both";
    public static final String C_NTH_G = "cp:G";
    public static final String C_CLAUSES_ENTAIL = "cp:entail";
    public static final String C_POST_PONED = "cp:postponed";
    public static final String C_DISJ_OC = "cp:disjunctive:overload_checking";
    public static final String C_DISJ_NFNL = "cp:disjunctive:not_first_not_last";
    public static final String C_DISJ_DP = "cp:disjunctive:detectable_precedence";
    public static final String C_DISJ_EF = "cp:disjunctive:edge_finding";
    public static final String C_DISJ_VF = "cp:disjunctive:vilim_filtering";
    public static final String C_CUMUL_TI = "cp:cumulative:task_intervals";
    public static final String C_CUMUL_STI = "cp:cumulative:slow_task_intervals";
    public static final String C_CUMUL_EF = "cp:cumulative:edge_finding";
    public static final String C_CUMUL_VEF = "cp:cumulative:edge_finding:vilim";
    public static final String C_PACK_AR = "cp:pack:additional_rules";
    public static final String C_PACK_DLB = "cp:pack:dynamic_lower_bound";
    public static final String C_PACK_FB = "cp:pack:fill_bins";
    public static final String C_PACK_LBE = "cp:pack:last_bins_empty";
    public static final String C_MINMAX_INF = "cp:min-max:inf";
    public static final String C_MINMAX_SUP = "cp:min-max:sup";
    public static final String C_NO_DETECTION = "ppcp:no_detection";
    protected static TObjectIntHashMap<String> categories = new TObjectIntHashMap(16);

    private Options() {
    }

    public static int getCategorie(String name) {
        if (!categories.contains(name)) {
            LOGGER.warning("No categorie defines for \"" + name + "\".\n See Options.create(String name, int categorie) for " + "more information.");
        }
        return categories.get(name);
    }

    public static void create(String name, int categorie) {
        if (categories.containsKey(name)) {
            int c = categories.get(name);
            if (categorie != c) {
                throw new ModelException("option " + name + " already exists and categorie is set to " + c);
            }
        } else {
            categories.put(name, categorie);
        }
    }

    static {
        categories.put(NO_OPTION, 0);
        categories.put(V_BLIST, 0);
        categories.put(V_BOUND, 0);
        categories.put(V_BTREE, 0);
        categories.put(V_ENUM, 0);
        categories.put(V_LINK, 0);
        categories.put(V_OBJECTIVE, 1);
        categories.put(V_NO_DECISION, 2);
        categories.put(V_MAKESPAN, 3);
        categories.put(E_DECOMP, 0);
        categories.put(C_EXT_AC2001, 0);
        categories.put(C_EXT_AC2008, 0);
        categories.put(C_EXT_AC3, 0);
        categories.put(C_EXT_AC32, 0);
        categories.put(C_EXT_AC322, 0);
        categories.put("cp:fc", 0);
        categories.put("cp:ac", 0);
        categories.put("cp:bc", 0);
        categories.put(C_ALLDIFFERENT_CLIQUE, 0);
        categories.put("cp:ac", 0);
        categories.put("cp:bc", 0);
        categories.put(C_INCREASING_NVALUE_ATLEAST, 0);
        categories.put(C_INCREASING_NVALUE_ATMOST, 0);
        categories.put(C_INCREASING_NVALUE_BOTH, 0);
        categories.put(C_NTH_G, 0);
        categories.put(C_CLAUSES_ENTAIL, 0);
        categories.put(C_POST_PONED, 1);
        categories.put(C_PACK_AR, 0);
        categories.put(C_PACK_DLB, 3);
        categories.put(C_PACK_FB, 4);
        categories.put(C_PACK_LBE, 5);
        categories.put(C_CUMUL_TI, 0);
        categories.put(C_CUMUL_STI, 0);
        categories.put(C_CUMUL_EF, 3);
        categories.put(C_CUMUL_VEF, 3);
        categories.put(C_DISJ_OC, 0);
        categories.put(C_DISJ_EF, 0);
        categories.put(C_DISJ_NFNL, 3);
        categories.put(C_DISJ_DP, 4);
        categories.put(C_DISJ_VF, 5);
        categories.put(C_MINMAX_INF, 0);
        categories.put(C_MINMAX_SUP, 0);
        categories.put(C_NO_DETECTION, 6);
    }
}

