/*
 * Decompiled with CFR 0.152.
 */
package moa.tasks;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import moa.core.ObjectRepository;
import moa.core.SerializeUtils;
import moa.options.FileOption;
import moa.tasks.AbstractTask;
import moa.tasks.TaskMonitor;

public abstract class MainTask
extends AbstractTask {
    private static final long serialVersionUID = 1L;
    protected static final int INSTANCES_BETWEEN_MONITOR_UPDATES = 10;
    public FileOption outputFileOption = new FileOption("taskResultFile", 'O', "File to save the final result of the task to.", null, "moa", true);

    protected Object doTaskImpl(TaskMonitor monitor, ObjectRepository repository) {
        Object result = this.doMainTask(monitor, repository);
        if (monitor.taskShouldAbort()) {
            return null;
        }
        File outputFile = this.outputFileOption.getFile();
        if (outputFile != null) {
            if (result instanceof Serializable) {
                monitor.setCurrentActivity("Saving result of task " + this.getTaskName() + " to file " + outputFile + "...", -1.0);
                try {
                    SerializeUtils.writeToFile(outputFile, (Serializable)result);
                }
                catch (IOException ioe) {
                    throw new RuntimeException("Failed writing result of task " + this.getTaskName() + " to file " + outputFile, ioe);
                }
            } else {
                throw new RuntimeException("Result of task " + this.getTaskName() + " is not serializable, so cannot be written to file " + outputFile);
            }
        }
        return result;
    }

    protected abstract Object doMainTask(TaskMonitor var1, ObjectRepository var2);
}

