/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jclec.base;

import java.util.ArrayList;
import java.util.List;
import net.sf.jclec.IConfigure;
import net.sf.jclec.IIndividual;
import net.sf.jclec.IMutator;
import net.sf.jclec.ISystem;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.lang.builder.EqualsBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultiMutator<I extends IIndividual>
implements IMutator<I>,
IConfigure {
    private static final long serialVersionUID = -6300502786816813015L;
    protected IMutator<I>[] components;
    protected transient ISystem<I> context;

    public MultiMutator() {
    }

    public MultiMutator(ISystem<I> context) {
        this.contextualize(context);
    }

    public final IMutator<I>[] getComponents() {
        return this.components;
    }

    public final void setComponents(IMutator<I>[] components) {
        this.components = components;
        if (this.context != null) {
            IMutator<I>[] iMutatorArray = components;
            int n = 0;
            int n2 = iMutatorArray.length;
            while (n < n2) {
                IMutator<I> component = iMutatorArray[n];
                component.contextualize(this.context);
                ++n;
            }
        }
    }

    @Override
    public void contextualize(ISystem<I> context) {
        this.context = context;
        if (this.components != null) {
            IMutator<I>[] iMutatorArray = this.components;
            int n = 0;
            int n2 = iMutatorArray.length;
            while (n < n2) {
                IMutator<I> component = iMutatorArray[n];
                component.contextualize(context);
                ++n;
            }
        }
    }

    @Override
    public List<I> mutate(List<I> parents) {
        ArrayList result = new ArrayList();
        IMutator<I>[] iMutatorArray = this.components;
        int n = 0;
        int n2 = iMutatorArray.length;
        while (n < n2) {
            IMutator<I> component = iMutatorArray[n];
            result.addAll(component.mutate(parents));
            ++n;
        }
        return result;
    }

    @Override
    public void configure(Configuration settings) {
        int numberOfComponents = settings.getList("component[@type]").size();
        IMutator[] components = new IMutator[numberOfComponents];
        int i = 0;
        while (i < numberOfComponents) {
            String header = "component(" + i + ")";
            try {
                String componentClassname = settings.getString(String.valueOf(header) + "[@type");
                Class<?> componentClass = Class.forName(componentClassname);
                IMutator component = (IMutator)componentClass.newInstance();
                if (component instanceof IConfigure) {
                    ((IConfigure)((Object)component)).configure(settings.subset(header));
                }
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
            catch (InstantiationException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            ++i;
        }
        this.setComponents(components);
    }

    public boolean equals(Object other) {
        if (other instanceof MultiMutator) {
            MultiMutator o = (MultiMutator)other;
            int cl = this.components.length;
            if (cl == o.components.length) {
                EqualsBuilder eb = new EqualsBuilder();
                int i = 0;
                while (i < cl) {
                    eb.append(this.components[i], o.components[i]);
                    ++i;
                }
                return eb.isEquals();
            }
            return false;
        }
        return false;
    }
}

