/*
 * Decompiled with CFR 0.152.
 */
package keel.Algorithms.Associative_Classification.ClassifierCMAR;

import keel.Algorithms.Associative_Classification.ClassifierCMAR.DataBase;
import keel.Algorithms.Associative_Classification.ClassifierCMAR.PartialSupportTree;
import keel.Algorithms.Associative_Classification.ClassifierCMAR.myDataset;

public class AprioriTFPclass
extends PartialSupportTree {
    protected short[][] testDataArray = null;
    protected short[][][] tenthDataSets = new short[10][][];
    protected int numRowsInInputSet;
    protected int numRowsInTestSet;
    protected int numRowsInTrainingSet;
    protected double accuracy;
    protected double averageAccuracy;
    protected double averageNumFreqSets;
    protected double averageNumUpdates;
    protected double averageNumCRs;

    public AprioriTFPclass(double minConf, double minSup, int delta) {
        super(minConf, minSup, delta);
    }

    public void setSupportAndConfidence(double newSupport, double newConfidence) {
        this.support = newSupport;
        this.confidence = newConfidence;
    }

    @Override
    public void idInputDataOrdering(DataBase dataBase) {
        int[][] countArray = this.countSingles(dataBase);
        this.orderFirstNofCountArray(countArray, this.numCols - this.numClasses);
        this.defConvertArrays(countArray);
        this.currentRlist.setReconversionArrayRefs(this.conversionArray, this.reconversionArray);
    }

    public void pruneUnsupportedAtts() {
        for (int rowIndex = 0; rowIndex < this.dataArray.length; ++rowIndex) {
            if (this.dataArray[rowIndex] == null) continue;
            short[] itemSet = null;
            int maxLength = this.dataArray[rowIndex].length - 1;
            for (int colIndex = 0; colIndex < maxLength; ++colIndex) {
                short attribute = this.dataArray[rowIndex][colIndex];
                if (!((double)this.conversionArray[attribute][1] >= this.minSupport)) continue;
                itemSet = this.reallocInsert(itemSet, (short)this.conversionArray[attribute][0]);
            }
            itemSet = this.reallocInsert(itemSet, this.dataArray[rowIndex][maxLength]);
            this.dataArray[rowIndex] = itemSet;
        }
        this.recastClassifiers();
        this.numOneItemSets = this.getNumSupOneItemSets();
    }

    private void recastClassifiers() {
        short difference = (short)(this.numCols - this.getNumSupOneItemSets());
        for (int rowIndex = 0; rowIndex < this.dataArray.length; ++rowIndex) {
            int lastIndex = this.dataArray[rowIndex].length - 1;
            this.dataArray[rowIndex][lastIndex] = (short)(this.dataArray[rowIndex][lastIndex] - difference);
        }
    }

    @Override
    protected int getNumSupOneItemSets() {
        int counter = 0;
        int length = this.conversionArray.length - this.numClasses;
        for (int index = 1; index < length; ++index) {
            if (!((double)this.conversionArray[index][1] >= this.minSupport)) continue;
            ++counter;
        }
        return counter + this.numClasses;
    }

    public void testDataSet(myDataset test, DataBase dataBase) {
        this.setNumRowsInTrainingSet();
        this.numRowsInTestSet = test.getnData();
        this.testDataArray = new short[this.numRowsInTestSet][];
        for (int i = 0; i < this.numRowsInTestSet; ++i) {
            int[] example = test.getExample(i);
            this.testDataArray[i] = new short[dataBase.numVariablesUsed() + 1];
            short value = 1;
            int k = 0;
            for (int j = 0; j < example.length; ++j) {
                if (dataBase.numLabels(j) <= 1) continue;
                this.testDataArray[i][k] = (short)example[j];
                short[] sArray = this.testDataArray[i];
                int n = k++;
                sArray[n] = (short)(sArray[n] + value);
                value = (short)(value + dataBase.numLabels(j));
            }
            this.testDataArray[i][k] = (short)test.getOutputAsInteger(i);
            short[] sArray = this.testDataArray[i];
            int n = k;
            sArray[n] = (short)(sArray[n] + value);
        }
    }

    public void createTrainingAndTestDataSets() {
        int index1;
        double PERCENTAGE_SIZE_OF_TEST_SET = 50.0;
        this.numRowsInTestSet = (int)((double)this.numRows * 50.0 / 100.0);
        this.numRows = this.numRowsInTrainingSet = this.numRows - this.numRowsInTestSet;
        short[][] trainingSet = new short[this.numRowsInTrainingSet][];
        for (index1 = 0; index1 < this.numRowsInTrainingSet; ++index1) {
            trainingSet[index1] = this.dataArray[index1];
        }
        this.testDataArray = new short[this.numRowsInTestSet][];
        int index2 = 0;
        while (index1 < this.dataArray.length) {
            this.testDataArray[index2] = this.dataArray[index1];
            ++index1;
            ++index2;
        }
        this.dataArray = trainingSet;
    }

    public void createTrainingAndTestDataSets(int testSetIndex) {
        int tenthsIndex;
        int index;
        this.numRowsInTestSet = this.tenthDataSets[testSetIndex].length;
        this.testDataArray = this.tenthDataSets[testSetIndex];
        this.numRows = this.numRowsInTrainingSet = this.numRowsInInputSet - this.numRowsInTestSet;
        short[][] trainingSet = new short[this.numRows][];
        int trainingSetIndex = 0;
        for (index = 0; index < testSetIndex; ++index) {
            tenthsIndex = 0;
            while (tenthsIndex < this.tenthDataSets[index].length) {
                trainingSet[trainingSetIndex] = this.tenthDataSets[index][tenthsIndex];
                ++tenthsIndex;
                ++trainingSetIndex;
            }
        }
        for (index = testSetIndex + 1; index < this.tenthDataSets.length; ++index) {
            tenthsIndex = 0;
            while (tenthsIndex < this.tenthDataSets[index].length) {
                trainingSet[trainingSetIndex] = this.tenthDataSets[index][tenthsIndex];
                ++tenthsIndex;
                ++trainingSetIndex;
            }
        }
        this.dataArray = trainingSet;
    }

    public void createTenthsDataSets() {
        int index;
        if (this.numRows < 10) {
            System.out.println("ERROR: only " + this.numRows + ", therefore cannot create tenths data sets!");
            System.exit(1);
        }
        int tenthSize = this.numRows / 10;
        for (index = 0; index < this.tenthDataSets.length - 1; ++index) {
            this.tenthDataSets[index] = new short[tenthSize][];
        }
        this.tenthDataSets[index] = new short[this.numRows - tenthSize * 9][];
        int inputDataIndex = 0;
        for (index = 0; index < this.tenthDataSets.length; ++index) {
            int tenthIndex = 0;
            while (tenthIndex < this.tenthDataSets[index].length) {
                this.tenthDataSets[index][tenthIndex] = this.dataArray[inputDataIndex];
                ++tenthIndex;
                ++inputDataIndex;
            }
        }
    }

    public void reconstructInputData() {
        int index;
        short[][] newDataArray = new short[this.dataArray.length + this.testDataArray.length][];
        int newIndex = 0;
        for (index = 0; index < this.dataArray.length; ++index) {
            newDataArray[newIndex] = this.dataArray[index];
            ++newIndex;
        }
        for (index = 0; index < this.testDataArray.length; ++index) {
            newDataArray[newIndex] = this.testDataArray[index];
            ++newIndex;
        }
        this.dataArray = newDataArray;
    }

    public void setNumRowsInInputSet() {
        this.numRowsInInputSet = this.numRows;
    }

    public void setNumRowsInTrainingSet() {
        this.numRowsInTrainingSet = this.numRows;
    }

    public double getAverageAccuracy() {
        return this.averageAccuracy;
    }

    public double getAccuracy() {
        return this.accuracy;
    }

    public double getAverageNumFreqSets() {
        return this.averageNumFreqSets;
    }

    public double getAvergaeNumUpdates() {
        return this.averageNumUpdates;
    }

    public double getAverageNumCRs() {
        return this.averageNumCRs;
    }

    @Override
    protected void outputMenu() {
        System.out.println();
        System.out.println("-A  = Number of attribute");
        System.out.println("-C  = Confidence (default 80%)");
        System.out.println("-F  = File name");
        System.out.println("-R  = Number of records");
        System.out.println("-S  = Support (default 20%)");
        System.out.println("-N  = Number of classes");
        System.out.println();
        System.exit(1);
    }

    @Override
    protected void outputSettings() {
        System.out.println("SETTINGS\n--------");
        System.out.println("File name                     = " + this.fileName);
        System.out.println("Support (default 20%)         = " + this.support);
        System.out.println("Confidence (default 80%)      = " + this.confidence);
        System.out.println("Number of classes             = " + this.numClasses);
        System.out.println();
    }

    public void outputNumClasses() {
        System.out.println("Number of classes = " + this.numClasses);
    }

    public void outputAccuracy() {
        System.out.println("Accuracy = " + this.twoDecPlaces(this.accuracy));
    }

    public void outputTestDataArray() {
        for (int index = 0; index < this.testDataArray.length; ++index) {
            this.outputItemSet(this.testDataArray[index]);
            System.out.println();
        }
    }
}

