/*
 * Decompiled with CFR 0.152.
 */
package keel.Algorithms.Fuzzy_Rule_Learning.Genetic.Shared.Model;

import keel.Algorithms.Fuzzy_Rule_Learning.Genetic.Shared.Genotypes.GenotypeFuzzyGPRegSym;
import keel.Algorithms.Fuzzy_Rule_Learning.Genetic.Shared.Individual.GeneticIndividual;
import keel.Algorithms.Fuzzy_Rule_Learning.Genetic.Shared.Individual.GeneticIndividualForSymbRegr;
import keel.Algorithms.Fuzzy_Rule_Learning.Genetic.Shared.Model.FuzzyGPRegSymModel;
import keel.Algorithms.Fuzzy_Rule_Learning.Genetic.Shared.Node.NodeExprHold;
import keel.Algorithms.Fuzzy_Rule_Learning.Genetic.Shared.OptimLocal.Ameba;
import keel.Algorithms.Fuzzy_Rule_Learning.Genetic.Shared.OptimLocal.FUNGPRS;
import keel.Algorithms.Shared.Exceptions.invalidCrossover;
import keel.Algorithms.Shared.Exceptions.invalidMutation;
import keel.Algorithms.Shared.Exceptions.invalidOptim;
import org.core.Randomize;

public class RegSymFuzzyGP
extends GeneticIndividualForSymbRegr {
    static double KMIN;
    static double KMAX;
    static int constType;

    public RegSymFuzzyGP(double kmin, double kmax, int ne, int typectes, int NCTES, int MAXH, int tf, Randomize r) {
        super(tf);
        KMIN = kmin;
        KMAX = kmax;
        GenotypeFuzzyGPRegSym gf = new GenotypeFuzzyGPRegSym(kmin, kmax, ne, typectes, NCTES, MAXH, r);
        this.g = gf;
        constType = typectes;
        this.m = new FuzzyGPRegSymModel((NodeExprHold)gf.getRootNode(), kmin, kmax, 1, typectes);
    }

    public RegSymFuzzyGP(RegSymFuzzyGP p) {
        super(p.fitnessType);
        this.g = p.g.clone();
        GenotypeFuzzyGPRegSym gf = (GenotypeFuzzyGPRegSym)this.g;
        this.m = new FuzzyGPRegSymModel((NodeExprHold)gf.getRootNode(), KMIN, KMAX, 1, constType);
    }

    @Override
    public GeneticIndividual clone() {
        return new RegSymFuzzyGP(this);
    }

    public void set(RegSymFuzzyGP p) {
        this.g = p.g.clone();
        GenotypeFuzzyGPRegSym gf = (GenotypeFuzzyGPRegSym)this.g;
        this.m = new FuzzyGPRegSymModel((NodeExprHold)gf.getRootNode(), KMIN, KMAX, 1, constType);
    }

    public GeneticIndividual FuzzyGPRegresionSimbolicaClona() {
        return new RegSymFuzzyGP(this);
    }

    @Override
    public void parametersFromGenotype() {
        GenotypeFuzzyGPRegSym gf = (GenotypeFuzzyGPRegSym)this.g;
        this.m = new FuzzyGPRegSymModel((NodeExprHold)gf.getRootNode(), KMAX, KMIN, 1, constType);
    }

    @Override
    public void Random() {
        this.g.Random();
        this.parametersFromGenotype();
    }

    @Override
    public void mutation(double alpha, int IDMUTA) throws invalidMutation {
        this.g.mutation(alpha, IDMUTA);
        this.parametersFromGenotype();
    }

    @Override
    public void crossover(GeneticIndividual p2, GeneticIndividual p3, GeneticIndividual p4, int IDCRUCE) throws invalidCrossover {
        RegSymFuzzyGP f2 = (RegSymFuzzyGP)p2;
        RegSymFuzzyGP f3 = (RegSymFuzzyGP)p3;
        RegSymFuzzyGP f4 = (RegSymFuzzyGP)p4;
        this.g.crossover(f2.g, f3.g, f4.g, IDCRUCE);
        f3.parametersFromGenotype();
        f4.parametersFromGenotype();
    }

    @Override
    public void debug() {
        this.g.debug();
    }

    public void setConsts(double[] ctes) {
        GenotypeFuzzyGPRegSym gf = (GenotypeFuzzyGPRegSym)this.g;
        gf.setChain(ctes);
    }

    public double[] getConsts() {
        GenotypeFuzzyGPRegSym gf = (GenotypeFuzzyGPRegSym)this.g;
        return gf.getChainValue();
    }

    public boolean[] getUsedConsts() {
        GenotypeFuzzyGPRegSym gf = (GenotypeFuzzyGPRegSym)this.g;
        return gf.getUsedConstants();
    }

    @Override
    public void localOptimization(int MAXITER, int idoptimization) throws invalidOptim {
        if (idoptimization != 2001) {
            throw new invalidOptim("Optimizacion local no implementada en RegSymFuzzyGP");
        }
        double[] consts = this.getConsts();
        int total = 0;
        boolean[] usedctes = this.getUsedConsts();
        for (int i = 0; i < usedctes.length; ++i) {
            if (!usedctes[i]) continue;
            ++total;
        }
        if (total == 0) {
            return;
        }
        FUNGPRS f = new FUNGPRS(this, usedctes, consts);
        Ameba ameba = new Ameba();
        ameba.itera(f, consts, MAXITER * total);
        this.setConsts(consts);
    }
}

