/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.vocabulary;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.ResourceFactory;
import com.hp.hpl.jena.shared.ReificationStyle;
import com.hp.hpl.jena.util.FileManager;

public class JenaModelSpec {
    public static final String baseURI = "http://jena.hpl.hp.com/2003/08/jms#";
    public static final Property loadWith = JenaModelSpec.property("loadWith");
    public static final Property ontLanguage = JenaModelSpec.property("ontLanguage");
    public static final Property docManager = JenaModelSpec.property("docManager");
    public static final Property hasConnection = JenaModelSpec.property("hasConnection");
    public static final Property importMaker = JenaModelSpec.property("importMaker");
    public static final Property reasonsWith = JenaModelSpec.property("reasonsWith");
    public static final Property ruleSetURL = JenaModelSpec.property("ruleSetURL");
    public static final Property ruleSet = JenaModelSpec.property("ruleSet");
    public static final Property modelName = JenaModelSpec.property("modelName");
    public static final Property schemaURL = JenaModelSpec.property("schemaURL");
    public static final Property hasRule = JenaModelSpec.property("hasRule");
    public static final Property policyPath = JenaModelSpec.property("policyPath");
    public static final Property dbUser = JenaModelSpec.property("dbUser");
    public static final Property dbPassword = JenaModelSpec.property("dbPassword");
    public static final Property dbURL = JenaModelSpec.property("dbURL");
    public static final Property dbType = JenaModelSpec.property("dbType");
    public static final Property dbClass = JenaModelSpec.property("dbClass");
    public static final Property maker = JenaModelSpec.property("maker");
    public static final Property reificationMode = JenaModelSpec.property("reificationMode");
    public static final Property reasoner = JenaModelSpec.property("reasoner");
    public static final Property fileBase = JenaModelSpec.property("fileBase");
    public static final Property typeCreatedBy = JenaModelSpec.property("typeCreatedBy");
    public static final Resource MakerSpec = JenaModelSpec.resource("MakerSpec");
    public static final Resource FileMakerSpec = JenaModelSpec.resource("FileMakerSpec");
    public static final Resource MemMakerSpec = JenaModelSpec.resource("MemMakerSpec");
    public static final Resource RDBMakerSpec = JenaModelSpec.resource("RDBMakerSpec");
    public static final Resource ModelSpec = JenaModelSpec.resource("ModelSpec");
    public static final Resource DefaultModelSpec = JenaModelSpec.resource("DefaultModelSpec");
    public static final Resource PlainModelSpec = JenaModelSpec.resource("PlainModelSpec");
    public static final Resource FileModelSpec = JenaModelSpec.resource("FileModelSpec");
    public static final Resource InfModelSpec = JenaModelSpec.resource("InfModelSpec");
    public static final Resource OntModelSpec = JenaModelSpec.resource("OntModelSpec");
    public static final Resource RDBModelSpec = JenaModelSpec.resource("RDBModelSpec");
    public static final Resource rsStandard = JenaModelSpec.resource("rsStandard");
    public static final Resource rsMinimal = JenaModelSpec.resource("rsMinimal");
    public static final Resource rsConvenient = JenaModelSpec.resource("rsConvenient");
    protected static Model schema = null;

    public static String getURI() {
        return baseURI;
    }

    public static Model getSchema() {
        if (schema == null) {
            schema = ModelFactory.createRDFSModel(FileManager.get().loadModel("vocabularies/jena-model-spec.n3"));
        }
        return schema;
    }

    protected static Resource resource(String ln) {
        return ResourceFactory.createResource(baseURI + ln);
    }

    protected static Property property(String ln) {
        return ResourceFactory.createProperty(baseURI + ln);
    }

    public static Node styleAsJMS(ReificationStyle style) {
        if (style == ReificationStyle.Minimal) {
            return rsMinimal.asNode();
        }
        if (style == ReificationStyle.Convenient) {
            return rsConvenient.asNode();
        }
        if (style == ReificationStyle.Standard) {
            return rsStandard.asNode();
        }
        return null;
    }

    public static ReificationStyle findStyle(RDFNode style) {
        return JenaModelSpec.findStyle(style.asNode());
    }

    public static ReificationStyle findStyle(Node style) {
        if (style.equals(rsStandard.asNode())) {
            return ReificationStyle.Standard;
        }
        if (style.equals(rsMinimal.asNode())) {
            return ReificationStyle.Minimal;
        }
        if (style.equals(rsConvenient.asNode())) {
            return ReificationStyle.Convenient;
        }
        return null;
    }
}

