/*
 * Decompiled with CFR 0.152.
 */
package weka.filters.unsupervised.attribute;

import java.util.Enumeration;
import java.util.Vector;
import weka.core.Attribute;
import weka.core.Capabilities;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.OptionHandler;
import weka.core.Range;
import weka.core.SparseInstance;
import weka.core.Utils;
import weka.filters.Filter;
import weka.filters.StreamableFilter;
import weka.filters.UnsupervisedFilter;

public class Copy
extends Filter
implements UnsupervisedFilter,
StreamableFilter,
OptionHandler {
    static final long serialVersionUID = -8543707493627441566L;
    protected Range m_CopyCols = new Range();
    protected int[] m_SelectedAttributes;

    public Enumeration listOptions() {
        Vector<Option> vector = new Vector<Option>(2);
        vector.addElement(new Option("\tSpecify list of columns to copy. First and last are valid\n\tindexes. (default none)", "R", 1, "-R <index1,index2-index4,...>"));
        vector.addElement(new Option("\tInvert matching sense (i.e. copy all non-specified columns)", "V", 0, "-V"));
        return vector.elements();
    }

    public void setOptions(String[] stringArray) throws Exception {
        String string = Utils.getOption('R', stringArray);
        if (string.length() != 0) {
            this.setAttributeIndices(string);
        }
        this.setInvertSelection(Utils.getFlag('V', stringArray));
        if (this.getInputFormat() != null) {
            this.setInputFormat(this.getInputFormat());
        }
    }

    public String[] getOptions() {
        String[] stringArray = new String[3];
        int n = 0;
        if (this.getInvertSelection()) {
            stringArray[n++] = "-V";
        }
        if (!this.getAttributeIndices().equals("")) {
            stringArray[n++] = "-R";
            stringArray[n++] = this.getAttributeIndices();
        }
        while (n < stringArray.length) {
            stringArray[n++] = "";
        }
        return stringArray;
    }

    public Capabilities getCapabilities() {
        Capabilities capabilities = super.getCapabilities();
        capabilities.enableAllAttributes();
        capabilities.enable(Capabilities.Capability.MISSING_VALUES);
        capabilities.enableAllClasses();
        capabilities.enable(Capabilities.Capability.MISSING_CLASS_VALUES);
        capabilities.enable(Capabilities.Capability.NO_CLASS);
        return capabilities;
    }

    public boolean setInputFormat(Instances instances) throws Exception {
        int n;
        super.setInputFormat(instances);
        this.m_CopyCols.setUpper(instances.numAttributes() - 1);
        Instances instances2 = new Instances(instances, 0);
        this.m_SelectedAttributes = this.m_CopyCols.getSelection();
        for (int i = 0; i < this.m_SelectedAttributes.length; ++i) {
            n = this.m_SelectedAttributes[i];
            Attribute attribute = instances.attribute(n);
            instances2.insertAttributeAt((Attribute)attribute.copy(), instances2.numAttributes());
            instances2.renameAttribute(instances2.numAttributes() - 1, "Copy of " + attribute.name());
        }
        int[] nArray = new int[instances.numAttributes() + this.m_SelectedAttributes.length];
        for (n = 0; n < instances.numAttributes(); ++n) {
            nArray[n] = n;
        }
        for (n = 0; n < this.m_SelectedAttributes.length; ++n) {
            nArray[instances.numAttributes() + n] = this.m_SelectedAttributes[n];
        }
        this.initInputLocators(instances, nArray);
        this.setOutputFormat(instances2);
        return true;
    }

    public boolean input(Instance instance) {
        int n;
        if (this.getInputFormat() == null) {
            throw new IllegalStateException("No input instance format defined");
        }
        if (this.m_NewBatch) {
            this.resetQueue();
            this.m_NewBatch = false;
        }
        double[] dArray = new double[this.outputFormatPeek().numAttributes()];
        for (n = 0; n < this.getInputFormat().numAttributes(); ++n) {
            dArray[n] = instance.value(n);
        }
        n = this.getInputFormat().numAttributes();
        for (int i = 0; i < this.m_SelectedAttributes.length; ++i) {
            int n2 = this.m_SelectedAttributes[i];
            dArray[i + n] = instance.value(n2);
        }
        Instance instance2 = null;
        instance2 = instance instanceof SparseInstance ? new SparseInstance(instance.weight(), dArray) : new Instance(instance.weight(), dArray);
        instance2.setDataset(this.getOutputFormat());
        this.copyValues(instance2, false, instance.dataset(), this.getOutputFormat());
        instance2.setDataset(this.getOutputFormat());
        this.push(instance2);
        return true;
    }

    public String globalInfo() {
        return "An instance filter that copies a range of attributes in the dataset. This is used in conjunction with other filters that overwrite attribute values during the course of their operation -- this filter allows the original attributes to be kept as well as the new attributes.";
    }

    public String invertSelectionTipText() {
        return "Sets copy selected vs unselected action. If set to false, only the specified attributes will be copied; If set to true, non-specified attributes will be copied.";
    }

    public boolean getInvertSelection() {
        return this.m_CopyCols.getInvert();
    }

    public void setInvertSelection(boolean bl) {
        this.m_CopyCols.setInvert(bl);
    }

    public String getAttributeIndices() {
        return this.m_CopyCols.getRanges();
    }

    public String attributeIndicesTipText() {
        return "Specify range of attributes to act on. This is a comma separated list of attribute indices, with \"first\" and \"last\" valid values. Specify an inclusive range with \"-\". E.g: \"first-3,5,6-10,last\".";
    }

    public void setAttributeIndices(String string) throws Exception {
        this.m_CopyCols.setRanges(string);
    }

    public void setAttributeIndicesArray(int[] nArray) throws Exception {
        this.setAttributeIndices(Range.indicesToRangeList(nArray));
    }

    public static void main(String[] stringArray) {
        Copy.runFilter(new Copy(), stringArray);
    }
}

