/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.ssf.extended;

import ec.tstoolkit.data.DataBlock;
import ec.tstoolkit.data.DataBlockIterator;
import ec.tstoolkit.data.SubArrayOfInt;
import ec.tstoolkit.maths.matrices.SubMatrix;
import ec.tstoolkit.ssf.ISsf;

public class LinearizedLogSsf<S extends ISsf>
implements ISsf {
    private S m_ssf;
    private double[] m_e;

    public LinearizedLogSsf(S ssf, double[] e0) {
        this.m_ssf = ssf;
        this.m_e = (double[])e0.clone();
    }

    @Override
    public void diffuseConstraints(SubMatrix b) {
        this.m_ssf.diffuseConstraints(b);
    }

    @Override
    public void fullQ(int pos, SubMatrix qm) {
        this.m_ssf.fullQ(pos, qm);
    }

    public DataBlock getE() {
        return new DataBlock(this.m_e);
    }

    @Override
    public int getNonStationaryDim() {
        return this.m_ssf.getNonStationaryDim();
    }

    public S getSsf() {
        return this.m_ssf;
    }

    @Override
    public int getStateDim() {
        return this.m_ssf.getStateDim();
    }

    @Override
    public int getTransitionResCount() {
        return this.m_ssf.getTransitionResCount();
    }

    @Override
    public int getTransitionResDim() {
        return this.m_ssf.getTransitionResDim();
    }

    @Override
    public boolean hasR() {
        return this.m_ssf.hasR();
    }

    @Override
    public boolean hasTransitionRes(int pos) {
        return this.m_ssf.hasTransitionRes(pos);
    }

    @Override
    public boolean hasW() {
        return this.m_ssf.hasW();
    }

    @Override
    public boolean isDiffuse() {
        return this.m_ssf.isDiffuse();
    }

    @Override
    public boolean isMeasurementEquationTimeInvariant() {
        return false;
    }

    @Override
    public boolean isTimeInvariant() {
        return false;
    }

    @Override
    public boolean isTransitionEquationTimeInvariant() {
        return this.m_ssf.isTransitionEquationTimeInvariant();
    }

    @Override
    public boolean isTransitionResidualTimeInvariant() {
        return this.m_ssf.isTransitionResidualTimeInvariant();
    }

    @Override
    public boolean isValid() {
        return this.m_e != null && this.m_ssf.isValid();
    }

    @Override
    public void L(int pos, DataBlock k, SubMatrix lm) {
        this.m_ssf.T(pos, lm);
        double e = this.m_e[pos];
        DataBlockIterator rows = lm.rows();
        DataBlock row = rows.getData();
        do {
            this.m_ssf.XpZd(pos, row, k.get(rows.getPosition()) * e);
        } while (rows.next());
    }

    @Override
    public void Pf0(SubMatrix pf0) {
        this.m_ssf.Pf0(pf0);
    }

    @Override
    public void Pi0(SubMatrix pf0) {
        this.m_ssf.Pi0(pf0);
    }

    @Override
    public void Q(int pos, SubMatrix qm) {
        this.m_ssf.Q(pos, qm);
    }

    @Override
    public void R(int pos, SubArrayOfInt rv) {
        this.m_ssf.R(pos, rv);
    }

    @Override
    public void T(int pos, SubMatrix tr) {
        this.m_ssf.T(pos, tr);
    }

    @Override
    public void TVT(int pos, SubMatrix vm) {
        this.m_ssf.TVT(pos, vm);
    }

    @Override
    public void TX(int pos, DataBlock x) {
        this.m_ssf.TX(pos, x);
    }

    @Override
    public void VpZdZ(int pos, SubMatrix vm, double d) {
        this.m_ssf.VpZdZ(pos, vm, d * this.m_e[pos] * this.m_e[pos]);
    }

    @Override
    public void W(int pos, SubMatrix wv) {
        this.m_ssf.W(pos, wv);
    }

    @Override
    public void XpZd(int pos, DataBlock x, double d) {
        this.m_ssf.XpZd(pos, x, d * this.m_e[pos]);
    }

    @Override
    public void XT(int pos, DataBlock x) {
        this.m_ssf.XT(pos, x);
    }

    @Override
    public void Z(int pos, DataBlock x) {
        this.m_ssf.Z(pos, x);
        x.mul(this.m_e[pos]);
    }

    @Override
    public void ZM(int pos, SubMatrix m, DataBlock x) {
        this.m_ssf.ZM(pos, m, x);
        x.mul(this.m_e[pos]);
    }

    @Override
    public double ZVZ(int pos, SubMatrix vm) {
        return this.m_ssf.ZVZ(pos, vm) * this.m_e[pos] * this.m_e[pos];
    }

    @Override
    public double ZX(int pos, DataBlock x) {
        return this.m_e[pos] * this.m_ssf.ZX(pos, x);
    }
}

