/*
 * Decompiled with CFR 0.152.
 */
package org.rosuda.JGR.browser;

import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.SwingUtilities;
import org.rosuda.JGR.JGR;
import org.rosuda.JGR.JGRDataFileSaveDialog;
import org.rosuda.JGR.RController;
import org.rosuda.JGR.browser.BrowserNode;
import org.rosuda.JGR.browser.DefaultBrowserNode;
import org.rosuda.JGR.robjects.RObject;
import org.rosuda.JGR.toolkit.DataTable;
import org.rosuda.JGR.toolkit.JGRPrefs;
import org.rosuda.ibase.SVarSet;

public class DataFrameNode
extends DefaultBrowserNode {
    public DataFrameNode() {
    }

    public DataFrameNode(BrowserNode parent, String rName, String rClass) {
        super(parent, rName, rClass);
    }

    @Override
    public BrowserNode generate(BrowserNode parent, String rName, String rClass) {
        return new DataFrameNode(parent, rName, rClass);
    }

    @Override
    public JPopupMenu getPopupMenu() {
        JPopupMenu menu = new JPopupMenu();
        final DataFrameNode pThis = this;
        DefaultBrowserNode.PopupListener lis = new DefaultBrowserNode.PopupListener(){

            @Override
            public void runCmd(String cmd) {
                super.runCmd(cmd);
                if (cmd.equals("Save")) {
                    new JGRDataFileSaveDialog(null, pThis.getRName(), JGRPrefs.workingDirectory);
                }
            }
        };
        JMenuItem item = new JMenuItem("Edit");
        item.addActionListener(lis);
        menu.add(item);
        item = new JMenuItem("Save");
        item.addActionListener(lis);
        menu.add(item);
        menu.add(new JSeparator());
        item = new JMenuItem("Print");
        item.addActionListener(lis);
        menu.add(item);
        item = new JMenuItem("Summary");
        item.addActionListener(lis);
        menu.add(item);
        item = new JMenuItem("Plot");
        item.addActionListener(lis);
        menu.add(item);
        menu.add(new JSeparator());
        item = new JMenuItem("Remove");
        item.addActionListener(lis);
        menu.add(item);
        return menu;
    }

    @Override
    public void editObject() {
        new Thread(new Runnable(){

            @Override
            public void run() {
                final RObject o = new RObject(DataFrameNode.this.getExecuteableRObjectName(), DataFrameNode.this.cls, true);
                final SVarSet vs = RController.newSet(o);
                if (vs != null && vs.count() != 0) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            new DataTable(vs, o.getType(), o.isEditable());
                        }
                    });
                }
            }
        }).start();
    }

    @Override
    public void plotObject() {
        JGR.MAINRCONSOLE.execute("plot(" + this.getExecuteableRObjectName() + ")");
    }
}

