/*
 * Decompiled with CFR 0.152.
 */
package org.rosuda.deducer.toolkit;

import java.util.Collection;
import java.util.Vector;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XMLHelper {
    public static Vector getChildrenElementsByTag(Node node, String string) {
        Vector<Node> vector = new Vector<Node>();
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            if (!(nodeList.item(i) instanceof Element) || !((Element)nodeList.item(i)).getTagName().equals(string) && string != null) continue;
            vector.add(nodeList.item(i));
        }
        return vector;
    }

    public static void debugPrintChildren(Node node) {
        NodeList nodeList = node.getChildNodes();
        System.out.println("-------------------");
        for (int i = 0; i < nodeList.getLength(); ++i) {
            System.out.println(nodeList.item(i).toString());
            if (nodeList.item(i) instanceof Element) {
                System.out.println(((Element)nodeList.item(i)).getAttribute("className"));
                System.out.println(((Element)nodeList.item(i)).getTagName());
            }
            System.out.println("---");
        }
    }

    public static void appendCollection(Node node, Collection collection, String string) {
        XMLHelper.appendCollection(node, collection.toArray(), string);
    }

    public static void appendCollection(Node node, Object[] objectArray, String string) {
        Element element = node.getOwnerDocument().createElement(string);
        for (int i = 0; i < objectArray.length; ++i) {
            element.setAttribute("element_" + i, (String)objectArray[i]);
        }
        node.appendChild(element);
    }

    public static String[] getChildCollection(Node node, String string) {
        Vector vector = XMLHelper.getChildrenElementsByTag(node, string);
        if (vector.size() == 0) {
            return null;
        }
        Element element = (Element)vector.get(0);
        NamedNodeMap namedNodeMap = element.getAttributes();
        if (namedNodeMap.getLength() > 0) {
            String[] stringArray = new String[namedNodeMap.getLength()];
            for (int i = 0; i < namedNodeMap.getLength(); ++i) {
                stringArray[i] = namedNodeMap.item(i).getNodeValue();
            }
            return stringArray;
        }
        return new String[0];
    }
}

