/*
 * Decompiled with CFR 0.152.
 */
package dr.evolution.wrightfisher;

import dr.evolution.wrightfisher.FitnessFunction;
import dr.math.MathUtils;
import dr.math.distributions.GammaDistribution;

public class GammaInvFitnessFunction
extends FitnessFunction {
    double[][] fitness;
    byte[] fittest = null;

    public GammaInvFitnessFunction(int n, double d, double d2, double d3, int n2, boolean bl) {
        GammaDistribution gammaDistribution = new GammaDistribution(d2, d);
        this.fitness = new double[n][n2];
        this.fittest = new byte[n];
        int n3 = 0;
        for (int i = 0; i < n; ++i) {
            if (bl) {
                n3 = MathUtils.nextInt(n2);
            }
            this.fitness[i][n3] = 1.0;
            this.fittest[i] = (byte)n3;
            for (int j = 0; j < n2; ++j) {
                if (j == n3) continue;
                if (MathUtils.nextDouble() > d3) {
                    double d4 = (double)Math.round(MathUtils.nextDouble() * 1000.0) / 1000.0;
                    while (d4 <= 0.0 || d4 >= 1.0) {
                        d4 = (double)Math.round(MathUtils.nextDouble() * 1000.0) / 1000.0;
                    }
                    this.fitness[i][j] = Math.max(0.0, 1.0 - gammaDistribution.quantile(d4));
                    continue;
                }
                this.fitness[i][j] = 0.0;
            }
        }
    }

    @Override
    public final double getFitness(byte[] byArray) {
        double d = 1.0;
        for (int i = 0; i < byArray.length; ++i) {
            d *= this.fitness[i][byArray[i]];
        }
        return d;
    }

    @Override
    public double getFitnessFactor(int n, byte by, byte by2) {
        return this.fitness[n][by] / this.fitness[n][by2];
    }

    @Override
    public final double[][] getFitnessTable() {
        for (int i = 0; i < this.fitness[0].length; ++i) {
            for (int j = 0; j < this.fitness.length; ++j) {
                System.out.print((double)Math.round(this.fitness[j][i] * 1000.0) / 1000.0 + "\t");
            }
            System.out.println();
        }
        return this.fitness;
    }

    @Override
    public void initializeToFittest(byte[] byArray) {
        System.arraycopy(this.fittest, 0, byArray, 0, this.fittest.length);
    }
}

