# wpa 1.8.1

- fixed issue due to a 'tidyr' update (see #233).

# wpa 1.8.0

- Updated and improved output and algorithm for `workpatterns_classify()`
- Additional visual options for `workpatterns_classify()` and `flex_index()`
- Added the `external_*` family of functions to visualize the metric `Collaboration_hours_external`
- Added experimental function `identify_datefreq()` for detecting date frequency (#131)

# wpa 1.7.0

- Renamed 'Workplace Analytics' to 'Viva Insights'
- Improved features for multiple functions, e.g. centrality calculations for `network_p2p()`
- Improved compatibility of functions with new queries
- Introduced new functions, e.g. `create_density()`, `keymetrics_scan_asis()`, `network_summary()`
- Removed 'portes' dependency, which was removed from CRAN
- Bug fixes


# wpa 1.6.4

- Made `meeting_skim()` dynamic - the function will still run even if not all variables are present. (#198)
- Enable text mining functions to accept `stopwords` argument as a string
vector, rather than a data frame (#182)
- Better handling of errors due to variable name inconsistency when loading in a
Ways of Working Assessment query as opposed to a Standard Person Query (#201)

# wpa 1.6.3

- Added `create_inc()` for creating incidence analysis
- Replaced outdated uses of `mutate_all()` in functions (#195)

# wpa 1.6.2

- Added new signal options for `flex_index()` (#183, #185)
- Minor feature improvements (#186)
- Minor bugs fixed (#181, #184)
- Updated `em_data` with new signals (#191)

# wpa 1.6.1

- Fixed several minor bugs reported on GitHub (#177, #178, #180, #181)
- Refurbished `meeting_tm_report()` (#173)

# wpa 1.6.0

- Improved visuals on `workpatterns_rank()` and `identify_shifts_wp()` (#160)
- Added ability to show percentages on `identify_shifts_wp()` (#160)

New functions:
- `generate_report2()` (#141)
- `wellbeing_report()` (#141)
- `create_tracking()` (#141)
- `anonymize()` (#162)
- `jitter_metrics()` (#162)

Other changes:
- Improved error handling on `create_IV()` (#157)
- Bug fixes to plotting mechanism for `network_p2p()` and added ability to select custom weights (#149)


# wpa 1.5.0

- Improved aesthetics on plots
- New visuals, with abbreviated labels added to archetypes generated by `workpatterns_classify()` (#130, #132)

New functions:
- `hrvar_trend()` (#132)
- `one2one_freq()` (#132)

# wpa 1.4.3

- Patch update 
- New CRAN submission addressing some feedback on Rd files (successful)

# wpa 1.4.2

- Patch update 

# wpa 1.4.1

New functions:
- `one2one_freq()` (#95)

Significant changes to existing functions:
- `create_rank()` is now able to call `create_rank_combine()` to compute
averages for pairwise combinations. The `mode` and `plot_mode` arguments are
also made available to the key metric wrapper functions of `create_rank()`.
- `network_g2g()` now has the option to specify algorithm and node colour.

# wpa 1.4.0

v1.4.0 is the version where the **working patterns** family of functions are released open source as part of **wpa** (#55). These functions include:

- `workpatterns_classify()`
- `flex_index()`
- `workpatterns_report()`
- `plot_flex_index()`

In addition to the above, there are also some new functions, bug fixes, documentation, and performance improvements.

New functions:
- `import_to_fst()` (#86)
- `create_hist()` (#80)
- `identify_shifts_wp()` (#66)

Significant changes to existing functions:

- `collaboration_report()`: visuals and structure are improved (#69)
- `import_wpa()` can now specify encoding when reading in data, which now defaults to `UTF-8` (#76). This resolves a previous bug for reading in double-byte characters.
- `network_g2g()`: now auto-detects columns for collaborators and time investors. Also, if the value `'Collaborators Within Group'` does not exist in the data, a warning message is returned.

Bug fixes:

- `collab_area()` now has relaxed variable name checks which makes it less prone to fail when not all exact collaboration metrics are available or when cases do not match (#81).
- Resolved an issue of overly strict checks on `flag_outlooktime()`. Now it is possible to pass both `7:30` and `07:30` as inputs.

Documentation changes have been implemented across the board to comply with CRAN and to improve the user experience (#31)

# wpa 1.3.1

New functions, bug fixes, and performance improvements.

Significant changes to existing functions:
- New plot visual is available for `keymetrics_scan()`
- `combine_signals()` can now dynamically accept any metrics available in the Hourly Collaboration query.
- `pairwise_count()` now uses a **data.table** implementation, instead of dependent on **widyr**.

New functions:
- `network_p2p()`
- `network_leiden()`
- `network_louvain()`
- `network_describe()`
- `create_sankey()`
- `totals_col()`

Some package dependencies have been removed (see #36):
- **network**
- **GGally**
- **widyr**

# wpa 1.3.0

This is the first version of the **wpa** package to be released open-source on GitHub. If you have been using a previous developmental version, the main difference is that this release omits the more experimental _working patterns_ family of functions. The experimental functions are currently available upon request via mac@microsoft.com.
