/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.trees.m5;

import java.io.Serializable;
import weka.classifiers.trees.m5.RuleNode;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.RevisionHandler;
import weka.core.RevisionUtils;
import weka.core.Utils;

public class Rule
implements Serializable,
RevisionHandler {
    private static final long serialVersionUID = -4458627451682483204L;
    protected static int LEFT = 0;
    protected static int RIGHT = 1;
    private Instances m_instances;
    private int m_classIndex;
    private int m_numAttributes;
    private int m_numInstances;
    private int[] m_splitAtts;
    private double[] m_splitVals;
    private RuleNode[] m_internalNodes;
    private int[] m_relOps;
    private RuleNode m_ruleModel;
    protected RuleNode m_topOfTree;
    private double m_globalStdDev;
    private double m_globalAbsDev;
    private Instances m_covered;
    private int m_numCovered;
    private Instances m_notCovered;
    private boolean m_useTree = false;
    private boolean m_smoothPredictions = false;
    private boolean m_saveInstances;
    private boolean m_regressionTree;
    private boolean m_useUnpruned = false;
    private double m_minNumInstances = 4.0;

    public void buildClassifier(Instances data) throws Exception {
        this.m_instances = null;
        this.m_topOfTree = null;
        this.m_covered = null;
        this.m_notCovered = null;
        this.m_ruleModel = null;
        this.m_splitAtts = null;
        this.m_splitVals = null;
        this.m_relOps = null;
        this.m_internalNodes = null;
        this.m_instances = data;
        this.m_classIndex = this.m_instances.classIndex();
        this.m_numAttributes = this.m_instances.numAttributes();
        this.m_numInstances = this.m_instances.numInstances();
        this.m_globalStdDev = Rule.stdDev(this.m_classIndex, this.m_instances);
        this.m_globalAbsDev = Rule.absDev(this.m_classIndex, this.m_instances);
        this.m_topOfTree = new RuleNode(this.m_globalStdDev, this.m_globalAbsDev, null);
        this.m_topOfTree.setSaveInstances(this.m_saveInstances);
        this.m_topOfTree.setRegressionTree(this.m_regressionTree);
        this.m_topOfTree.setMinNumInstances(this.m_minNumInstances);
        this.m_topOfTree.buildClassifier(this.m_instances);
        if (!this.m_useUnpruned) {
            this.m_topOfTree.prune();
        } else {
            this.m_topOfTree.installLinearModels();
        }
        if (this.m_smoothPredictions) {
            this.m_topOfTree.installSmoothedModels();
        }
        this.m_topOfTree.numLeaves(0);
        if (!this.m_useTree) {
            this.makeRule();
        }
        this.m_instances = new Instances(this.m_instances, 0);
    }

    public double classifyInstance(Instance instance) throws Exception {
        if (this.m_useTree) {
            return this.m_topOfTree.classifyInstance(instance);
        }
        if (this.m_splitAtts.length > 0) {
            for (int i = 0; i < this.m_relOps.length; ++i) {
                if (!(this.m_relOps[i] == LEFT ? instance.value(this.m_splitAtts[i]) > this.m_splitVals[i] : instance.value(this.m_splitAtts[i]) <= this.m_splitVals[i])) continue;
                throw new Exception("Rule does not classify instance");
            }
        }
        return this.m_ruleModel.classifyInstance(instance);
    }

    public RuleNode topOfTree() {
        return this.m_topOfTree;
    }

    private void makeRule() throws Exception {
        RuleNode[] best_leaf = new RuleNode[1];
        double[] best_cov = new double[1];
        this.m_notCovered = new Instances(this.m_instances, 0);
        this.m_covered = new Instances(this.m_instances, 0);
        best_cov[0] = -1.0;
        best_leaf[0] = null;
        this.m_topOfTree.findBestLeaf(best_cov, best_leaf);
        RuleNode temp = best_leaf[0];
        if (temp == null) {
            throw new Exception("Unable to generate rule!");
        }
        this.m_ruleModel = temp;
        int count = 0;
        while (temp.parentNode() != null) {
            ++count;
            temp = temp.parentNode();
        }
        temp = best_leaf[0];
        this.m_relOps = new int[count];
        this.m_splitAtts = new int[count];
        this.m_splitVals = new double[count];
        if (this.m_smoothPredictions) {
            this.m_internalNodes = new RuleNode[count];
        }
        int i = 0;
        while (temp.parentNode() != null) {
            this.m_splitAtts[i] = temp.parentNode().splitAtt();
            this.m_splitVals[i] = temp.parentNode().splitVal();
            if (temp.parentNode().leftNode() == temp) {
                this.m_relOps[i] = LEFT;
                temp.parentNode().m_right = null;
            } else {
                this.m_relOps[i] = RIGHT;
                temp.parentNode().m_left = null;
            }
            if (this.m_smoothPredictions) {
                this.m_internalNodes[i] = temp.parentNode();
            }
            temp = temp.parentNode();
            ++i;
        }
        for (i = 0; i < this.m_numInstances; ++i) {
            boolean ok = true;
            for (int j = 0; j < this.m_relOps.length; ++j) {
                if (this.m_relOps[j] == LEFT) {
                    if (!(this.m_instances.instance(i).value(this.m_splitAtts[j]) > this.m_splitVals[j])) continue;
                    this.m_notCovered.add(this.m_instances.instance(i));
                    ok = false;
                    break;
                }
                if (!(this.m_instances.instance(i).value(this.m_splitAtts[j]) <= this.m_splitVals[j])) continue;
                this.m_notCovered.add(this.m_instances.instance(i));
                ok = false;
                break;
            }
            if (!ok) continue;
            ++this.m_numCovered;
        }
    }

    public String toString() {
        if (this.m_useTree) {
            return this.treeToString();
        }
        return this.ruleToString();
    }

    private String treeToString() {
        StringBuffer text = new StringBuffer();
        if (this.m_topOfTree == null) {
            return "Tree/Rule has not been built yet!";
        }
        text.append("M5 " + (this.m_useUnpruned ? "unpruned " : "pruned ") + (this.m_regressionTree ? "regression " : "model ") + "tree:\n");
        if (this.m_smoothPredictions) {
            text.append("(using smoothed linear models)\n");
        }
        text.append(this.m_topOfTree.treeToString(0));
        text.append(this.m_topOfTree.printLeafModels());
        text.append("\nNumber of Rules : " + this.m_topOfTree.numberOfLinearModels());
        return text.toString();
    }

    private String ruleToString() {
        StringBuffer text = new StringBuffer();
        if (this.m_splitAtts.length > 0) {
            text.append("IF\n");
            for (int i = this.m_splitAtts.length - 1; i >= 0; --i) {
                text.append("\t" + this.m_covered.attribute(this.m_splitAtts[i]).name() + " ");
                if (this.m_relOps[i] == 0) {
                    text.append("<= ");
                } else {
                    text.append("> ");
                }
                text.append(Utils.doubleToString(this.m_splitVals[i], 1, 3) + "\n");
            }
            text.append("THEN\n");
        }
        if (this.m_ruleModel != null) {
            try {
                text.append(this.m_ruleModel.printNodeLinearModel());
                text.append(" [" + this.m_numCovered);
                if (this.m_globalAbsDev > 0.0) {
                    text.append("/" + Utils.doubleToString(100.0 * this.m_ruleModel.rootMeanSquaredError() / this.m_globalStdDev, 1, 3) + "%]\n\n");
                } else {
                    text.append("]\n\n");
                }
            }
            catch (Exception e) {
                return "Can't print rule";
            }
        }
        return text.toString();
    }

    public void setUnpruned(boolean unpruned) {
        this.m_useUnpruned = unpruned;
    }

    public boolean getUnpruned() {
        return this.m_useUnpruned;
    }

    public void setUseTree(boolean u) {
        this.m_useTree = u;
    }

    public boolean getUseTree() {
        return this.m_useTree;
    }

    public void setSmoothing(boolean s) {
        this.m_smoothPredictions = s;
    }

    public boolean getSmoothing() {
        return this.m_smoothPredictions;
    }

    public Instances notCoveredInstances() {
        return this.m_notCovered;
    }

    public void freeNotCoveredInstances() {
        this.m_notCovered = null;
    }

    protected static final double stdDev(int attr, Instances inst) {
        double sd;
        int count = 0;
        double sum = 0.0;
        double sqrSum = 0.0;
        for (int i = 0; i <= inst.numInstances() - 1; ++i) {
            ++count;
            double value = inst.instance(i).value(attr);
            sum += value;
            sqrSum += value * value;
        }
        if (count > 1) {
            double va = (sqrSum - sum * sum / (double)count) / (double)count;
            va = Math.abs(va);
            sd = Math.sqrt(va);
        } else {
            sd = 0.0;
        }
        return sd;
    }

    protected static final double absDev(int attr, Instances inst) {
        double absDev;
        int i;
        double average = 0.0;
        double absdiff = 0.0;
        for (i = 0; i <= inst.numInstances() - 1; ++i) {
            average += inst.instance(i).value(attr);
        }
        if (inst.numInstances() > 1) {
            average /= (double)inst.numInstances();
            for (i = 0; i <= inst.numInstances() - 1; ++i) {
                absdiff += Math.abs(inst.instance(i).value(attr) - average);
            }
            absDev = absdiff / (double)inst.numInstances();
        } else {
            absDev = 0.0;
        }
        return absDev;
    }

    protected void setSaveInstances(boolean save) {
        this.m_saveInstances = save;
    }

    public boolean getRegressionTree() {
        return this.m_regressionTree;
    }

    public void setRegressionTree(boolean newregressionTree) {
        this.m_regressionTree = newregressionTree;
    }

    public void setMinNumInstances(double minNum) {
        this.m_minNumInstances = minNum;
    }

    public double getMinNumInstances() {
        return this.m_minNumInstances;
    }

    public RuleNode getM5RootNode() {
        return this.m_topOfTree;
    }

    @Override
    public String getRevision() {
        return RevisionUtils.extract("$Revision: 6237 $");
    }
}

