/*
 * Decompiled with CFR 0.152.
 */
package moa.streams;

import com.github.javacliparser.IntOption;
import com.yahoo.labs.samoa.instances.Instance;
import com.yahoo.labs.samoa.instances.InstancesHeader;
import java.util.Random;
import moa.core.Example;
import moa.core.ObjectRepository;
import moa.options.AbstractOptionHandler;
import moa.options.ClassOption;
import moa.streams.ExampleStream;
import moa.tasks.TaskMonitor;

public class PartitioningStream
extends AbstractOptionHandler
implements ExampleStream {
    private static final long serialVersionUID = 1L;
    public ClassOption streamOption = new ClassOption("baseStream", 's', "Stream which is used for partitioning.", ExampleStream.class, "generators.RandomTreeGenerator");
    public IntOption partitionIndexOption = new IntOption("partitionIndex", 'i', "The index of the partition, which should be used as output.", 0);
    public IntOption numPartitionsOption = new IntOption("numPartitions", 'n', "The number of total streams the base stream is split into.", 1);
    public IntOption randomSeedOption = new IntOption("randomSeed", 'r', "The seed which is used (all other partitions should use the same one to guarentee).", 0);
    protected ExampleStream baseStream;
    protected int partitionIndex;
    protected int numPartitions;
    protected Random random;

    @Override
    public InstancesHeader getHeader() {
        return this.baseStream.getHeader();
    }

    @Override
    public long estimatedRemainingInstances() {
        long baseEstimatedRemainingInstances = this.baseStream.estimatedRemainingInstances();
        if (baseEstimatedRemainingInstances < 0L) {
            return baseEstimatedRemainingInstances;
        }
        long numRemaining = baseEstimatedRemainingInstances * (long)(this.numPartitions - 1) / (long)this.numPartitions;
        if (this.numPartitions == 1) {
            numRemaining = baseEstimatedRemainingInstances;
        }
        return numRemaining;
    }

    @Override
    public boolean hasMoreInstances() {
        return this.baseStream.hasMoreInstances();
    }

    public Example<Instance> nextInstance() {
        Object result = this.baseStream.nextInstance();
        this.discardNexInstancesNotFromPartition();
        return result;
    }

    @Override
    public boolean isRestartable() {
        return this.baseStream.isRestartable();
    }

    @Override
    public void restart() {
        this.random = new Random(this.randomSeedOption.getValue());
    }

    @Override
    public void getDescription(StringBuilder sb, int indent) {
    }

    @Override
    protected void prepareForUseImpl(TaskMonitor monitor, ObjectRepository repository) {
        this.baseStream = (ExampleStream)this.getPreparedClassOption(this.streamOption);
        this.partitionIndex = this.partitionIndexOption.getValue();
        this.numPartitions = this.numPartitionsOption.getValue();
        this.random = new Random(this.randomSeedOption.getValue());
        this.discardNexInstancesNotFromPartition();
    }

    protected int getNextPartitionToLeaveOut() {
        return this.random.nextInt(this.numPartitions);
    }

    protected boolean isNextInstanceFromPartition() {
        return this.getNextPartitionToLeaveOut() != this.partitionIndex;
    }

    protected void discardNexInstancesNotFromPartition() {
        while (!this.isNextInstanceFromPartition() && this.baseStream.hasMoreInstances() && this.numPartitions > 1) {
            this.baseStream.nextInstance();
        }
    }
}

