/*
 * Decompiled with CFR 0.152.
 */
package moa.streams;

import com.yahoo.labs.samoa.instances.InstancesHeader;
import moa.core.Example;
import moa.core.ObjectRepository;
import moa.options.AbstractOptionHandler;
import moa.options.ClassOption;
import moa.options.OptionHandler;
import moa.streams.ExampleStream;
import moa.streams.MultiTargetArffFileStream;
import moa.streams.MultiTargetInstanceStream;
import moa.streams.filters.MultiLabelStreamFilter;
import moa.streams.filters.SelectAttributesFilter;
import moa.tasks.TaskMonitor;

public class MultiLabelFilteredStream
extends AbstractOptionHandler
implements MultiTargetInstanceStream {
    private static final long serialVersionUID = 1L;
    public ClassOption streamOption = new ClassOption("stream", 's', "Stream to filter.", MultiTargetInstanceStream.class, MultiTargetArffFileStream.class.getName());
    public ClassOption filtersOption = new ClassOption("filters", 'f', "Filters to apply.", MultiLabelStreamFilter.class, SelectAttributesFilter.class.getName());
    protected ExampleStream filterChain;

    @Override
    public String getPurposeString() {
        return "A stream that is filtered.";
    }

    @Override
    public void prepareForUseImpl(TaskMonitor monitor, ObjectRepository repository) {
        monitor.setCurrentActivity("Materializing filter ...", -1.0);
        MultiLabelStreamFilter filters = (MultiLabelStreamFilter)this.getPreparedClassOption(this.filtersOption);
        if (monitor.taskShouldAbort()) {
            return;
        }
        if (filters instanceof OptionHandler) {
            monitor.setCurrentActivity("Preparing filter ...", -1.0);
            ((OptionHandler)((Object)filters)).prepareForUse(monitor, repository);
            if (monitor.taskShouldAbort()) {
                return;
            }
        }
        MultiTargetInstanceStream chain = (MultiTargetInstanceStream)this.getPreparedClassOption(this.streamOption);
        filters.setInputStream(chain);
        chain = filters;
        this.filterChain = chain;
    }

    @Override
    public long estimatedRemainingInstances() {
        return this.filterChain.estimatedRemainingInstances();
    }

    @Override
    public InstancesHeader getHeader() {
        return this.filterChain.getHeader();
    }

    @Override
    public boolean hasMoreInstances() {
        return this.filterChain.hasMoreInstances();
    }

    @Override
    public boolean isRestartable() {
        return this.filterChain.isRestartable();
    }

    @Override
    public Example nextInstance() {
        return this.filterChain.nextInstance();
    }

    @Override
    public void restart() {
        this.filterChain.restart();
    }

    @Override
    public void getDescription(StringBuilder sb, int indent) {
    }
}

