/*
 * Decompiled with CFR 0.152.
 */
package moa.capabilities;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;
import moa.capabilities.Capabilities;
import moa.capabilities.CapabilitiesHandler;
import moa.capabilities.Capability;

public final class ImmutableCapabilities
extends Capabilities {
    public ImmutableCapabilities(Capability ... capabilities) {
        this.m_Capabilities.addAll(Arrays.asList(capabilities));
    }

    @Override
    public final void addCapabilities(Capability ... capabilities) {
        throw new UnsupportedOperationException();
    }

    @Override
    public final void addCapabilities(Collection<Capability> capabilities) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void addCapabilities(Capabilities other) {
        throw new UnsupportedOperationException();
    }

    @Override
    public final void addCapability(Capability capability) {
        throw new UnsupportedOperationException();
    }

    static class StaticLookup {
        private static Map<ImmutableCapabilities, ImmutableCapabilities> m_UniqueSet = new HashMap<ImmutableCapabilities, ImmutableCapabilities>();
        private static Map<CapabilitiesHandler, ImmutableCapabilities> m_Lookup = new WeakHashMap<CapabilitiesHandler, ImmutableCapabilities>();

        StaticLookup() {
        }

        public static boolean isDefined(CapabilitiesHandler owner) {
            if (owner == null) {
                throw new IllegalArgumentException("Null is not a valid capabilities handler.");
            }
            return m_Lookup.containsKey(owner);
        }

        public static void define(CapabilitiesHandler owner, ImmutableCapabilities capabilities) {
            if (StaticLookup.isDefined(owner)) {
                throw new IllegalArgumentException("Illegal attempt to redefine capabilities.");
            }
            if (capabilities == null) {
                capabilities = new ImmutableCapabilities(new Capability[0]);
            }
            if (m_UniqueSet.containsKey(capabilities)) {
                capabilities = m_UniqueSet.get(capabilities);
            } else {
                m_UniqueSet.put(capabilities, capabilities);
            }
            m_Lookup.put(owner, capabilities);
        }

        public static ImmutableCapabilities get(CapabilitiesHandler owner) {
            if (!StaticLookup.isDefined(owner)) {
                throw new IllegalArgumentException("Illegal attempt to get capabilities for undefined owner.");
            }
            return m_Lookup.get(owner);
        }
    }
}

