/*
 * Decompiled with CFR 0.152.
 */
package org.vikamine.kernel.subgroup.search;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.vikamine.kernel.data.Attribute;
import org.vikamine.kernel.data.DataRecord;
import org.vikamine.kernel.subgroup.search.FPNodeNumeric;
import org.vikamine.kernel.subgroup.search.SDMapNumeric;
import org.vikamine.kernel.subgroup.selectors.SGSelector;
import org.vikamine.kernel.subgroup.target.NumericTarget;

class FPTreeNumeric {
    public List<FPNodeNumeric> frequentHeaderNodes;
    public FPNodeNumeric.FPTreeNodeNumeric root;
    private SDMapNumeric sdmap;

    private FPTreeNumeric(List<FPNodeNumeric> frequentHeaderNodes, FPNodeNumeric.FPTreeNodeNumeric root, SDMapNumeric sdmap) {
        this.frequentHeaderNodes = frequentHeaderNodes;
        this.root = root;
        this.sdmap = sdmap;
    }

    public FPTreeNumeric(Collection<? extends SGSelector> selectorSet, Iterable<DataRecord> instanceIteration, boolean pruneFrequentItems, SDMapNumeric sdmap) {
        this.sdmap = sdmap;
        this.frequentHeaderNodes = this.createFrequentItemNodeList(selectorSet, instanceIteration, pruneFrequentItems);
        this.root = new FPNodeNumeric.FPTreeNodeNumeric(null);
        if (!this.frequentHeaderNodes.isEmpty()) {
            for (DataRecord inst : instanceIteration) {
                this.insertIntoTree(inst, (NumericTarget)sdmap.target);
                if (!sdmap.aborted) continue;
                return;
            }
        }
    }

    private StringBuffer printTree(FPNodeNumeric.FPTreeNodeNumeric node, int depth, StringBuffer buffy) {
        int i = 0;
        while (i < depth) {
            buffy.append("|");
            ++i;
        }
        if (node.sel != null) {
            buffy.append(node.toString());
        }
        buffy.append("\n");
        for (FPNodeNumeric.FPTreeNodeNumeric child : node.children) {
            this.printTree(child, depth + 1, buffy);
        }
        return buffy;
    }

    public String toString() {
        StringBuffer buffy = new StringBuffer();
        buffy.append("Frequent Selectors: " + this.frequentHeaderNodes);
        buffy = this.printTree(this.root, 0, buffy);
        return buffy.toString();
    }

    public Collection<Attribute> extractFrequentAttributes() {
        HashSet<Attribute> attributes = new HashSet<Attribute>();
        for (FPNodeNumeric n : this.frequentHeaderNodes) {
            attributes.add(n.sel.getAttribute());
        }
        return attributes;
    }

    public FPNodeNumeric findMostUnfrequentFPNode(Collection<SGSelector> selectors) {
        ArrayList<FPNodeNumeric> freqHeaderNodes = new ArrayList<FPNodeNumeric>(this.frequentHeaderNodes);
        FPTreeNumeric.sortFrequentNodesAscending(freqHeaderNodes);
        for (FPNodeNumeric n : freqHeaderNodes) {
            if (!selectors.contains(n.sel)) continue;
            return n;
        }
        return null;
    }

    static void sortFrequentNodesDescending(List<FPNodeNumeric> nodes) {
        Collections.sort(nodes, new Comparator<FPNodeNumeric>(){

            @Override
            public int compare(FPNodeNumeric n1, FPNodeNumeric n2) {
                if (n1.n == n2.n) {
                    return 0;
                }
                return n1.n < n2.n ? 1 : -1;
            }
        });
    }

    static void sortFrequentNodesAscending(List<FPNodeNumeric> nodes) {
        Collections.sort(nodes, new Comparator<FPNodeNumeric>(){

            @Override
            public int compare(FPNodeNumeric n1, FPNodeNumeric n2) {
                if (n1.n == n2.n) {
                    return 0;
                }
                return n1.n > n2.n ? 1 : -1;
            }
        });
    }

    public boolean containsAnyAttribute(Set<Attribute> attributes) {
        for (FPNodeNumeric node : this.frequentHeaderNodes) {
            for (Attribute a : attributes) {
                if (node.sel.getAttribute() != a) continue;
                return true;
            }
        }
        return false;
    }

    public FPNodeNumeric getFPNodeWithSameAttributeAsSelector(SGSelector sel) {
        for (FPNodeNumeric n : this.frequentHeaderNodes) {
            if (n.sel.getAttribute() != sel.getAttribute()) continue;
            return n;
        }
        return null;
    }

    public FPNodeNumeric getFPNodeForSelector(SGSelector sel) {
        for (FPNodeNumeric n : this.frequentHeaderNodes) {
            if (n.sel != sel) continue;
            return n;
        }
        return null;
    }

    public FPTreeNumeric buildConditionalFPTree(FPNodeNumeric headerNode) {
        List<? extends FPNodeNumeric.FPTreePathNumeric> paths = headerNode.getAllPrefixPaths();
        FPTreeNumeric conditionalTree = this.buildConditionalFPTree(paths);
        return conditionalTree;
    }

    private FPTreeNumeric buildConditionalFPTree(List<? extends FPNodeNumeric.FPTreePathNumeric> conditionalPaths) {
        Map<SGSelector, FPNodeNumeric> frequentNodesMap = FPTreeNumeric.collectFrequentNodesMapFromPaths(conditionalPaths);
        List<FPNodeNumeric> frequentNodes = this.pruneAndSortFrequentNodesMapDescending(frequentNodesMap, true);
        if (frequentNodes.isEmpty()) {
            return null;
        }
        FPTreeNumeric tree = new FPTreeNumeric(frequentNodes, new FPNodeNumeric.FPTreeNodeNumeric(null), this.sdmap);
        tree.insertPathsIntoConditionalTree(conditionalPaths, frequentNodes);
        return tree;
    }

    private void insertPathsIntoConditionalTree(List conditionalPaths, List frequentNodes) {
        block0: for (FPNodeNumeric.FPTreePathNumeric path : conditionalPaths) {
            FPNodeNumeric.FPTreeNodeNumeric activeNode = this.root;
            for (FPNodeNumeric aFrequentNode : frequentNodes) {
                SGSelector sel = aFrequentNode.sel;
                if (path.selectors.remove(sel)) {
                    FPNodeNumeric.FPTreeNodeNumeric child = activeNode.getChildForSelector(sel);
                    if (child == null) {
                        child = new FPNodeNumeric.FPTreeNodeNumeric(sel);
                        this.insertIntoFrequentNodes(aFrequentNode, child);
                        activeNode.children.add(child);
                        child.parent = activeNode;
                    }
                    child.sum += path.sum;
                    child.estimate += path.estimate;
                    child.n += path.n;
                    activeNode = child;
                }
                if (path.selectors.isEmpty()) continue block0;
            }
        }
    }

    private void insertIntoFrequentNodes(FPNodeNumeric freqNode, FPNodeNumeric.FPTreeNodeNumeric node) {
        if (freqNode.sel != node.sel) {
            throw new IllegalStateException("Wrong freqNode for FPTreeNode ...");
        }
        freqNode.siblings.add(node);
    }

    private List<FPNodeNumeric> pruneAndSortFrequentNodesMapDescending(Map<SGSelector, FPNodeNumeric> frequentNodesMap, boolean pruneFrequentItems) {
        if (pruneFrequentItems) {
            Iterator<FPNodeNumeric> iter = frequentNodesMap.values().iterator();
            while (iter.hasNext()) {
                FPNodeNumeric node = iter.next();
                if (node.n < this.sdmap.task.getMinSubgroupSize()) {
                    iter.remove();
                    continue;
                }
                if (this.sdmap.result == null || !this.sdmap.isPruningEnabled() || this.sdmap.result.isInKBestQualityRange(node.estimate)) continue;
                iter.remove();
            }
        }
        ArrayList<FPNodeNumeric> result = new ArrayList<FPNodeNumeric>(frequentNodesMap.values());
        FPTreeNumeric.sortFrequentNodesDescending(result);
        return result;
    }

    private static Map<SGSelector, FPNodeNumeric> collectFrequentNodesMapFromPaths(List<? extends FPNodeNumeric.FPTreePathNumeric> conditionalPaths) {
        HashMap<SGSelector, FPNodeNumeric> frequentNodesMap = new HashMap<SGSelector, FPNodeNumeric>();
        for (FPNodeNumeric.FPTreePathNumeric fPTreePathNumeric : conditionalPaths) {
            for (SGSelector sel : fPTreePathNumeric.selectors) {
                FPNodeNumeric node = (FPNodeNumeric)frequentNodesMap.get(sel);
                if (node == null) {
                    node = new FPNodeNumeric(sel);
                    frequentNodesMap.put(sel, node);
                }
                node.sum += fPTreePathNumeric.sum;
                node.estimate += fPTreePathNumeric.estimate;
                node.n += fPTreePathNumeric.n;
            }
        }
        return frequentNodesMap;
    }

    private void insertIntoTree(DataRecord inst, NumericTarget target) {
        FPNodeNumeric.FPTreeNodeNumeric activeNode = this.root;
        for (FPNodeNumeric node : this.frequentHeaderNodes) {
            SGSelector sel = node.sel;
            if (!sel.isContainedInInstance(inst)) continue;
            FPNodeNumeric.FPTreeNodeNumeric child = activeNode.getChildForSelector(sel);
            if (child == null) {
                child = new FPNodeNumeric.FPTreeNodeNumeric(sel);
                this.insertIntoFrequentNodes(node, child);
                activeNode.children.add(child);
                child.parent = activeNode;
            }
            child.n += inst.getWeight();
            child.sum += inst.getWeight() * target.getValue(inst);
            if (target.getValue(inst) > this.sdmap.populationMean) {
                child.estimate += (target.getValue(inst) - this.sdmap.populationMean) * inst.getWeight();
            }
            activeNode = child;
        }
    }

    private List<FPNodeNumeric> createFrequentItemNodeList(Collection<? extends SGSelector> selectorSet, Iterable<DataRecord> instanceIteration, boolean pruneFrequentItems) {
        HashMap<SGSelector, FPNodeNumeric> frequentNodesMap = new HashMap<SGSelector, FPNodeNumeric>();
        NumericTarget target = (NumericTarget)this.sdmap.target;
        for (DataRecord inst : instanceIteration) {
            for (SGSelector sGSelector : selectorSet) {
                if (!sGSelector.isContainedInInstance(inst)) continue;
                FPNodeNumeric node = (FPNodeNumeric)frequentNodesMap.get(sGSelector);
                if (node == null) {
                    node = new FPNodeNumeric(sGSelector);
                    frequentNodesMap.put(sGSelector, node);
                }
                node.n += inst.getWeight();
                double value = target.getValue(inst);
                node.sum += value * inst.getWeight();
                if (!(value > this.sdmap.populationMean)) continue;
                node.estimate += (value - this.sdmap.populationMean) * inst.getWeight();
            }
            if (this.sdmap.aborted) break;
        }
        return this.pruneAndSortFrequentNodesMapDescending(frequentNodesMap, pruneFrequentItems);
    }

    public boolean treeHasSinglePath() {
        FPNodeNumeric.FPTreeNodeNumeric node = this.root;
        while (!node.children.isEmpty()) {
            if (node.children.size() > 1) {
                return false;
            }
            node = node.children.get(0);
        }
        return true;
    }

    public List<FPNodeNumeric> getFrequentHeaderNodes() {
        return this.frequentHeaderNodes;
    }
}

