/*
 * Decompiled with CFR 0.152.
 */
package org.vikamine.kernel.subgroup;

import org.vikamine.kernel.subgroup.SG;
import org.vikamine.kernel.subgroup.SGSet;
import org.vikamine.kernel.subgroup.SGSets;
import org.vikamine.kernel.subgroup.SGStatisticsBinary;
import org.vikamine.kernel.subgroup.SGUtils;
import org.vikamine.kernel.util.SGImprovementCalculator;

public interface SGFilters {
    public SGSet filterSGs(Iterable<SG> var1);

    public static class MinImprovementFilterGlobal
    implements SGFilters {
        double minImprovement;

        public MinImprovementFilterGlobal(double minImprovement) {
            this.minImprovement = minImprovement;
        }

        @Override
        public SGSet filterSGs(Iterable<SG> sgSet) {
            SGSet result = SGSets.createSGSet();
            SGImprovementCalculator calc = new SGImprovementCalculator();
            for (SG sg : sgSet) {
                double improvement = calc.calculateMinImprovement(sg);
                if (!(improvement > this.minImprovement)) continue;
                result.add(sg);
            }
            return result;
        }
    }

    public static class MinImprovementFilterOnSGSet
    implements SGFilters {
        double minImprovement;

        public MinImprovementFilterOnSGSet(double minImprovement) {
            this.minImprovement = minImprovement;
        }

        @Override
        public SGSet filterSGs(Iterable<SG> sgSet) {
            SGSet result = SGSets.createSGSet();
            for (SG sg : sgSet) {
                double improvement = Double.MAX_VALUE;
                for (SG sg2 : sgSet) {
                    if (sg.equals(sg2) || !sg.getSGDescription().isSpecialization(sg2.getSGDescription())) continue;
                    improvement = Math.min(improvement, sg.getStatistics().getDeviation() - sg2.getStatistics().getDeviation());
                }
                if (!(improvement > this.minImprovement)) continue;
                result.add(sg);
            }
            return result;
        }
    }

    public static class RelevancyFilter
    implements SGFilters {
        @Override
        public SGSet filterSGs(Iterable<SG> sgSet) {
            SGSet result = SGSets.createSGSet();
            for (SG sg : sgSet) {
                if (SGSets.isSGStrictlyIrrelevant(sg, result)) continue;
                result.add(sg);
            }
            return result;
        }
    }

    public static class SignificantImprovementFilterGlobal
    implements SGFilters {
        double alpha;

        public SignificantImprovementFilterGlobal(double alpha) {
            this.alpha = alpha;
        }

        @Override
        public SGSet filterSGs(Iterable<SG> sgSet) {
            SGSet result = SGSets.createSGSet();
            SGImprovementCalculator calc = new SGImprovementCalculator();
            for (SG sg : sgSet) {
                double maxPValue = calc.calculateMaxPValueToSubsets(sg);
                if (!(maxPValue < this.alpha)) continue;
                result.add(sg);
            }
            return result;
        }
    }

    public static class SignificantImprovementFilterOnSet
    implements SGFilters {
        double alpha;

        public SignificantImprovementFilterOnSet(double alpha) {
            this.alpha = alpha;
        }

        @Override
        public SGSet filterSGs(Iterable<SG> sgSet) {
            SGSet result = SGSets.createSGSet();
            for (SG sg : sgSet) {
                if (sg.getTarget().isNumeric()) {
                    throw new IllegalArgumentException("Not applicable for numeric target " + sg.getTarget());
                }
                boolean add = true;
                for (SG sg2 : sgSet) {
                    double d;
                    double c;
                    double b;
                    if (sg.equals(sg2) || !sg.getSGDescription().isSpecialization(sg2.getSGDescription())) continue;
                    SGStatisticsBinary sgStats = (SGStatisticsBinary)sg.getStatistics();
                    SGStatisticsBinary sg2Stats = (SGStatisticsBinary)sg2.getStatistics();
                    double a = sgStats.getTp();
                    double significanceOfDifference = SGUtils.getChi2SignificanceNiveau(a, b = sg2Stats.getTp() - a, c = sgStats.getFp(), d = sg2Stats.getFp() - c);
                    if (!(significanceOfDifference > this.alpha)) continue;
                    add = false;
                    break;
                }
                if (!add) continue;
                result.add(sg);
            }
            return result;
        }
    }

    public static class SizeFilter
    implements SGFilters {
        double minSize;

        public SizeFilter(double size) {
            this.minSize = size;
        }

        @Override
        public SGSet filterSGs(Iterable<SG> sgSet) {
            SGSet result = SGSets.createSGSet();
            for (SG sg : sgSet) {
                double size = sg.getStatistics().getSubgroupSize();
                if (!(size > this.minSize)) continue;
                result.add(sg);
            }
            return result;
        }
    }
}

