/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.variables.impl;

import org.chocosolver.solver.ICause;
import org.chocosolver.solver.Model;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.variables.events.GraphEventType;
import org.chocosolver.solver.variables.impl.UndirectedGraphVarImpl;
import org.chocosolver.util.objects.graphs.UndirectedGraph;
import org.chocosolver.util.objects.setDataStructures.ISetIterator;

public class UndirectedNodeInducedGraphVarImpl
extends UndirectedGraphVarImpl
implements ICause {
    private final UndirectedGraph originalUB;

    public UndirectedNodeInducedGraphVarImpl(String name, Model solver, UndirectedGraph LB, UndirectedGraph UB) {
        super(name, solver, LB, UB);
        this.originalUB = new UndirectedGraph(UB);
    }

    @Override
    public boolean enforceNode(int x, ICause cause) throws ContradictionException {
        boolean nodeEnforced = super.enforceNode(x, cause);
        if (!nodeEnforced) {
            return false;
        }
        boolean edgeAdded = false;
        ISetIterator iSetIterator = this.originalUB.getNeighborsOf(x).iterator();
        while (iSetIterator.hasNext()) {
            int y = (Integer)iSetIterator.next();
            if (((UndirectedGraph)this.LB).containsNode(y)) {
                if (!((UndirectedGraph)this.UB).containsEdge(x, y)) {
                    this.contradiction(cause, "Cannot enforce node " + x + " because edge (" + x + ", " + y + ") was removed from the envelope");
                }
                if (!((UndirectedGraph)this.LB).addEdge(x, y)) continue;
                if (this.reactOnModification) {
                    this.delta.add(x, 4, this);
                    this.delta.add(y, 5, this);
                }
                edgeAdded = true;
                continue;
            }
            if (!((UndirectedGraph)this.UB).containsNode(y) || ((UndirectedGraph)this.UB).containsEdge(x, y)) continue;
            this.removeNode(y, this);
        }
        if (edgeAdded) {
            this.notifyPropagators(GraphEventType.ADD_EDGE, this);
        }
        return true;
    }

    @Override
    public boolean removeEdge(int x, int y, ICause cause) throws ContradictionException {
        boolean edgeRemoved = super.removeEdge(x, y, cause);
        if (!edgeRemoved) {
            return false;
        }
        boolean xInKer = this.getMandatoryNodes().contains(x);
        boolean yInKer = this.getMandatoryNodes().contains(y);
        if (xInKer && yInKer) {
            this.contradiction(cause, "Remove mandatory edge");
        }
        if (xInKer && !yInKer) {
            this.removeNode(y, this);
        }
        if (!xInKer && yInKer) {
            this.removeNode(x, this);
        }
        return true;
    }
}

