/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.constraints.nary.sum;

import org.chocosolver.solver.ICause;
import org.chocosolver.solver.constraints.Operator;
import org.chocosolver.solver.constraints.nary.sum.PropSumWithLong;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.variables.IntVar;
import org.chocosolver.util.ESat;

public class PropScalarWithLong
extends PropSumWithLong {
    private final long[] c;

    public PropScalarWithLong(IntVar[] variables, long[] coeffs, int pos, Operator o, long b) {
        super(variables, pos, o, b);
        this.c = coeffs;
    }

    @Override
    protected void prepare() {
        long ub;
        long lb;
        int i;
        this.sumUB = 0L;
        this.sumLB = 0L;
        this.maxI = 0L;
        for (i = 0; i < this.pos; ++i) {
            lb = (long)((IntVar[])this.vars)[i].getLB() * this.c[i];
            ub = (long)((IntVar[])this.vars)[i].getUB() * this.c[i];
            this.sumLB += lb;
            this.sumUB += ub;
            this.I[i] = ub - lb;
            if (this.maxI >= this.I[i]) continue;
            this.maxI = this.I[i];
        }
        while (i < this.l) {
            lb = (long)((IntVar[])this.vars)[i].getUB() * this.c[i];
            ub = (long)((IntVar[])this.vars)[i].getLB() * this.c[i];
            this.sumLB += lb;
            this.sumUB += ub;
            this.I[i] = ub - lb;
            if (this.maxI < this.I[i]) {
                this.maxI = this.I[i];
            }
            ++i;
        }
    }

    @Override
    protected void filterOnEq() throws ContradictionException {
        boolean anychange;
        long F2 = this.b - this.sumLB;
        long E = this.sumUB - this.b;
        do {
            anychange = false;
            if (this.model.getSolver().isLearnOff() && F2 < 0L || E < 0L) {
                this.fails();
            }
            if (this.maxI > F2 || this.maxI > E) {
                long nlb;
                long nub;
                long ub;
                long lb;
                int i;
                this.maxI = 0L;
                for (i = 0; i < this.pos; ++i) {
                    if (this.I[i] - F2 > 0L) {
                        lb = (long)((IntVar[])this.vars)[i].getLB() * this.c[i];
                        ub = lb + this.I[i];
                        if (((IntVar[])this.vars)[i].updateUpperBound(this.divFloor(F2 + lb, this.c[i]), (ICause)this)) {
                            nub = (long)((IntVar[])this.vars)[i].getUB() * this.c[i];
                            E += nub - ub;
                            this.I[i] = nub - lb;
                            anychange = true;
                        }
                    }
                    if (this.I[i] - E > 0L) {
                        ub = (long)((IntVar[])this.vars)[i].getUB() * this.c[i];
                        lb = ub - this.I[i];
                        if (((IntVar[])this.vars)[i].updateLowerBound(this.divCeil(ub - E, this.c[i]), (ICause)this)) {
                            nlb = (long)((IntVar[])this.vars)[i].getLB() * this.c[i];
                            F2 -= nlb - lb;
                            this.I[i] = ub - nlb;
                            anychange = true;
                        }
                    }
                    if (this.maxI >= this.I[i]) continue;
                    this.maxI = this.I[i];
                }
                while (i < this.l) {
                    if (this.I[i] - F2 > 0L) {
                        lb = (long)((IntVar[])this.vars)[i].getUB() * this.c[i];
                        ub = lb + this.I[i];
                        if (((IntVar[])this.vars)[i].updateLowerBound(this.divCeil(-F2 - lb, -this.c[i]), (ICause)this)) {
                            nub = (long)((IntVar[])this.vars)[i].getLB() * this.c[i];
                            E += nub - ub;
                            this.I[i] = nub - lb;
                            anychange = true;
                        }
                    }
                    if (this.I[i] - E > 0L) {
                        ub = (long)((IntVar[])this.vars)[i].getLB() * this.c[i];
                        lb = ub - this.I[i];
                        if (((IntVar[])this.vars)[i].updateUpperBound(this.divFloor(-ub + E, -this.c[i]), (ICause)this)) {
                            nlb = (long)((IntVar[])this.vars)[i].getUB() * this.c[i];
                            F2 -= nlb - lb;
                            this.I[i] = ub - nlb;
                            anychange = true;
                        }
                    }
                    if (this.maxI < this.I[i]) {
                        this.maxI = this.I[i];
                    }
                    ++i;
                }
            }
            if (F2 > 0L || E > 0L) continue;
            this.setPassive();
            return;
        } while (anychange);
    }

    @Override
    protected void filterOnLeq() throws ContradictionException {
        long F2 = this.b - this.sumLB;
        long E = this.sumUB - this.b;
        if (this.model.getSolver().isLearnOff() && F2 < 0L) {
            this.fails();
        }
        if (this.maxI > F2) {
            long nub;
            long ub;
            long lb;
            int i;
            this.maxI = 0L;
            for (i = 0; i < this.pos; ++i) {
                this.maxI = 0L;
                if (this.I[i] - F2 > 0L) {
                    lb = (long)((IntVar[])this.vars)[i].getLB() * this.c[i];
                    ub = lb + this.I[i];
                    if (((IntVar[])this.vars)[i].updateUpperBound(this.divFloor(F2 + lb, this.c[i]), (ICause)this)) {
                        nub = (long)((IntVar[])this.vars)[i].getUB() * this.c[i];
                        E += nub - ub;
                        this.I[i] = nub - lb;
                    }
                }
                if (this.maxI >= this.I[i]) continue;
                this.maxI = this.I[i];
            }
            while (i < this.l) {
                if (this.I[i] - F2 > 0L) {
                    lb = (long)((IntVar[])this.vars)[i].getUB() * this.c[i];
                    ub = lb + this.I[i];
                    if (((IntVar[])this.vars)[i].updateLowerBound(this.divCeil(-F2 - lb, -this.c[i]), (ICause)this)) {
                        nub = (long)((IntVar[])this.vars)[i].getLB() * this.c[i];
                        E += nub - ub;
                        this.I[i] = nub - lb;
                    }
                }
                if (this.maxI < this.I[i]) {
                    this.maxI = this.I[i];
                }
                ++i;
            }
        }
        if (E <= 0L) {
            this.setPassive();
        }
    }

    @Override
    protected void filterOnGeq() throws ContradictionException {
        long F2 = this.b - this.sumLB;
        long E = this.sumUB - this.b;
        if (this.model.getSolver().isLearnOff() && E < 0L) {
            this.fails();
        }
        if (this.maxI > E) {
            long nlb;
            long lb;
            long ub;
            int i;
            this.maxI = 0L;
            for (i = 0; i < this.pos; ++i) {
                if (this.I[i] - E > 0L) {
                    ub = (long)((IntVar[])this.vars)[i].getUB() * this.c[i];
                    lb = ub - this.I[i];
                    if (((IntVar[])this.vars)[i].updateLowerBound(this.divCeil(ub - E, this.c[i]), (ICause)this)) {
                        nlb = (long)((IntVar[])this.vars)[i].getLB() * this.c[i];
                        F2 -= nlb - lb;
                        this.I[i] = ub - nlb;
                    }
                }
                if (this.maxI >= this.I[i]) continue;
                this.maxI = this.I[i];
            }
            while (i < this.l) {
                if (this.I[i] - E > 0L) {
                    ub = (long)((IntVar[])this.vars)[i].getLB() * this.c[i];
                    lb = ub - this.I[i];
                    if (((IntVar[])this.vars)[i].updateUpperBound(this.divFloor(-ub + E, -this.c[i]), (ICause)this)) {
                        nlb = (long)((IntVar[])this.vars)[i].getUB() * this.c[i];
                        F2 -= nlb - lb;
                        this.I[i] = ub - nlb;
                    }
                }
                if (this.maxI < this.I[i]) {
                    this.maxI = this.I[i];
                }
                ++i;
            }
        }
        if (F2 <= 0L) {
            this.setPassive();
        }
    }

    @Override
    protected void filterOnNeq() throws ContradictionException {
        long F2 = this.b - this.sumLB;
        long E = this.sumUB - this.b;
        if (F2 < 0L || E < 0L) {
            this.setPassive();
            return;
        }
        int w = -1;
        long sum = 0L;
        for (int i = 0; i < this.l; ++i) {
            if (((IntVar[])this.vars)[i].isInstantiated()) {
                sum += (long)((IntVar[])this.vars)[i].getValue() * this.c[i];
                continue;
            }
            if (w == -1) {
                w = i;
                continue;
            }
            return;
        }
        if (w == -1) {
            if (sum == this.b) {
                this.fails();
            }
        } else if (this.c[w] != 0L && (this.b - sum) % this.c[w] == 0L) {
            ((IntVar[])this.vars)[w].removeValue((this.b - sum) / this.c[w], (ICause)this);
        }
    }

    @Override
    public ESat isEntailed() {
        int i;
        long sumUB = 0L;
        long sumLB = 0L;
        for (i = 0; i < this.pos; ++i) {
            sumLB += (long)((IntVar[])this.vars)[i].getLB() * this.c[i];
            sumUB += (long)((IntVar[])this.vars)[i].getUB() * this.c[i];
        }
        while (i < this.l) {
            sumLB += (long)((IntVar[])this.vars)[i].getUB() * this.c[i];
            sumUB += (long)((IntVar[])this.vars)[i].getLB() * this.c[i];
            ++i;
        }
        return this.check(sumLB, sumUB);
    }

    @Override
    public String toString() {
        int i;
        StringBuilder linComb = new StringBuilder(20);
        linComb.append(this.c[0]).append('.').append(((IntVar[])this.vars)[0].getName());
        for (i = 1; i < this.pos; ++i) {
            linComb.append(" + ").append(this.c[i]).append('.').append(((IntVar[])this.vars)[i].getName());
        }
        while (i < this.l) {
            linComb.append(" - ").append(-this.c[i]).append('.').append(((IntVar[])this.vars)[i].getName());
            ++i;
        }
        linComb.append(" ").append((Object)this.o).append(" ");
        linComb.append(this.b);
        return linComb.toString();
    }

    private long divFloor(long a2, long b) {
        if (a2 >= 0L) {
            return a2 / b;
        }
        return (a2 - b + 1L) / b;
    }

    private long divCeil(long a2, long b) {
        if (a2 >= 0L) {
            return (a2 + b - 1L) / b;
        }
        return a2 / b;
    }

    @Override
    protected PropScalarWithLong opposite() {
        return new PropScalarWithLong((IntVar[])this.vars, this.c, this.pos, PropScalarWithLong.nop(this.o), this.b + PropScalarWithLong.nb(this.o));
    }
}

