/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.qsar.descriptors.atomic;

import org.openscience.cdk.charges.Electronegativity;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.qsar.AbstractAtomicDescriptor;
import org.openscience.cdk.qsar.DescriptorSpecification;
import org.openscience.cdk.qsar.DescriptorValue;
import org.openscience.cdk.qsar.IAtomicDescriptor;
import org.openscience.cdk.qsar.result.DoubleResult;
import org.openscience.cdk.qsar.result.IDescriptorResult;
import org.openscience.cdk.tools.manipulator.AtomContainerManipulator;

public class SigmaElectronegativityDescriptor
extends AbstractAtomicDescriptor
implements IAtomicDescriptor {
    private int maxIterations = 0;
    private static final String[] NAMES = new String[]{"elecSigmA"};
    private final Electronegativity electronegativity = new Electronegativity();

    public DescriptorSpecification getSpecification() {
        return new DescriptorSpecification("http://www.blueobelisk.org/ontologies/chemoinformatics-algorithms/#sigmaElectronegativity", ((Object)((Object)this)).getClass().getName(), "The Chemistry Development Kit");
    }

    public void setParameters(Object[] params) throws CDKException {
        if (params.length > 1) {
            throw new CDKException("SigmaElectronegativityDescriptor only expects one parameter");
        }
        if (!(params[0] instanceof Integer)) {
            throw new CDKException("The parameter must be of type Integer");
        }
        if (params.length == 0) {
            return;
        }
        this.maxIterations = (Integer)params[0];
    }

    public Object[] getParameters() {
        Object[] params = new Object[]{this.maxIterations};
        return params;
    }

    public String[] getDescriptorNames() {
        return NAMES;
    }

    public DescriptorValue calculate(IAtom atom, IAtomContainer ac) {
        IAtom localAtom;
        IAtomContainer clone;
        try {
            clone = ac.clone();
            localAtom = clone.getAtom(ac.indexOf(atom));
            AtomContainerManipulator.percieveAtomTypesAndConfigureAtoms((IAtomContainer)clone);
        }
        catch (CloneNotSupportedException | CDKException e) {
            return new DescriptorValue(this.getSpecification(), this.getParameterNames(), this.getParameters(), (IDescriptorResult)new DoubleResult(Double.NaN), NAMES, (Exception)e);
        }
        if (this.maxIterations != -1 && this.maxIterations != 0) {
            this.electronegativity.setMaxIterations(this.maxIterations);
        }
        double result = this.electronegativity.calculateSigmaElectronegativity(clone, localAtom);
        return new DescriptorValue(this.getSpecification(), this.getParameterNames(), this.getParameters(), (IDescriptorResult)new DoubleResult(result), NAMES);
    }

    public String[] getParameterNames() {
        String[] params = new String[]{"maxIterations"};
        return params;
    }

    public Object getParameterType(String name) {
        return 0;
    }
}

