/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.optimization.cmaes.fitness;

import java.util.Random;

class Basis {
    double[][] B;
    Random rand = new Random(2L);

    Basis() {
    }

    double[] Rotate(double[] x) {
        this.GenBasis(x.length);
        double[] y = new double[x.length];
        int i = 0;
        while (i < x.length) {
            y[i] = 0.0;
            int j = 0;
            while (j < x.length) {
                int n = i;
                y[n] = y[n] + this.B[i][j] * x[j];
                ++j;
            }
            ++i;
        }
        return y;
    }

    double[][] Rotate(double[][] pop) {
        double[][] y = new double[pop.length][];
        int i = 0;
        while (i < pop.length) {
            y[i] = this.Rotate(pop[i]);
            ++i;
        }
        return y;
    }

    void GenBasis(int DIM) {
        if (this.B != null && this.B.length == DIM) {
            return;
        }
        this.B = new double[DIM][DIM];
        int i = 0;
        while (i < DIM) {
            int k;
            double sp;
            int j = 0;
            while (j < DIM) {
                this.B[i][j] = this.rand.nextGaussian();
                ++j;
            }
            j = i - 1;
            while (j >= 0) {
                sp = 0.0;
                k = 0;
                while (k < DIM) {
                    sp += this.B[i][k] * this.B[j][k];
                    ++k;
                }
                k = 0;
                while (k < DIM) {
                    double[] dArray = this.B[i];
                    int n = k;
                    dArray[n] = dArray[n] - sp * this.B[j][k];
                    ++k;
                }
                --j;
            }
            sp = 0.0;
            k = 0;
            while (k < DIM) {
                sp += this.B[i][k] * this.B[i][k];
                ++k;
            }
            k = 0;
            while (k < DIM) {
                double[] dArray = this.B[i];
                int n = k++;
                dArray[n] = dArray[n] / Math.sqrt(sp);
            }
            ++i;
        }
    }
}

