/*
 * Decompiled with CFR 0.152.
 */
package umontreal.iro.lecuyer.probdist;

import umontreal.iro.lecuyer.probdist.JohnsonSystem;
import umontreal.iro.lecuyer.probdist.NormalDist;

public class JohnsonSBDist
extends JohnsonSystem {
    private double m_psi = -1.0E100;

    private static double getMeanPsi(double gamma, double delta, double xi, double lambda, double[] tpsi) {
        int NMAX = 10000;
        double EPS = 1.0E-15;
        double a1 = 1.0 / (2.0 * delta * delta);
        double a2 = (1.0 - 2.0 * delta * gamma) / (2.0 * delta * delta);
        double a3 = (gamma - 1.0 / delta) / delta;
        int n = 0;
        double tem = 1.0;
        double sum = 0.0;
        while (Math.abs(tem) > 1.0E-15 * Math.abs(sum) && n < 10000) {
            double v = Math.exp((double)(-(++n)) * gamma / delta) + Math.exp((double)n * a3);
            tem = Math.exp((double)(-n * n) * a1) * v / (1.0 + Math.exp((double)(-2 * n) * a1));
            sum += tem;
        }
        if (n >= 10000) {
            System.err.println("JohnsonSBDist:  possible lack of accuracy on mean");
        }
        double A = (0.5 + sum) / delta;
        a1 = Math.PI * Math.PI * delta * delta;
        a2 = Math.PI * delta * gamma;
        n = 0;
        tem = 1.0;
        sum = 0.0;
        while (Math.abs(tem) > 1.0E-15 * Math.abs(sum) && n < 10000) {
            int j = 2 * ++n - 1;
            tem = Math.exp((double)(-j * j) * a1 / 2.0) * Math.sin((double)j * a2) / Math.sinh((double)j * a1);
            sum += tem;
        }
        if (n >= 10000) {
            System.err.println("JohnsonSBDist:  possible lack of accuracy on mean");
        }
        double B = Math.PI * 2 * delta * sum;
        a1 = 19.739208802178716 * delta * delta;
        a2 = Math.PI * 2 * delta * gamma;
        n = 0;
        tem = 1.0;
        sum = 0.0;
        while (Math.abs(tem) > 1.0E-15 * Math.abs(sum) && n < 10000) {
            tem = Math.exp((double)(-(++n) * n) * a1) * Math.cos((double)n * a2);
            sum += tem;
        }
        if (n >= 10000) {
            System.err.println("JohnsonSBDist:  possible lack of accuracy on mean");
        }
        double C = 1.0 + 2.0 * sum;
        double D = Math.sqrt(Math.PI * 2) * Math.exp(gamma * gamma / 2.0);
        double tmean = (A - B) / (C * D);
        tpsi[0] = C * D;
        return tmean;
    }

    public JohnsonSBDist(double gamma, double delta, double xi, double lambda) {
        super(gamma, delta, xi, lambda);
        this.setLastParams(xi, lambda);
    }

    private void setLastParams(double xi, double lambda) {
        this.supportA = xi;
        this.supportB = xi + lambda;
    }

    public double density(double x) {
        return JohnsonSBDist.density(this.gamma, this.delta, this.xi, this.lambda, x);
    }

    public double cdf(double x) {
        return JohnsonSBDist.cdf(this.gamma, this.delta, this.xi, this.lambda, x);
    }

    public double barF(double x) {
        return JohnsonSBDist.barF(this.gamma, this.delta, this.xi, this.lambda, x);
    }

    public double inverseF(double u) {
        return JohnsonSBDist.inverseF(this.gamma, this.delta, this.xi, this.lambda, u);
    }

    public double getMean() {
        return JohnsonSBDist.getMean(this.gamma, this.delta, this.xi, this.lambda);
    }

    public double getVariance() {
        return JohnsonSBDist.getVariance(this.gamma, this.delta, this.xi, this.lambda);
    }

    public double getStandardDeviation() {
        return JohnsonSBDist.getStandardDeviation(this.gamma, this.delta, this.xi, this.lambda);
    }

    public static double density(double gamma, double delta, double xi, double lambda, double x) {
        if (lambda <= 0.0) {
            throw new IllegalArgumentException("lambda <= 0");
        }
        if (delta <= 0.0) {
            throw new IllegalArgumentException("delta <= 0");
        }
        if (x <= xi || x >= xi + lambda) {
            return 0.0;
        }
        double y = (x - xi) / lambda;
        double z = gamma + delta * Math.log(y / (1.0 - y));
        return delta / (lambda * y * (1.0 - y) * Math.sqrt(Math.PI * 2)) * Math.exp(-z * z / 2.0);
    }

    public static double cdf(double gamma, double delta, double xi, double lambda, double x) {
        if (lambda <= 0.0) {
            throw new IllegalArgumentException("lambda <= 0");
        }
        if (delta <= 0.0) {
            throw new IllegalArgumentException("delta <= 0");
        }
        if (x <= xi) {
            return 0.0;
        }
        if (x >= xi + lambda) {
            return 1.0;
        }
        double y = (x - xi) / lambda;
        double z = gamma + delta * Math.log(y / (1.0 - y));
        return NormalDist.cdf01(z);
    }

    public static double barF(double gamma, double delta, double xi, double lambda, double x) {
        if (lambda <= 0.0) {
            throw new IllegalArgumentException("lambda <= 0");
        }
        if (delta <= 0.0) {
            throw new IllegalArgumentException("delta <= 0");
        }
        if (x <= xi) {
            return 1.0;
        }
        if (x >= xi + lambda) {
            return 0.0;
        }
        double y = (x - xi) / lambda;
        double z = gamma + delta * Math.log(y / (1.0 - y));
        return NormalDist.barF01(z);
    }

    public static double inverseF(double gamma, double delta, double xi, double lambda, double u) {
        if (lambda <= 0.0) {
            throw new IllegalArgumentException("lambda <= 0");
        }
        if (delta <= 0.0) {
            throw new IllegalArgumentException("delta <= 0");
        }
        if (u > 1.0 || u < 0.0) {
            throw new IllegalArgumentException("u not in [0,1]");
        }
        if (u >= 1.0) {
            return xi + lambda;
        }
        if (u <= 0.0) {
            return xi;
        }
        double z = NormalDist.inverseF01(u);
        double v = (z - gamma) / delta;
        if (v >= 709.782712893384) {
            return xi + lambda;
        }
        if (v <= -707.7032713517042) {
            return xi;
        }
        v = Math.exp(v);
        return (xi + (xi + lambda) * v) / (1.0 + v);
    }

    public static double[] getMLE(double[] x, int n, double xi, double lambda) {
        double t;
        if (n <= 0) {
            throw new IllegalArgumentException("n <= 0");
        }
        double LN_EPS = -709.089565712824;
        double[] ftab = new double[n];
        double sum = 0.0;
        for (int i = 0; i < n; ++i) {
            t = (x[i] - xi) / lambda;
            ftab[i] = t <= 0.0 ? -709.089565712824 : (t >= 0.9999999999999998 ? Math.log(4.503599627370496E15) : Math.log(t / (1.0 - t)));
            sum += ftab[i];
        }
        double empiricalMean = sum / (double)n;
        sum = 0.0;
        for (int i = 0; i < n; ++i) {
            t = ftab[i] - empiricalMean;
            sum += t * t;
        }
        double sigmaf = Math.sqrt(sum / (double)n);
        double[] param = new double[]{-empiricalMean / sigmaf, 1.0 / sigmaf};
        return param;
    }

    public static JohnsonSBDist getInstanceFromMLE(double[] x, int n, double xi, double lambda) {
        double[] parameters = JohnsonSBDist.getMLE(x, n, xi, lambda);
        return new JohnsonSBDist(parameters[0], parameters[1], xi, lambda);
    }

    public static double getMean(double gamma, double delta, double xi, double lambda) {
        if (lambda <= 0.0) {
            throw new IllegalArgumentException("lambda <= 0");
        }
        if (delta <= 0.0) {
            throw new IllegalArgumentException("delta <= 0");
        }
        double[] tpsi = new double[1];
        double mu = JohnsonSBDist.getMeanPsi(gamma, delta, xi, lambda, tpsi);
        return xi + lambda * mu;
    }

    public static double getVariance(double gamma, double delta, double xi, double lambda) {
        if (lambda <= 0.0) {
            throw new IllegalArgumentException("lambda <= 0");
        }
        if (delta <= 0.0) {
            throw new IllegalArgumentException("delta <= 0");
        }
        int NMAX = 10000;
        double EPS = 1.0E-15;
        double a1 = 1.0 / (2.0 * delta * delta);
        double a2 = (1.0 - 2.0 * delta * gamma) / (2.0 * delta * delta);
        double a3 = (gamma - 1.0 / delta) / delta;
        int n = 0;
        double tem = 1.0;
        double sum = 0.0;
        while (Math.abs(tem) > 1.0E-15 * Math.abs(sum) && n < 10000) {
            double v = Math.exp((double)(-(++n)) * gamma / delta) - Math.exp((double)n * a3);
            tem = (double)n * Math.exp((double)(-n * n) * a1) * v / (1.0 + Math.exp((double)(-2 * n) * a1));
            sum += tem;
        }
        if (n >= 10000) {
            System.err.println("JohnsonSBDist:  possible lack of accuracy on variance");
        }
        double A = -sum / (delta * delta);
        a1 = Math.PI * Math.PI * delta * delta;
        a2 = Math.PI * delta * gamma;
        n = 0;
        tem = 1.0;
        sum = 0.0;
        while (Math.abs(tem) > 1.0E-15 * Math.abs(sum) && n < 10000) {
            int j = 2 * ++n - 1;
            tem = (double)j * Math.exp((double)(-j * j) * a1 / 2.0) * Math.cos((double)j * a2) / Math.sinh((double)j * a1);
            sum += tem;
        }
        if (n >= 10000) {
            System.err.println("JohnsonSBDist:  possible lack of accuracy on variance");
        }
        double B = 2.0 * a1 * sum;
        a1 = 19.739208802178716 * delta * delta;
        a2 = Math.PI * 2 * delta * gamma;
        n = 0;
        tem = 1.0;
        sum = 0.0;
        while (Math.abs(tem) > 1.0E-15 * Math.abs(sum) && n < 10000) {
            tem = (double)(++n) * Math.exp((double)(-n * n) * a1) * Math.sin((double)n * a2);
            sum += tem;
        }
        if (n >= 10000) {
            System.err.println("JohnsonSBDist:  possible lack of accuracy on variance");
        }
        double C = Math.PI * -4 * delta * sum;
        double D = Math.sqrt(Math.PI * 2) * Math.exp(0.5 * gamma * gamma);
        double[] tpsi = new double[1];
        double mu = JohnsonSBDist.getMeanPsi(gamma, delta, xi, lambda, tpsi);
        double tvar = mu * (1.0 - delta * gamma) - mu * mu + delta / tpsi[0] * (A - B - mu * C * D);
        return lambda * lambda * tvar;
    }

    public static double getStandardDeviation(double gamma, double delta, double xi, double lambda) {
        return Math.sqrt(JohnsonSBDist.getVariance(gamma, delta, xi, lambda));
    }

    public void setParams(double gamma, double delta, double xi, double lambda) {
        this.setParams0(gamma, delta, xi, lambda);
        this.setLastParams(xi, lambda);
    }
}

