/*
 * Decompiled with CFR 0.152.
 */
package gov.nih.nlm.ncbi.www.soap.eutils.esearch;

import de.hzi.infg.interfaces.TypeInterface;
import gov.nih.nlm.ncbi.www.soap.eutils.esearch.TermSetType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.apache.axiom.om.OMDataSource;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.impl.llom.OMSourcedElementImpl;
import org.apache.axis2.databinding.ADBBean;
import org.apache.axis2.databinding.ADBDataSource;
import org.apache.axis2.databinding.ADBException;
import org.apache.axis2.databinding.utils.BeanUtil;
import org.apache.axis2.databinding.utils.ConverterUtil;
import org.apache.axis2.databinding.utils.reader.ADBXMLStreamReaderImpl;
import org.apache.axis2.databinding.utils.writer.MTOMAwareXMLStreamWriter;

public class TranslationStackTypeChoice
implements ADBBean,
TypeInterface {
    private static final long serialVersionUID = -6829545895890895257L;
    protected TermSetType localTermSet;
    protected boolean localTermSetTracker = false;
    protected String localOP;
    protected boolean localOPTracker = false;

    private static String generatePrefix(String namespace) {
        if (namespace.equals("http://www.ncbi.nlm.nih.gov/soap/eutils/esearch")) {
            return "ns3";
        }
        return BeanUtil.getUniquePrefix();
    }

    private void clearAllSettingTrackers() {
        this.localTermSetTracker = false;
        this.localOPTracker = false;
    }

    public TermSetType getTermSet() {
        return this.localTermSet;
    }

    public void setTermSet(TermSetType param) {
        this.clearAllSettingTrackers();
        this.localTermSetTracker = param != null;
        this.localTermSet = param;
    }

    public String getOP() {
        return this.localOP;
    }

    public void setOP(String param) {
        this.clearAllSettingTrackers();
        this.localOPTracker = param != null;
        this.localOP = param;
    }

    public static boolean isReaderMTOMAware(XMLStreamReader reader) {
        boolean isReaderMTOMAware = false;
        try {
            isReaderMTOMAware = Boolean.TRUE.equals(reader.getProperty("IsDatahandlersAwareParsing"));
        }
        catch (IllegalArgumentException e) {
            isReaderMTOMAware = false;
        }
        return isReaderMTOMAware;
    }

    public OMElement getOMElement(QName parentQName, final OMFactory factory) throws ADBException {
        ADBDataSource dataSource = new ADBDataSource(this, parentQName){

            public void serialize(MTOMAwareXMLStreamWriter xmlWriter) throws XMLStreamException {
                TranslationStackTypeChoice.this.serialize(this.parentQName, factory, xmlWriter);
            }
        };
        return new OMSourcedElementImpl(parentQName, factory, (OMDataSource)dataSource);
    }

    public void serialize(QName parentQName, OMFactory factory, MTOMAwareXMLStreamWriter xmlWriter) throws XMLStreamException, ADBException {
        this.serialize(parentQName, factory, xmlWriter, false);
    }

    public void serialize(QName parentQName, OMFactory factory, MTOMAwareXMLStreamWriter xmlWriter, boolean serializeType) throws XMLStreamException, ADBException {
        String prefix = null;
        String namespace = null;
        if (serializeType) {
            String namespacePrefix = this.registerPrefix((XMLStreamWriter)xmlWriter, "http://www.ncbi.nlm.nih.gov/soap/eutils/esearch");
            if (namespacePrefix != null && namespacePrefix.trim().length() > 0) {
                this.writeAttribute("xsi", "http://www.w3.org/2001/XMLSchema-instance", "type", String.valueOf(namespacePrefix) + ":TranslationStackTypeChoice", (XMLStreamWriter)xmlWriter);
            } else {
                this.writeAttribute("xsi", "http://www.w3.org/2001/XMLSchema-instance", "type", "TranslationStackTypeChoice", (XMLStreamWriter)xmlWriter);
            }
        }
        if (this.localTermSetTracker) {
            if (this.localTermSet == null) {
                throw new ADBException("TermSet cannot be null!!");
            }
            this.localTermSet.serialize(new QName("http://www.ncbi.nlm.nih.gov/soap/eutils/esearch", "TermSet"), factory, xmlWriter);
        }
        if (this.localOPTracker) {
            namespace = "http://www.ncbi.nlm.nih.gov/soap/eutils/esearch";
            if (!namespace.equals("")) {
                prefix = xmlWriter.getPrefix(namespace);
                if (prefix == null) {
                    prefix = TranslationStackTypeChoice.generatePrefix(namespace);
                    xmlWriter.writeStartElement(prefix, "OP", namespace);
                    xmlWriter.writeNamespace(prefix, namespace);
                    xmlWriter.setPrefix(prefix, namespace);
                } else {
                    xmlWriter.writeStartElement(namespace, "OP");
                }
            } else {
                xmlWriter.writeStartElement("OP");
            }
            if (this.localOP == null) {
                throw new ADBException("OP cannot be null!!");
            }
            xmlWriter.writeCharacters(this.localOP);
            xmlWriter.writeEndElement();
        }
    }

    private void writeAttribute(String prefix, String namespace, String attName, String attValue, XMLStreamWriter xmlWriter) throws XMLStreamException {
        if (xmlWriter.getPrefix(namespace) == null) {
            xmlWriter.writeNamespace(prefix, namespace);
            xmlWriter.setPrefix(prefix, namespace);
        }
        xmlWriter.writeAttribute(namespace, attName, attValue);
    }

    private String registerPrefix(XMLStreamWriter xmlWriter, String namespace) throws XMLStreamException {
        String prefix = xmlWriter.getPrefix(namespace);
        if (prefix == null) {
            prefix = TranslationStackTypeChoice.generatePrefix(namespace);
            while (xmlWriter.getNamespaceContext().getNamespaceURI(prefix) != null) {
                prefix = BeanUtil.getUniquePrefix();
            }
            xmlWriter.writeNamespace(prefix, namespace);
            xmlWriter.setPrefix(prefix, namespace);
        }
        return prefix;
    }

    public XMLStreamReader getPullParser(QName qName) throws ADBException {
        ArrayList<Object> elementList = new ArrayList<Object>();
        ArrayList attribList = new ArrayList();
        if (this.localTermSetTracker) {
            elementList.add(new QName("http://www.ncbi.nlm.nih.gov/soap/eutils/esearch", "TermSet"));
            if (this.localTermSet == null) {
                throw new ADBException("TermSet cannot be null!!");
            }
            elementList.add(this.localTermSet);
        }
        if (this.localOPTracker) {
            elementList.add(new QName("http://www.ncbi.nlm.nih.gov/soap/eutils/esearch", "OP"));
            if (this.localOP != null) {
                elementList.add(ConverterUtil.convertToString((String)this.localOP));
            } else {
                throw new ADBException("OP cannot be null!!");
            }
        }
        return new ADBXMLStreamReaderImpl(qName, elementList.toArray(), attribList.toArray());
    }

    public Map<String, Object> getParametersMap() {
        HashMap<String, Object> returnMap = new HashMap<String, Object>();
        returnMap.put("op", this.localOP);
        returnMap.put("termset", this.localTermSet);
        return returnMap;
    }

    public static class Factory {
        public static TranslationStackTypeChoice parse(XMLStreamReader reader) throws Exception {
            TranslationStackTypeChoice object = new TranslationStackTypeChoice();
            try {
                while (!reader.isStartElement() && !reader.isEndElement()) {
                    reader.next();
                }
                if (reader.isStartElement() && new QName("http://www.ncbi.nlm.nih.gov/soap/eutils/esearch", "TermSet").equals(reader.getName())) {
                    object.setTermSet(TermSetType.Factory.parse(reader));
                    reader.next();
                } else if (reader.isStartElement() && new QName("http://www.ncbi.nlm.nih.gov/soap/eutils/esearch", "OP").equals(reader.getName())) {
                    String content = reader.getElementText();
                    object.setOP(ConverterUtil.convertToString((String)content));
                    reader.next();
                }
            }
            catch (XMLStreamException e) {
                throw new Exception(e);
            }
            return object;
        }
    }
}

