/*
 * Decompiled with CFR 0.152.
 */
package moa.clusterers.streamkm;

import moa.clusterers.streamkm.MTRandom;
import moa.clusterers.streamkm.Point;

public class TreeCoreset {
    double treeNodeSplitCost(treeNode node, Point centreA, Point centreB) {
        double sum = 0.0;
        for (int i = 0; i < node.n; ++i) {
            int l;
            double distanceA = 0.0;
            for (l = 0; l < node.points[i].dimension; ++l) {
                double centroidCoordinatePoint = node.points[i].weight != 0.0 ? node.points[i].coordinates[l] / node.points[i].weight : node.points[i].coordinates[l];
                double centroidCoordinateCentre = centreA.weight != 0.0 ? centreA.coordinates[l] / centreA.weight : centreA.coordinates[l];
                distanceA += (centroidCoordinatePoint - centroidCoordinateCentre) * (centroidCoordinatePoint - centroidCoordinateCentre);
            }
            double distanceB = 0.0;
            for (l = 0; l < node.points[i].dimension; ++l) {
                double centroidCoordinatePoint = node.points[i].weight != 0.0 ? node.points[i].coordinates[l] / node.points[i].weight : node.points[i].coordinates[l];
                double centroidCoordinateCentre = centreB.weight != 0.0 ? centreB.coordinates[l] / centreB.weight : centreB.coordinates[l];
                distanceB += (centroidCoordinatePoint - centroidCoordinateCentre) * (centroidCoordinatePoint - centroidCoordinateCentre);
            }
            if (distanceA < distanceB) {
                sum += distanceA * node.points[i].weight;
                continue;
            }
            sum += distanceB * node.points[i].weight;
        }
        return sum;
    }

    double treeNodeCostOfPoint(treeNode node, Point p) {
        if (p.weight == 0.0) {
            return 0.0;
        }
        double distance = 0.0;
        for (int l = 0; l < p.dimension; ++l) {
            double centroidCoordinatePoint = p.weight != 0.0 ? p.coordinates[l] / p.weight : p.coordinates[l];
            double centroidCoordinateCentre = node.centre.weight != 0.0 ? node.centre.coordinates[l] / node.centre.weight : node.centre.coordinates[l];
            distance += (centroidCoordinatePoint - centroidCoordinateCentre) * (centroidCoordinatePoint - centroidCoordinateCentre);
        }
        return distance * p.weight;
    }

    boolean isLeaf(treeNode node) {
        return node.lc == null && node.rc == null;
    }

    treeNode selectNode(treeNode root, MTRandom clustererRandom) {
        double random = clustererRandom.nextDouble();
        while (!this.isLeaf(root)) {
            if (root.lc.cost == 0.0 && root.rc.cost == 0.0) {
                if (root.lc.n == 0) {
                    root = root.rc;
                    continue;
                }
                if (root.rc.n == 0) {
                    root = root.lc;
                    continue;
                }
                if (random < 0.5) {
                    random = clustererRandom.nextDouble();
                    root = root.lc;
                    continue;
                }
                random = clustererRandom.nextDouble();
                root = root.rc;
                continue;
            }
            if (random < root.lc.cost / root.cost) {
                root = root.lc;
                continue;
            }
            root = root.rc;
        }
        return root;
    }

    Point chooseCentre(treeNode node, MTRandom clustererRandom) {
        int times = 3;
        double minCost = node.cost;
        Point bestCentre = null;
        block0: for (int j = 0; j < times; ++j) {
            double sum = 0.0;
            double random = clustererRandom.nextDouble();
            for (int i = 0; i < node.n; ++i) {
                if (!((sum += this.treeNodeCostOfPoint(node, node.points[i]) / node.cost) >= random)) continue;
                if (node.points[i].weight == 0.0) {
                    return null;
                }
                double curCost = this.treeNodeSplitCost(node, node.centre, node.points[i]);
                if (!(curCost < minCost)) continue block0;
                bestCentre = node.points[i];
                minCost = curCost;
                continue block0;
            }
        }
        if (bestCentre == null) {
            return node.points[0];
        }
        return bestCentre;
    }

    Point determineClosestCentre(Point p, Point centreA, Point centreB) {
        int l;
        double distanceA = 0.0;
        for (l = 0; l < p.dimension; ++l) {
            double centroidCoordinatePoint = p.weight != 0.0 ? p.coordinates[l] / p.weight : p.coordinates[l];
            double centroidCoordinateCentre = centreA.weight != 0.0 ? centreA.coordinates[l] / centreA.weight : centreA.coordinates[l];
            distanceA += (centroidCoordinatePoint - centroidCoordinateCentre) * (centroidCoordinatePoint - centroidCoordinateCentre);
        }
        double distanceB = 0.0;
        for (l = 0; l < p.dimension; ++l) {
            double centroidCoordinatePoint = p.weight != 0.0 ? p.coordinates[l] / p.weight : p.coordinates[l];
            double centroidCoordinateCentre = centreB.weight != 0.0 ? centreB.coordinates[l] / centreB.weight : centreB.coordinates[l];
            distanceB += (centroidCoordinatePoint - centroidCoordinateCentre) * (centroidCoordinatePoint - centroidCoordinateCentre);
        }
        if (distanceA < distanceB) {
            return centreA;
        }
        return centreB;
    }

    void split(treeNode parent, Point newCentre, int newCentreIndex) {
        int i;
        int nOld = 0;
        int nNew = 0;
        for (i = 0; i < parent.n; ++i) {
            Point centre = this.determineClosestCentre(parent.points[i], parent.centre, newCentre);
            if (centre == newCentre) {
                ++nNew;
                continue;
            }
            ++nOld;
        }
        Point[] oldPoints = new Point[nOld];
        Point[] newPoints = new Point[nNew];
        int indexOld = 0;
        int indexNew = 0;
        for (i = 0; i < parent.n; ++i) {
            Point centre = this.determineClosestCentre(parent.points[i], parent.centre, newCentre);
            if (centre == newCentre) {
                newPoints[indexNew] = parent.points[i];
                newPoints[indexNew].centreIndex = newCentreIndex;
                ++indexNew;
                continue;
            }
            if (centre != parent.centre) continue;
            oldPoints[indexOld] = parent.points[i];
            ++indexOld;
        }
        treeNode lc = new treeNode(nOld, oldPoints, parent.centre, parent);
        treeNode rc = new treeNode(nNew, newPoints, newCentre, parent);
        parent.lc = lc;
        parent.rc = rc;
        while (parent != null) {
            parent.cost = parent.lc.cost + parent.rc.cost;
            parent = parent.parent;
        }
    }

    boolean treeFinished(treeNode root) {
        return root.parent == null && root.lc == null && root.rc == null;
    }

    void freeTree(treeNode root) {
        while (!this.treeFinished(root)) {
            if (root.lc == null && root.rc == null) {
                root = root.parent;
                continue;
            }
            if (root.lc == null && root.rc != null) {
                if (this.isLeaf(root.rc)) {
                    root.rc.free();
                    root.rc = null;
                    continue;
                }
                root = root.rc;
                continue;
            }
            if (root.lc == null) continue;
            if (this.isLeaf(root.lc)) {
                root.lc.free();
                root.lc = null;
                continue;
            }
            root = root.lc;
        }
        root.free();
    }

    void unionTreeCoreset(int k, int n_1, int n_2, int d, Point[] setA, Point[] setB, Point[] centres, MTRandom clustererRandom) {
        int n = n_1 + n_2;
        int choosenPoints = 0;
        int j = clustererRandom.nextInt(n - choosenPoints);
        centres[choosenPoints] = j < n_1 ? setA[j].clone() : setB[j -= n_1].clone();
        treeNode root = new treeNode(setA, setB, n_1, n_2, centres[choosenPoints], choosenPoints);
        for (choosenPoints = 1; choosenPoints < k; ++choosenPoints) {
            if (root.cost > 0.0) {
                treeNode leaf = this.selectNode(root, clustererRandom);
                Point centre = this.chooseCentre(leaf, clustererRandom);
                this.split(leaf, centre, choosenPoints);
                centres[choosenPoints] = centre;
                continue;
            }
            centres[choosenPoints] = root.centre;
            for (int l = 0; l < root.centre.dimension; ++l) {
                centres[choosenPoints].coordinates[l] = -1000000.0;
            }
            centres[choosenPoints].id = -1;
            centres[choosenPoints].weight = 0.0;
            centres[choosenPoints].squareSum = 0.0;
        }
        this.freeTree(root);
        for (int i = 0; i < n; ++i) {
            int l;
            int index;
            if (i < n_1) {
                index = setA[i].centreIndex;
                if (centres[index].id == setA[i].id) continue;
                centres[index].weight += setA[i].weight;
                centres[index].squareSum += setA[i].squareSum;
                for (l = 0; l < centres[index].dimension; ++l) {
                    if (setA[i].weight == 0.0) continue;
                    int n2 = l;
                    centres[index].coordinates[n2] = centres[index].coordinates[n2] + setA[i].coordinates[l];
                }
                continue;
            }
            index = setB[i - n_1].centreIndex;
            if (centres[index].id == setB[i - n_1].id) continue;
            centres[index].weight += setB[i - n_1].weight;
            centres[index].squareSum += setB[i - n_1].squareSum;
            for (l = 0; l < centres[index].dimension; ++l) {
                if (setB[i - n_1].weight == 0.0) continue;
                int n3 = l;
                centres[index].coordinates[n3] = centres[index].coordinates[n3] + setB[i - n_1].coordinates[l];
            }
        }
    }

    protected class treeNode {
        int n;
        Point[] points;
        Point centre;
        treeNode lc;
        treeNode rc;
        treeNode parent;
        double cost;

        void free() {
            this.parent = null;
            this.lc = null;
            this.rc = null;
            this.points = null;
            this.centre = null;
        }

        public treeNode(int n, Point[] points, Point centre, treeNode parent) {
            this.n = n;
            this.points = points;
            this.centre = centre;
            this.lc = null;
            this.rc = null;
            this.parent = parent;
            this.cost = this.treeNodeTargetFunctionValue();
        }

        public treeNode(Point[] setA, Point[] setB, int n_1, int n_2, Point centre, int centreIndex) {
            this.parent = null;
            this.lc = null;
            this.rc = null;
            this.points = new Point[n_1 + n_2];
            this.n = n_1 + n_2;
            for (int i = 0; i < this.n; ++i) {
                if (i < n_1) {
                    this.points[i] = setA[i];
                    this.points[i].centreIndex = centreIndex;
                    continue;
                }
                this.points[i] = setB[i - n_1];
                this.points[i].centreIndex = centreIndex;
            }
            this.centre = centre;
            this.cost = this.treeNodeTargetFunctionValue();
        }

        double treeNodeTargetFunctionValue() {
            double sum = 0.0;
            for (int i = 0; i < this.n; ++i) {
                double distance = 0.0;
                for (int l = 0; l < this.points[i].dimension; ++l) {
                    double centroidCoordinatePoint = this.points[i].weight != 0.0 ? this.points[i].coordinates[l] / this.points[i].weight : this.points[i].coordinates[l];
                    double centroidCoordinateCentre = this.centre.weight != 0.0 ? this.centre.coordinates[l] / this.centre.weight : this.centre.coordinates[l];
                    distance += (centroidCoordinatePoint - centroidCoordinateCentre) * (centroidCoordinatePoint - centroidCoordinateCentre);
                }
                sum += distance * this.points[i].weight;
            }
            return sum;
        }
    }
}

