/*
 * Decompiled with CFR 0.152.
 */
package keel.Algorithms.Instance_Generation.BTS3;

import keel.Algorithms.Instance_Generation.Basic.Prototype;
import keel.Algorithms.Instance_Generation.Basic.PrototypeGenerationAlgorithm;
import keel.Algorithms.Instance_Generation.Basic.PrototypeGenerator;
import keel.Algorithms.Instance_Generation.Basic.PrototypeSet;
import keel.Algorithms.Instance_Generation.utilities.KNN.KNN;
import keel.Algorithms.Instance_Generation.utilities.Parameters;

public class BTS3Generator
extends PrototypeGenerator {
    protected int numberOfPrototypesGenerated = 5;
    protected int randomTrials = 10;
    protected int nearestNeighbors = 1;

    public BTS3Generator(PrototypeSet _trainingDataSet, Parameters parameters) {
        super(_trainingDataSet, parameters);
        this.algorithmName = "BTS3";
        this.numberOfPrototypesGenerated = this.getSetSizeFromPercentage(parameters.getNextAsDouble());
        this.nearestNeighbors = parameters.getNextAsInt();
        this.randomTrials = parameters.getNextAsInt();
    }

    public BTS3Generator(PrototypeSet _trainingDataSet, int Np, int nearestNeighbors, int trials) {
        super(_trainingDataSet);
        this.algorithmName = "BTS3";
        this.numberOfPrototypesGenerated = Np;
        this.nearestNeighbors = nearestNeighbors;
        this.randomTrials = trials;
    }

    public BTS3Generator(PrototypeSet _trainingDataSet, double percSize, int nearestNeighbors, int trials) {
        super(_trainingDataSet);
        this.algorithmName = "BTS3";
        this.numberOfPrototypesGenerated = this.getSetSizeFromPercentage(percSize);
        this.nearestNeighbors = nearestNeighbors;
        this.randomTrials = trials;
    }

    PrototypeSet mergePrototypesWithNNMethod(PrototypeSet original) {
        PrototypeSet merged = new PrototypeSet();
        for (Prototype p : original) {
            PrototypeSet neighborsOfP = KNN.getNearestNeighborsWithSameClassAs(p, original, this.nearestNeighbors);
            neighborsOfP.add(p);
            Prototype mixed = neighborsOfP.avg().formatear();
            merged.add(mixed);
        }
        return merged;
    }

    @Override
    public PrototypeSet reduceSet() {
        boolean useApriori = true;
        PrototypeSet best = null;
        int bestAccuracy = -1;
        for (int i = 0; i < this.randomTrials; ++i) {
            PrototypeSet selected = super.selecRandomSet(this.numberOfPrototypesGenerated, useApriori);
            PrototypeSet merged = this.mergePrototypesWithNNMethod(selected);
            PrototypeSet finalSet = new PrototypeSet();
            for (Prototype p : merged) {
                Prototype nearest = KNN._1nn(p, this.trainingDataSet);
                finalSet.add(nearest);
            }
            int finalSetAccuracy = BTS3Generator.absoluteAccuracy(finalSet, this.trainingDataSet);
            if (finalSetAccuracy <= bestAccuracy) continue;
            bestAccuracy = finalSetAccuracy;
            best = finalSet;
        }
        return best;
    }

    public static void main(String[] args) {
        Parameters.setUse("BTS3", "<seed> <percentage of prototypes generated> <Nearest-neightbors (size of the merged sets)> <random trials>");
        Parameters.assertBasicArgs(args);
        PrototypeSet training = PrototypeGenerationAlgorithm.readPrototypeSet(args[0]);
        PrototypeSet test = PrototypeGenerationAlgorithm.readPrototypeSet(args[1]);
        long seed = Parameters.assertExtendedArgAsInt(args, 2, "seed", 0.0, 9.223372036854776E18);
        BTS3Generator.setSeed(seed);
        double percNprot = Parameters.assertExtendedArgAsDouble(args, 3, "reduction size respect training size", 0.0, 100.0);
        int k = Parameters.assertExtendedArgAsInt(args, 4, "Nearest-neighbors used in the merging process", 1.0, 5.0);
        int randomTrials = Parameters.assertExtendedArgAsInt(args, 5, "number of random trials", 1.0, 2.147483647E9);
        BTS3Generator generator = new BTS3Generator(training, percNprot, k, randomTrials);
        PrototypeSet resultingSet = generator.execute();
        int accuracy1NN = KNN.classficationAccuracy(resultingSet, test);
        generator.showResultsOfAccuracy(Parameters.getFileName(), accuracy1NN, test);
    }
}

