/*
 * Decompiled with CFR 0.152.
 */
package keel.Algorithms.Shared.ClassicalOptim;

import keel.Algorithms.Shared.ClassicalOptim.FUN;
import keel.Algorithms.Shared.ClassicalOptim.LinearSearchBrent;
import keel.Algorithms.Shared.ClassicalOptim.OPV;
import org.core.Randomize;

public class ConjGradQUAD {
    int nLayers;
    int nInputs;
    int nOutputs;
    int[] nElements;
    double[][] inputs;
    double[][] outputs;
    static Randomize r;

    public ConjGradQUAD(double[][] vInput, double[][] vOutput, Randomize pr) {
        r = pr;
        this.inputs = ConjGradQUAD.duplicate(vInput);
        this.outputs = ConjGradQUAD.duplicate(vOutput);
        this.nInputs = vInput[0].length;
        this.nOutputs = vOutput[0].length;
        System.out.println("Entradas=" + this.nInputs + " Salidas=" + this.nOutputs);
    }

    double[][][] numericalGradient(FUN f, double[][][] x) {
        int k;
        int j;
        int i;
        double h = 0.1f;
        double[][][] result = new double[x.length][x[0].length][x[0][0].length];
        double[][][] fplus = new double[x.length][x[0].length][x[0][0].length];
        double[][][] fminus = new double[x.length][x[0].length][x[0][0].length];
        double[][][] copyx = new double[x.length][x[0].length][x[0][0].length];
        for (i = 0; i < x.length; ++i) {
            for (j = 0; j < x[i].length; ++j) {
                for (k = 0; k < x[i][j].length; ++k) {
                    copyx[i][j][k] = x[i][j][k];
                }
            }
        }
        for (i = 0; i < x.length; ++i) {
            for (j = 0; j < x[i].length; ++j) {
                for (k = 0; k < x[i][j].length; ++k) {
                    double[] dArray = copyx[i][j];
                    int n = k;
                    dArray[n] = dArray[n] + h;
                    fplus[i][j][k] = f.evaluate(copyx);
                    double[] dArray2 = copyx[i][j];
                    int n2 = k;
                    dArray2[n2] = dArray2[n2] - 2.0 * h;
                    fminus[i][j][k] = f.evaluate(copyx);
                    copyx[i][j][k] = x[i][j][k];
                    result[i][j][k] = (fplus[i][j][k] - fminus[i][j][k]) / (2.0 * h);
                }
            }
        }
        return result;
    }

    private void copy(double[] org, int size, double[] dst) {
        for (int i = 0; i < size; ++i) {
            dst[i] = org[i];
        }
    }

    public static double[] duplicate(double[] x) {
        double[] r = new double[x.length];
        for (int i = 0; i < x.length; ++i) {
            r[i] = x[i];
        }
        return r;
    }

    public static double[][] duplicate(double[][] x) {
        double[][] r = new double[x.length][];
        for (int i = 0; i < x.length; ++i) {
            r[i] = new double[x[i].length];
            for (int j = 0; j < x[i].length; ++j) {
                r[i][j] = x[i][j];
            }
        }
        return r;
    }

    public static double[][][] duplicate(double[][][] x) {
        double[][][] r = new double[x.length][][];
        for (int i = 0; i < x.length; ++i) {
            r[i] = new double[x[i].length][];
            for (int j = 0; j < r[i].length; ++j) {
                r[i][j] = new double[x[i][j].length];
                for (int k = 0; k < r[i][j].length; ++k) {
                    r[i][j][k] = x[i][j][k];
                }
            }
        }
        return r;
    }

    double[][][] gradient(FUN f, double[][][] x) {
        boolean debug = false;
        double[][][] G = new double[x.length][x[0].length][x[0][0].length];
        double[][] y = new double[this.outputs.length][this.outputs[0].length];
        for (int k = 0; k < this.inputs.length; ++k) {
            y[k] = this.quadraticModelOutput(this.inputs[k], x);
        }
        for (int s = 0; s < x.length; ++s) {
            int tmp = x[s].length - 1;
            for (int alfa = 0; alfa < tmp; ++alfa) {
                for (int beta = 0; beta < tmp; ++beta) {
                    G[s][alfa][beta] = 0.0;
                    for (int k = 0; k < this.inputs.length; ++k) {
                        double[] dArray = G[s][alfa];
                        int n = beta;
                        dArray[n] = dArray[n] + 2.0 * (this.outputs[k][s] - y[k][s]) * this.inputs[k][alfa] * this.inputs[k][beta];
                    }
                }
            }
            for (int beta = 0; beta < tmp; ++beta) {
                G[s][tmp][beta] = 0.0;
                for (int k = 0; k < this.inputs.length; ++k) {
                    double[] dArray = G[s][tmp];
                    int n = beta;
                    dArray[n] = dArray[n] + 2.0 * (this.outputs[k][s] - y[k][s]) * this.inputs[k][beta];
                }
            }
        }
        for (int i = 0; i < G.length; ++i) {
            for (int j = 0; j < G[i].length; ++j) {
                int k = 0;
                while (k < G[i][j].length) {
                    double[] dArray = G[i][j];
                    int n = k++;
                    dArray[n] = dArray[n] * (-1.0 / (double)this.inputs.length);
                }
            }
        }
        if (debug) {
            System.out.println("Gradiente=" + this.AString(G));
            double[][][] H = this.numericalGradient(f, x);
            System.out.println("Gradiente numerico=" + this.AString(H));
        }
        return G;
    }

    public double[] quadraticModelOutput(double[] x, double[][][] W) {
        double[] sal = new double[W.length];
        for (int s = 0; s < W.length; ++s) {
            int i;
            int tmp = W[s].length - 1;
            sal[s] = 0.0;
            for (i = 0; i < tmp; ++i) {
                double v = 0.0;
                for (int j = 0; j < tmp; ++j) {
                    v += x[j] * W[s][i][j];
                }
                int n = s;
                sal[n] = sal[n] + v * x[i];
            }
            for (i = 0; i < W[s][tmp].length; ++i) {
                int n = s;
                sal[n] = sal[n] + W[s][tmp][i] * x[i];
            }
        }
        return sal;
    }

    private double rnd(double low, double high) {
        return r.Rand() * (high - low) + low;
    }

    double[][][] conjugatedGradient(FUN ferr, double TOL_ERR, double MIN_DELTAGC, int MAX_ITER) {
        double[][][] gr;
        System.out.println("Dentro " + MIN_DELTAGC);
        int NVAR = 0;
        double last_err = 0.0;
        double err = 0.0;
        double[][][] x = new double[this.outputs[0].length][this.inputs[0].length + 1][this.inputs[0].length];
        this.randomWeights(x, 1.0);
        System.out.println("X inicial=" + this.AString(x));
        for (int i = 0; i < x.length; ++i) {
            NVAR += x[i].length * x[i][0].length;
        }
        int iter = 0;
        int subiter = 0;
        double alpha = 0.0;
        boolean restart = true;
        boolean debug = false;
        double[][][] g_old = this.gradient(ferr, x);
        double[][][] d = ConjGradQUAD.duplicate(g_old);
        do {
            if (debug) {
                System.out.println("X=" + this.AString(x));
                System.out.println("g_old=" + this.AString(g_old));
            }
            gr = this.gradient(ferr, x);
            if (restart) {
                d = OPV.signChange(gr);
                restart = false;
                subiter = 0;
            } else {
                double beta = OPV.multiply(OPV.subtract(gr, g_old), gr) / OPV.multiply(g_old, g_old);
                d = OPV.subtract(OPV.multiply(beta, d), gr);
            }
            double dgr = Math.sqrt(OPV.multiply(d, d));
            double[][][] xSearch = ConjGradQUAD.duplicate(x);
            double[][][] dSearch = OPV.multiply(1.0 / dgr, ConjGradQUAD.duplicate(d));
            LinearSearchBrent BL = new LinearSearchBrent(ferr, dSearch, xSearch);
            alpha = BL.minimumSearch(r);
            if (alpha == 0.0) {
                restart = true;
                System.out.println("Restart");
            } else {
                x = OPV.sum(x, OPV.multiply(alpha, dSearch));
                g_old = ConjGradQUAD.duplicate(gr);
                ++iter;
                if (++subiter >= NVAR) {
                    restart = true;
                }
            }
            err = ferr.evaluate(x);
            System.out.println("Iteracion=" + iter / NVAR + " alfa=" + alpha + " ECM=" + err + " Norma del gradiente " + dgr);
            last_err = err;
            if (!(alpha < 1.0E-4 * dgr)) continue;
            System.out.println("return: alpha<" + 1.0E-4 * dgr + "=" + alpha);
            break;
        } while (Math.sqrt(OPV.multiply(gr, gr)) > TOL_ERR * (double)gr.length && iter < MAX_ITER);
        return x;
    }

    void randomWeights(double[][][] weights, double x) {
        for (int i = 0; i < weights.length; ++i) {
            for (int j = 0; j < weights[i].length; ++j) {
                for (int k = 0; k < weights[i][j].length; ++k) {
                    weights[i][j][k] = this.rnd(-x, x);
                }
            }
        }
    }

    String AString(double[] x) {
        String result = "[";
        for (int i = 0; i < x.length - 1; ++i) {
            result = result + x[i] + " ";
        }
        result = result + x[x.length - 1];
        result = result + "]";
        return result;
    }

    String AString(double[][] x) {
        String result = "";
        for (int i = 0; i < x.length; ++i) {
            result = result + this.AString(x[i]);
        }
        return result;
    }

    String AString(double[][][] x) {
        String result = "";
        for (int i = 0; i < x.length; ++i) {
            result = result + this.AString(x[i]);
        }
        return result;
    }
}

