/*
 * Decompiled with CFR 0.152.
 */
package keel.Algorithms.UnsupervisedLearning.AssociationRules.IntervalRuleLearning.QAR_CIP_NSGAII;

import keel.Algorithms.UnsupervisedLearning.AssociationRules.IntervalRuleLearning.QAR_CIP_NSGAII.myDataset;
import org.core.Randomize;

public class Gene {
    public static final int NOT_INVOLVED = -1;
    public static final int ANTECEDENT = 0;
    public static final int CONSEQUENT = 1;
    private int attr;
    private int ac;
    private boolean pn;
    private double lb;
    private double ub;

    public Gene copy() {
        Gene gene = new Gene();
        gene.attr = this.attr;
        gene.ac = this.ac;
        gene.pn = this.pn;
        gene.lb = this.lb;
        gene.ub = this.ub;
        return gene;
    }

    public void invert(int type, double min_attr, double max_attr) {
        switch (this.ac) {
            case -1: {
                this.ac = 0;
                break;
            }
            case 0: {
                this.ac = 1;
                break;
            }
            case 1: {
                this.ac = -1;
            }
        }
        boolean bl = this.pn = !this.pn;
        if (type != 0) {
            if (type == 2) {
                this.lb = Randomize.RandClosed() * (this.lb - min_attr) + min_attr;
                this.ub = Randomize.RandClosed() * (max_attr - this.ub) + this.ub;
            } else {
                this.lb = Randomize.RandintClosed((int)min_attr, (int)this.lb);
                this.ub = Randomize.RandintClosed((int)this.ub, (int)max_attr);
            }
        } else if (this.lb == max_attr) {
            this.lb = this.ub = min_attr;
        } else {
            this.lb += 1.0;
            this.ub += 1.0;
        }
    }

    public int getActAs() {
        return this.ac;
    }

    public void setActAs(int ac) {
        this.ac = ac;
    }

    public boolean getIsPositiveInterval() {
        return this.pn;
    }

    public void setIsPositiveInterval(boolean pn) {
        this.pn = pn;
    }

    public double getLowerBound() {
        return this.lb;
    }

    public void setLowerBound(double lb) {
        this.lb = lb;
    }

    public double getUpperBound() {
        return this.ub;
    }

    public void setUpperBound(double ub) {
        this.ub = ub;
    }

    public boolean equals(Gene g) {
        return g.attr == this.attr && g.ac == this.ac && g.pn == this.pn && Math.abs(g.lb - this.lb) <= 1.0E-5 && Math.abs(g.ub - this.ub) <= 1.0E-5;
    }

    public String toString() {
        return "Attr: " + this.attr + "AC: " + this.ac + "; PN: " + this.pn + "; LB: " + this.lb + "; UB: " + this.ub;
    }

    public int getAttr() {
        return this.attr;
    }

    public void setAttr(int var) {
        this.attr = var;
    }

    public int randAct() {
        return Randomize.RandintClosed(-1, 1);
    }

    public void tuneInterval(myDataset dataset, int[] covered) {
        int nData = dataset.getnTrans();
        double min = this.ub;
        double max = this.lb;
        for (int i = 0; i < nData; ++i) {
            if (covered[i] <= 0) continue;
            double[] example = dataset.getExample(i);
            if (example[this.attr] < min) {
                min = example[this.attr];
            }
            if (!(example[this.attr] > max)) continue;
            max = example[this.attr];
        }
        this.ub = max;
        this.lb = min;
    }

    public boolean isCover(int var, double value) {
        if (this.attr != var) {
            return false;
        }
        boolean covered = true;
        if (this.pn) {
            if (value < this.lb || value > this.ub) {
                covered = false;
            }
        } else if (value >= this.lb && value <= this.ub) {
            covered = false;
        }
        return covered;
    }

    public boolean isSubGen(Gene gen) {
        if (this.attr != gen.attr) {
            return false;
        }
        if (this.pn != gen.pn) {
            return false;
        }
        if (this.ac != gen.ac) {
            return false;
        }
        if (Math.abs(gen.lb - this.lb) > 1.0E-5) {
            return false;
        }
        return !(Math.abs(gen.ub - this.ub) > 1.0E-5);
    }
}

