/*
 * Decompiled with CFR 0.152.
 */
package weka.gui;

import javax.swing.DefaultListModel;
import javax.swing.JList;

public class JListHelper {
    public static final int MOVE_UP = 0;
    public static final int MOVE_DOWN = 1;

    protected static void moveItems(JList jList, int n, int n2) {
        DefaultListModel defaultListModel = (DefaultListModel)jList.getModel();
        switch (n2) {
            case 0: {
                int[] nArray = jList.getSelectedIndices();
                for (int i = 0; i < nArray.length; ++i) {
                    if (nArray[i] == 0) continue;
                    Object e = defaultListModel.remove(nArray[i]);
                    int n3 = i;
                    nArray[n3] = nArray[n3] - n;
                    defaultListModel.insertElementAt(e, nArray[i]);
                }
                jList.setSelectedIndices(nArray);
                break;
            }
            case 1: {
                int[] nArray = jList.getSelectedIndices();
                for (int i = nArray.length - 1; i >= 0; --i) {
                    if (nArray[i] == defaultListModel.getSize() - 1) continue;
                    Object e = defaultListModel.remove(nArray[i]);
                    int n4 = i;
                    nArray[n4] = nArray[n4] + n;
                    defaultListModel.insertElementAt(e, nArray[i]);
                }
                jList.setSelectedIndices(nArray);
                break;
            }
            default: {
                System.err.println(JListHelper.class.getName() + ": direction '" + n2 + "' is unknown!");
            }
        }
    }

    public static void moveUp(JList jList) {
        if (JListHelper.canMoveUp(jList)) {
            JListHelper.moveItems(jList, 1, 0);
        }
    }

    public static void moveDown(JList jList) {
        if (JListHelper.canMoveDown(jList)) {
            JListHelper.moveItems(jList, 1, 1);
        }
    }

    public static void moveTop(JList jList) {
        if (JListHelper.canMoveUp(jList)) {
            int[] nArray = jList.getSelectedIndices();
            int n = nArray[0];
            JListHelper.moveItems(jList, n, 0);
        }
    }

    public static void moveBottom(JList jList) {
        if (JListHelper.canMoveDown(jList)) {
            int[] nArray = jList.getSelectedIndices();
            int n = jList.getModel().getSize() - 1 - nArray[nArray.length - 1];
            JListHelper.moveItems(jList, n, 1);
        }
    }

    public static boolean canMoveUp(JList jList) {
        boolean bl = false;
        int[] nArray = jList.getSelectedIndices();
        if (nArray.length > 0 && nArray[0] > 0) {
            bl = true;
        }
        return bl;
    }

    public static boolean canMoveDown(JList jList) {
        boolean bl = false;
        int[] nArray = jList.getSelectedIndices();
        if (nArray.length > 0 && nArray[nArray.length - 1] < jList.getModel().getSize() - 1) {
            bl = true;
        }
        return bl;
    }
}

