/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.modelling.arima.tramo;

import ec.tstoolkit.data.DataBlock;
import ec.tstoolkit.eco.Ols;
import ec.tstoolkit.eco.RegModel;
import ec.tstoolkit.modelling.DefaultTransformationType;
import ec.tstoolkit.modelling.arima.IPreprocessingModule;
import ec.tstoolkit.modelling.arima.ModellingContext;
import ec.tstoolkit.modelling.arima.PreprocessingModel;
import ec.tstoolkit.modelling.arima.ProcessingResult;
import java.util.Arrays;

public class RangeMeanTest
implements IPreprocessingModule {
    private PreprocessingModel model_;
    private boolean log_;
    private double tlog_ = 2.0;
    private double t;
    private int isj_;
    private int itrim_;

    @Override
    public ProcessingResult process(ModellingContext context) {
        double[] data = context.description.getY();
        for (int i = 0; i < data.length; ++i) {
            if (!(data[i] <= 0.0)) continue;
            return ProcessingResult.Unprocessed;
        }
        int ifreq = context.description.getFrequency();
        this.log_ = this.useLogs(ifreq, data);
        context.description.setTransformation(this.getTransformation());
        context.estimation = null;
        return ProcessingResult.Changed;
    }

    private void computeisj(int freq, int n) {
        this.itrim_ = 1;
        if (freq == 12) {
            this.isj_ = 12;
        } else if (freq == 6) {
            this.isj_ = 12;
            if (n <= 165) {
                this.itrim_ = 2;
            }
        } else if (freq == 4) {
            if (n > 165) {
                this.isj_ = 8;
            } else {
                this.isj_ = 12;
                this.itrim_ = 2;
            }
        } else if (freq == 3) {
            if (n > 165) {
                this.isj_ = 6;
            } else {
                this.isj_ = 12;
                this.itrim_ = 2;
            }
        } else if (freq == 2) {
            if (n > 165) {
                this.isj_ = 6;
            } else {
                this.isj_ = 12;
                this.itrim_ = 2;
            }
        } else if (freq == 1) {
            if (n > 165) {
                this.isj_ = 5;
            } else {
                this.isj_ = 9;
                this.itrim_ = 2;
            }
        } else {
            this.isj_ = freq;
        }
    }

    public double getTStat() {
        return this.t;
    }

    public double getTLog() {
        return this.tlog_;
    }

    public void setTLog(double value) {
        this.tlog_ = value;
    }

    public boolean useLogs(int freq, double[] data) {
        int n = data.length;
        this.isj_ = 0;
        this.itrim_ = 0;
        this.computeisj(freq, n);
        int npoints = n / this.isj_;
        if (npoints <= 3) {
            return false;
        }
        double[] range = new double[npoints];
        double[] smean = new double[npoints];
        double[] srt = new double[this.isj_];
        for (int i = 0; i < npoints; ++i) {
            for (int j = 0; j < this.isj_; ++j) {
                srt[j] = data[j + i * this.isj_];
            }
            Arrays.sort(srt);
            range[i] = srt[this.isj_ - this.itrim_ - 1] - srt[this.itrim_];
            double s = srt[this.itrim_];
            for (int j = this.itrim_ + 1; j < this.isj_ - this.itrim_; ++j) {
                s += srt[j];
            }
            smean[i] = s /= (double)(this.isj_ - 2 * this.itrim_);
        }
        Ols ols = new Ols();
        RegModel model = new RegModel();
        model.setY(new DataBlock(range));
        model.addX(new DataBlock(smean));
        model.setMeanCorrection(true);
        if (ols.process(model)) {
            this.t = ols.getLikelihood().getTStats()[1];
            return this.t > this.tlog_;
        }
        this.t = 0.0;
        return false;
    }

    public DefaultTransformationType getTransformation() {
        return this.log_ ? DefaultTransformationType.Log : DefaultTransformationType.None;
    }

    public boolean hasChangedModel() {
        return true;
    }

    public PreprocessingModel retrieveModel() {
        PreprocessingModel model = this.model_;
        this.model_ = null;
        return model;
    }
}

