/*
 * Decompiled with CFR 0.152.
 */
package umontreal.iro.lecuyer.simevents.eventlist;

import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import umontreal.iro.lecuyer.simevents.Event;
import umontreal.iro.lecuyer.simevents.eventlist.EventList;
import umontreal.iro.lecuyer.util.PrintfFormat;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BinaryTree
implements EventList {
    private Entry root = null;
    private Entry freeEntries = null;
    private int modCount = 0;

    @Override
    public boolean isEmpty() {
        return this.root == null;
    }

    @Override
    public void clear() {
        while (this.root != null) {
            this.remove(this.root);
        }
    }

    @Override
    public void add(Event event) {
        Entry entry = this.root;
        boolean bl = false;
        double d = event.time();
        if (entry == null) {
            this.root = this.add(event, null);
        } else {
            while (!bl) {
                if (d < entry.event.time()) {
                    if (entry.left == null) {
                        entry.left = this.add(event, entry);
                        bl = true;
                    }
                    entry = entry.left;
                    continue;
                }
                if (entry.right == null) {
                    entry.right = this.add(event, entry);
                    bl = true;
                }
                entry = entry.right;
            }
        }
        ++this.modCount;
    }

    @Override
    public void addFirst(Event event) {
        Entry entry = this.root;
        if (entry != null) {
            while (entry.left != null) {
                entry = entry.left;
            }
            Entry entry2 = this.add(event, entry.father);
            entry2.right = entry;
            if (entry == this.root) {
                this.root = entry2;
            } else {
                entry.father.left = entry2;
            }
            entry.father = entry2;
        } else {
            this.root = this.add(event, null);
        }
        ++this.modCount;
    }

    @Override
    public void addBefore(Event event, Event event2) {
        Entry entry = this.findEntry(event2);
        Entry entry2 = this.add(event, null);
        if (entry == null) {
            throw new IllegalArgumentException("other not in the tree");
        }
        if (entry != this.root) {
            if (entry == entry.father.right) {
                entry.father.right = entry2;
            } else {
                entry.father.left = entry2;
            }
        } else {
            this.root = entry2;
        }
        entry2.father = entry.father;
        entry.father = entry2;
        entry2.right = entry;
        entry2.left = entry.left;
        if (entry2.left != null) {
            entry2.left.father = entry2;
        }
        entry.left = null;
        ++this.modCount;
    }

    @Override
    public void addAfter(Event event, Event event2) {
        Entry entry = this.findEntry(event2);
        if (entry == null) {
            throw new IllegalArgumentException("other not in the tree");
        }
        Entry entry2 = this.add(event, entry);
        entry2.right = entry.right;
        entry.right = entry2;
        if (entry2.right != null) {
            entry2.right.father = entry2;
        }
        ++this.modCount;
    }

    @Override
    public Event getFirst() {
        if (this.root == null) {
            return null;
        }
        Entry entry = this.root;
        while (entry.left != null) {
            entry = entry.left;
        }
        return entry.event;
    }

    @Override
    public Event getFirstOfClass(String string) {
        Entry entry = this.root;
        if (this.root != null) {
            while (entry.left != null) {
                entry = entry.left;
            }
        }
        while (entry != null) {
            if (entry.event.getClass().getName().equals(string)) {
                return entry.event;
            }
            entry = this.successor(entry);
        }
        return null;
    }

    @Override
    public <E extends Event> E getFirstOfClass(Class<E> clazz) {
        Entry entry = this.root;
        if (this.root != null) {
            while (entry.left != null) {
                entry = entry.left;
            }
        }
        while (entry != null) {
            if (entry.event.getClass() == clazz) {
                return (E)entry.event;
            }
            entry = this.successor(entry);
        }
        return null;
    }

    @Override
    public Iterator<Event> iterator() {
        return this.listIterator();
    }

    @Override
    public ListIterator<Event> listIterator() {
        return new BTItr();
    }

    @Override
    public boolean remove(Event event) {
        Entry entry = this.findEntry(event);
        if (entry == null) {
            return false;
        }
        return this.remove(entry);
    }

    @Override
    public Event removeFirst() {
        if (this.root == null) {
            return null;
        }
        Entry entry = this.root;
        while (entry.left != null) {
            entry = entry.left;
        }
        Event event = entry.event;
        this.remove(entry);
        return event;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("Contents of the event list BinaryTree :");
        Entry entry = this.root;
        if (this.root != null) {
            while (entry.left != null) {
                entry = entry.left;
            }
        }
        while (entry != null) {
            stringBuffer.append("\n" + PrintfFormat.g(8, 4, entry.event.time()) + " : " + entry.event.toString());
            entry = this.successor(entry);
        }
        return stringBuffer.toString();
    }

    private Entry add(Event event, Entry entry) {
        if (this.freeEntries != null) {
            Entry entry2 = this.freeEntries;
            this.freeEntries = this.freeEntries.right;
            entry2.event = event;
            entry2.left = null;
            entry2.right = null;
            entry2.father = entry;
            return entry2;
        }
        return new Entry(event, null, null, entry);
    }

    private boolean remove(Entry entry) {
        boolean bl = false;
        boolean bl2 = false;
        if (entry == this.root) {
            bl2 = true;
        } else {
            bl = entry == entry.father.left;
        }
        if (entry.left == null) {
            if (bl2) {
                this.root = entry.right;
            } else if (bl) {
                entry.father.left = entry.right;
            } else {
                entry.father.right = entry.right;
            }
            if (entry.right != null) {
                entry.right.father = entry.father;
            }
        } else if (entry.right == null) {
            if (bl2) {
                this.root = entry.left;
            } else if (bl) {
                entry.father.left = entry.left;
            } else {
                entry.father.right = entry.left;
            }
            entry.left.father = entry.father;
        } else {
            Entry entry2 = entry.right;
            if (entry2.left == null) {
                if (bl2) {
                    this.root = entry2;
                } else if (bl) {
                    entry.father.left = entry2;
                } else {
                    entry.father.right = entry2;
                }
                entry2.left = entry.left;
            } else {
                while (entry2.left != null) {
                    entry2 = entry2.left;
                }
                entry2.father.left = entry2.right;
                if (bl2) {
                    this.root = entry2;
                } else if (bl) {
                    entry.father.left = entry2;
                } else {
                    entry.father.right = entry2;
                }
                entry2.father.left = entry2.right;
                if (entry2.right != null) {
                    entry2.right.father = entry2.father;
                }
                entry2.right = entry.right;
                entry2.left = entry.left;
                entry.right.father = entry2;
            }
            entry2.father = entry.father;
            entry.left.father = entry2;
        }
        entry.right = this.freeEntries;
        entry.left = null;
        entry.event = null;
        this.freeEntries = entry;
        entry = null;
        ++this.modCount;
        return true;
    }

    private Entry successor(Entry entry) {
        if (entry == null) {
            return null;
        }
        if (entry.right != null) {
            entry = entry.right;
            while (entry.left != null) {
                entry = entry.left;
            }
        } else {
            while (entry.father != null && entry.father.right == entry) {
                entry = entry.father;
            }
            entry = entry.father;
        }
        return entry;
    }

    private Entry findEntry(Event event) {
        Entry entry = this.root;
        double d = event.time();
        while (entry != null) {
            if (entry.event == event) {
                return entry;
            }
            if (d < entry.event.time()) {
                entry = entry.left;
                continue;
            }
            entry = entry.right;
        }
        return null;
    }

    private Entry predecessor(Entry entry) {
        if (entry == null) {
            return null;
        }
        if (entry.left != null) {
            entry = entry.left;
            while (entry.right != null) {
                entry = entry.right;
            }
        } else {
            while (entry.father != null && entry.father.left == entry) {
                entry = entry.father;
            }
            entry = entry.father;
        }
        return entry;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class BTItr
    implements ListIterator<Event> {
        private Entry prev = null;
        private Entry next;
        private Entry lastRet;
        private int expectedModCount;
        private int nextIndex;

        BTItr() {
            this.next = BinaryTree.this.root;
            if (this.next != null) {
                while (this.next.left != null) {
                    this.next = this.next.left;
                }
            }
            this.expectedModCount = BinaryTree.this.modCount;
            this.lastRet = null;
            this.nextIndex = 0;
        }

        @Override
        public void add(Event event) {
            if (BinaryTree.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
            if (this.next != null && event.time() > this.next.event.time()) {
                event.setTime(this.next.event.time());
            }
            if (this.prev != null && event.time() < this.prev.event.time()) {
                event.setTime(this.prev.event.time());
            }
            Entry entry = BinaryTree.this.add(event, this.next);
            if (this.prev != null) {
                entry.father = this.prev;
                entry.right = this.prev.right;
                this.prev.right = entry;
                if (entry.right != null) {
                    entry.right.father = entry;
                }
            } else {
                if (this.next != BinaryTree.this.root) {
                    if (this.next == this.next.father.left) {
                        this.next.father.left = entry;
                    } else {
                        this.next.father.right = entry;
                    }
                } else {
                    BinaryTree.this.root = entry;
                }
                entry.father = this.prev.father;
                this.prev.father = entry;
                entry.left = this.prev;
                entry.right = this.prev.right;
                if (entry.right != null) {
                    entry.right.father = entry;
                }
                this.prev.right = null;
            }
            this.prev = entry;
            ++this.nextIndex;
            this.lastRet = null;
            ++BinaryTree.this.modCount;
            ++this.expectedModCount;
        }

        @Override
        public boolean hasNext() {
            if (BinaryTree.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
            return this.next != null;
        }

        @Override
        public boolean hasPrevious() {
            if (BinaryTree.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
            return this.prev != null;
        }

        @Override
        public Event next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            ++this.nextIndex;
            Event event = this.next.event;
            this.lastRet = this.next;
            this.prev = this.next;
            this.next = BinaryTree.this.successor(this.next);
            return event;
        }

        @Override
        public int nextIndex() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            return this.nextIndex;
        }

        @Override
        public Event previous() {
            if (!this.hasPrevious()) {
                throw new NoSuchElementException();
            }
            --this.nextIndex;
            Event event = this.prev.event;
            this.lastRet = this.prev;
            this.next = this.prev;
            this.prev = BinaryTree.this.predecessor(this.prev);
            return event;
        }

        @Override
        public int previousIndex() {
            if (!this.hasPrevious()) {
                throw new NoSuchElementException();
            }
            return this.nextIndex - 1;
        }

        @Override
        public void remove() {
            if (BinaryTree.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
            if (this.lastRet == null) {
                throw new IllegalStateException();
            }
            if (this.lastRet == this.next) {
                this.next = BinaryTree.this.successor(this.next);
            } else {
                this.prev = BinaryTree.this.predecessor(this.prev);
                --this.nextIndex;
            }
            BinaryTree.this.remove(this.lastRet);
            this.lastRet = null;
            ++this.expectedModCount;
        }

        @Override
        public void set(Event event) {
            if (BinaryTree.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
            if (this.lastRet == null) {
                throw new IllegalStateException();
            }
            Entry entry = BinaryTree.this.predecessor(this.lastRet);
            Entry entry2 = BinaryTree.this.successor(this.lastRet);
            if (entry != null && event.time() < entry.event.time()) {
                event.setTime(entry.event.time());
            }
            if (entry2 != null && event.time() > entry2.event.time()) {
                event.setTime(entry2.event.time());
            }
            this.lastRet.event = event;
        }
    }

    private static class Entry {
        Event event;
        Entry right;
        Entry left;
        Entry father;

        Entry(Event event, Entry entry, Entry entry2, Entry entry3) {
            this.event = event;
            this.left = entry;
            this.right = entry2;
            this.father = entry3;
        }
    }
}

