/*
 * Decompiled with CFR 0.152.
 */
package me.lemire.integercompression.benchmarktools;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.PrintWriter;
import java.util.Arrays;
import me.lemire.integercompression.BinaryPacking;
import me.lemire.integercompression.FastPFOR;
import me.lemire.integercompression.FastPFOR128;
import me.lemire.integercompression.IntWrapper;
import me.lemire.integercompression.JustCopy;
import me.lemire.integercompression.NewPFD;
import me.lemire.integercompression.NewPFDS16;
import me.lemire.integercompression.NewPFDS9;
import me.lemire.integercompression.OptPFD;
import me.lemire.integercompression.OptPFDS16;
import me.lemire.integercompression.OptPFDS9;
import me.lemire.integercompression.Simple16;
import me.lemire.integercompression.Simple9;
import me.lemire.integercompression.SkippableComposition;
import me.lemire.integercompression.SkippableIntegerCODEC;
import me.lemire.integercompression.VariableByte;
import me.lemire.integercompression.differential.Delta;
import me.lemire.integercompression.differential.IntegratedBinaryPacking;
import me.lemire.integercompression.differential.IntegratedVariableByte;
import me.lemire.integercompression.differential.SkippableIntegratedComposition;
import me.lemire.integercompression.differential.SkippableIntegratedIntegerCODEC;
import me.lemire.integercompression.synth.ClusteredDataGenerator;

public class BenchmarkSkippable {
    static Object[] codecs = new Object[]{new SkippableIntegratedComposition(new IntegratedBinaryPacking(), new IntegratedVariableByte()), new JustCopy(), new VariableByte(), new SkippableComposition(new BinaryPacking(), new VariableByte()), new SkippableComposition(new NewPFD(), new VariableByte()), new SkippableComposition(new NewPFDS9(), new VariableByte()), new SkippableComposition(new NewPFDS16(), new VariableByte()), new SkippableComposition(new OptPFD(), new VariableByte()), new SkippableComposition(new OptPFDS9(), new VariableByte()), new SkippableComposition(new OptPFDS16(), new VariableByte()), new SkippableComposition(new FastPFOR(), new VariableByte()), new SkippableComposition(new FastPFOR128(), new VariableByte()), new Simple9(), new Simple16()};

    private static int compressWithSkipTable(Object c, int[] data, int[] output, IntWrapper outpos, int[] metadata, int blocksize) {
        int metapos = 0;
        metadata[metapos++] = data.length;
        IntWrapper inpos = new IntWrapper();
        int initvalue = 0;
        IntWrapper ival = new IntWrapper(initvalue);
        while (inpos.get() < data.length) {
            metadata[metapos++] = outpos.get();
            metadata[metapos++] = initvalue;
            if (c instanceof SkippableIntegerCODEC) {
                int size = blocksize > data.length - inpos.get() ? data.length - inpos.get() : blocksize;
                initvalue = Delta.delta(data, inpos.get(), size, initvalue);
                ((SkippableIntegerCODEC)c).headlessCompress(data, inpos, blocksize, output, outpos);
                continue;
            }
            if (c instanceof SkippableIntegratedIntegerCODEC) {
                ival.set(initvalue);
                ((SkippableIntegratedIntegerCODEC)c).headlessCompress(data, inpos, blocksize, output, outpos, ival);
                initvalue = ival.get();
                continue;
            }
            throw new RuntimeException("Unrecognized codec " + c);
        }
        return metapos;
    }

    private static int decompressFromSkipTable(Object c, int[] compressed, IntWrapper compressedpos, int[] metadata, int blocksize, int[] data) {
        int metapos = 0;
        int length = metadata[metapos++];
        IntWrapper uncomppos = new IntWrapper();
        IntWrapper ival = new IntWrapper();
        while (uncomppos.get() < length) {
            int num = blocksize;
            if (num > length - uncomppos.get()) {
                num = length - uncomppos.get();
            }
            int location = metadata[metapos++];
            int initvalue = metadata[metapos++];
            int outputlocation = uncomppos.get();
            if (location != compressedpos.get()) {
                throw new RuntimeException("Bug " + location + " " + compressedpos.get() + " codec " + c);
            }
            if (c instanceof SkippableIntegerCODEC) {
                ((SkippableIntegerCODEC)c).headlessUncompress(compressed, compressedpos, compressed.length - uncomppos.get(), data, uncomppos, num);
                initvalue = Delta.fastinverseDelta(data, outputlocation, num, initvalue);
                continue;
            }
            if (c instanceof SkippableIntegratedIntegerCODEC) {
                ival.set(initvalue);
                ((SkippableIntegratedIntegerCODEC)c).headlessUncompress(compressed, compressedpos, compressed.length - uncomppos.get(), data, uncomppos, num, ival);
                continue;
            }
            throw new RuntimeException("Unrecognized codec " + c);
        }
        return length;
    }

    private static void testCodec(PrintWriter csvLog, int sparsity, Object c, int[][] data, int repeat, boolean verbose) {
        if (verbose) {
            System.out.println("# " + c.toString());
            System.out.println("# bits per int, compress speed (mis), decompression speed (mis) ");
        }
        int N = data.length;
        int totalSize = 0;
        int maxLength = 0;
        for (int k = 0; k < N; ++k) {
            totalSize += data[k].length;
            if (data[k].length <= maxLength) continue;
            maxLength = data[k].length;
        }
        int[] compressBuffer = new int[4 * maxLength + 1024];
        int[] decompressBuffer = new int[maxLength + 1024];
        int[] metadataBuffer = new int[maxLength];
        int blocksize = 1024;
        double compressTime = 0.0;
        double decompressTime = 0.0;
        int times = 5;
        int size = 0;
        for (int r = 0; r < repeat; ++r) {
            size = 0;
            for (int k = 0; k < N; ++k) {
                int[] backupdata = Arrays.copyOf(data[k], data[k].length);
                long beforeCompress = System.nanoTime() / 1000L;
                IntWrapper outpos = new IntWrapper();
                BenchmarkSkippable.compressWithSkipTable(c, backupdata, compressBuffer, outpos, metadataBuffer, 1024);
                long afterCompress = System.nanoTime() / 1000L;
                compressTime += (double)(afterCompress - beforeCompress);
                int thiscompsize = outpos.get();
                size += thiscompsize;
                int volume = 0;
                IntWrapper compressedpos = new IntWrapper(0);
                volume = BenchmarkSkippable.decompressFromSkipTable(c, compressBuffer, compressedpos, metadataBuffer, 1024, decompressBuffer);
                if (volume != backupdata.length) {
                    throw new RuntimeException("Bad output size with codec " + c);
                }
                for (int j = 0; j < volume; ++j) {
                    if (data[k][j] == decompressBuffer[j]) continue;
                    throw new RuntimeException("bug in codec " + c);
                }
                long beforeDecompress = System.nanoTime() / 1000L;
                for (int t = 0; t < 5; ++t) {
                    IntWrapper compressedpos2 = new IntWrapper(0);
                    volume = BenchmarkSkippable.decompressFromSkipTable(c, compressBuffer, compressedpos2, metadataBuffer, 1024, decompressBuffer);
                }
                long afterDecompress = System.nanoTime() / 1000L;
                decompressTime += (double)((afterDecompress - beforeDecompress) / 5L);
                if (volume != data[k].length) {
                    throw new RuntimeException("we have a bug (diff length) " + c + " expected " + data[k].length + " got " + volume);
                }
                for (int m = 0; m < outpos.get(); ++m) {
                    if (decompressBuffer[m] == data[k][m]) continue;
                    throw new RuntimeException("we have a bug (actual difference), expected " + data[k][m] + " found " + decompressBuffer[m] + " at " + m);
                }
            }
        }
        if (verbose) {
            double bitsPerInt = (double)size * 32.0 / (double)totalSize;
            long compressSpeed = Math.round((double)(totalSize * repeat) / compressTime);
            long decompressSpeed = Math.round((double)(totalSize * repeat) / decompressTime);
            System.out.println(String.format("\t%1$.2f\t%2$d\t%3$d", bitsPerInt, compressSpeed, decompressSpeed));
            csvLog.format("\"%1$s\",%2$d,%3$.2f,%4$d,%5$d\n", c.toString(), sparsity, bitsPerInt, compressSpeed, decompressSpeed);
            csvLog.flush();
        }
    }

    public static void main(String[] args) throws FileNotFoundException {
        System.out.println("# benchmark based on the ClusterData model from:");
        System.out.println("# \t Vo Ngoc Anh and Alistair Moffat. ");
        System.out.println("#\t Index compression using 64-bit words.");
        System.out.println("# \t Softw. Pract. Exper.40, 2 (February 2010), 131-147. ");
        System.out.println();
        PrintWriter writer = null;
        try {
            File csvFile = new File(String.format("benchmark-%1$tY%1$tm%1$tdT%1$tH%1$tM%1$tS.csv", System.currentTimeMillis()));
            writer = new PrintWriter(csvFile);
            System.out.println("# Results will be written into a CSV file: " + csvFile.getName());
            System.out.println();
            BenchmarkSkippable.test(writer, 20, 18, 10);
            System.out.println();
            System.out.println("Results were written into a CSV file: " + csvFile.getName());
        }
        finally {
            if (writer != null) {
                writer.close();
            }
        }
    }

    private static int[][] generateTestData(ClusteredDataGenerator dataGen, int N, int nbr, int sparsity) {
        int[][] data = new int[N][];
        int dataSize = 1 << nbr + sparsity;
        for (int i = 0; i < N; ++i) {
            data[i] = dataGen.generateClustered(1 << nbr, dataSize);
        }
        return data;
    }

    private static void test(PrintWriter csvLog, int N, int nbr, int repeat) {
        csvLog.format("\"Algorithm\",\"Sparsity\",\"Bits per int\",\"Compress speed (MiS)\",\"Decompress speed (MiS)\"\n", new Object[0]);
        ClusteredDataGenerator cdg = new ClusteredDataGenerator();
        int max_sparsity = 31 - nbr;
        for (int sparsity = 1; sparsity < max_sparsity; sparsity += 4) {
            System.out.println("# sparsity " + sparsity);
            System.out.println("# generating random data...");
            int[][] data = BenchmarkSkippable.generateTestData(cdg, N, nbr, sparsity);
            System.out.println("# generating random data... ok.");
            for (Object c : codecs) {
                BenchmarkSkippable.testCodec(csvLog, sparsity, c, data, repeat, false);
                BenchmarkSkippable.testCodec(csvLog, sparsity, c, data, repeat, false);
                BenchmarkSkippable.testCodec(csvLog, sparsity, c, data, repeat, true);
                BenchmarkSkippable.testCodec(csvLog, sparsity, c, data, repeat, true);
                BenchmarkSkippable.testCodec(csvLog, sparsity, c, data, repeat, true);
            }
        }
    }
}

