/*
 * Decompiled with CFR 0.152.
 */
package org.openfast.util;

import org.openfast.util.IntegerMap;

public class SimpleIntegerMap
implements IntegerMap {
    private static final int DEFAULT_INC_SIZE = 32;
    private Object[] table;
    private int firstKey;
    private final int incSize;

    public SimpleIntegerMap() {
        this(32);
    }

    public SimpleIntegerMap(int size) {
        this.incSize = size;
    }

    public void put(int key, Object object) {
        this.adjust(key);
        this.table[key - this.firstKey] = object;
    }

    private void adjust(int key) {
        if (this.table == null) {
            this.table = new Object[this.incSize];
            this.firstKey = key;
        } else if (this.firstKey > key) {
            Object[] originalTable = this.table;
            int diff = this.firstKey - key;
            this.table = new Object[originalTable.length + diff];
            System.arraycopy(originalTable, 0, this.table, diff, originalTable.length);
            this.firstKey = key;
        } else if (key >= this.firstKey + this.table.length) {
            Object[] originalTable = this.table;
            int diff = key - (this.firstKey + this.table.length);
            this.table = new Object[originalTable.length + diff + this.incSize];
            System.arraycopy(originalTable, 0, this.table, 0, originalTable.length);
        }
    }

    public Object get(int key) {
        if (this.undefined(key)) {
            return null;
        }
        return this.table[key - this.firstKey];
    }

    private boolean undefined(int key) {
        return this.table == null || key < this.firstKey || key >= this.table.length + this.firstKey;
    }

    public boolean containsKey(int key) {
        if (this.undefined(key)) {
            return false;
        }
        return this.table[key - this.firstKey] != null;
    }

    public Object remove(int key) {
        if (this.undefined(key)) {
            return null;
        }
        Object removed = this.table[key - this.firstKey];
        this.table[key - this.firstKey] = null;
        return removed;
    }
}

