/*
 * Decompiled with CFR 0.152.
 */
package org.openfast.util;

import java.io.IOException;
import java.io.InputStream;
import org.openfast.ByteUtil;

public class RecordingInputStream
extends InputStream {
    private byte[] buffer = new byte[1024];
    private int index = 0;
    private InputStream in;

    public RecordingInputStream(InputStream inputStream) {
        this.in = inputStream;
    }

    public int read() throws IOException {
        int read = this.in.read();
        this.buffer[this.index++] = (byte)read;
        if (this.index >= this.buffer.length) {
            byte[] tmp = new byte[this.buffer.length * 2];
            System.arraycopy(this.buffer, 0, tmp, 0, this.buffer.length);
            this.buffer = tmp;
        }
        return read;
    }

    public String toString() {
        return ByteUtil.convertByteArrayToBitString(this.buffer, this.index);
    }

    public byte[] getBuffer() {
        byte[] b = new byte[this.index];
        System.arraycopy(this.buffer, 0, b, 0, this.index);
        return b;
    }

    public void clear() {
        this.index = 0;
    }
}

