/*
 * Decompiled with CFR 0.152.
 */
package org.openfast.template.type.codec;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import org.openfast.ByteUtil;
import org.openfast.Global;
import org.openfast.ScalarValue;
import org.openfast.StringValue;
import org.openfast.error.FastConstants;
import org.openfast.template.type.codec.TypeCodec;

final class AsciiString
extends TypeCodec {
    private static final long serialVersionUID = 1L;
    private static final String ZERO_TERMINATOR = "\u0000";
    private static final byte[] ZERO_PREAMBLE = new byte[2];

    AsciiString() {
    }

    public byte[] encodeValue(ScalarValue value) {
        if (value == null || value.isNull()) {
            throw new IllegalStateException("Only nullable strings can represent null values.");
        }
        String string = value.toString();
        if (string != null && string.length() == 0) {
            return TypeCodec.NULL_VALUE_ENCODING;
        }
        if (string.startsWith(ZERO_TERMINATOR)) {
            return ZERO_PREAMBLE;
        }
        return string.getBytes();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ScalarValue decode(InputStream in) {
        ByteArrayOutputStream buffer = Global.getBuffer();
        try {
            int byt;
            do {
                if ((byt = in.read()) < 0) {
                    Global.handleError(FastConstants.END_OF_STREAM, "The end of the input stream has been reached.");
                    return null;
                }
                buffer.write(byt);
            } while ((byt & 0x80) == 0);
        }
        catch (IOException e) {
            Global.handleError(FastConstants.IO_ERROR, "A IO error has been encountered while decoding.", e);
            return null;
        }
        byte[] bytes = buffer.toByteArray();
        int n = bytes.length - 1;
        bytes[n] = (byte)(bytes[n] & 0x7F);
        if (bytes[0] != 0) {
            return new StringValue(new String(bytes));
        }
        if (!ByteUtil.isEmpty(bytes)) {
            Global.handleError(FastConstants.R9_STRING_OVERLONG, null);
        }
        if (bytes.length > 1 && bytes[1] == 0) {
            return new StringValue(ZERO_TERMINATOR);
        }
        return new StringValue("");
    }

    public ScalarValue fromString(String value) {
        return new StringValue(value);
    }

    public boolean equals(Object obj) {
        return obj != null && obj.getClass() == this.getClass();
    }
}

